/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.XMLObject;
import org.w3c.dom.Node;

class ObjectImpl
extends XMLStructureImpl
implements XMLObject {
    List<XMLStructure> content;
    private String id;
    private String mimeType;
    private String encoding;

    ObjectImpl(AlgorithmFactory f, List content, String id, String mime, String enc) {
        super(f);
        if (content == null || content.size() == 0) {
            this.content = null;
        } else {
            this.content = new ArrayList<XMLStructure>(content.size());
            for (XMLStructure obj : content) {
                this.content.add(obj);
            }
        }
        this.id = id;
        this.mimeType = mime;
        this.encoding = enc;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List getContent() {
        return this.content == null ? Collections.emptyList() : Collections.unmodifiableList(this.content);
    }

    public boolean equals(Object o) {
        boolean encodingsEqual;
        boolean idsEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof XMLObject)) {
            return false;
        }
        XMLObject oxo = (XMLObject)o;
        boolean bl = this.id == null ? oxo.getId() == null : (idsEqual = this.id.equals(oxo.getId()));
        boolean bl2 = this.encoding == null ? oxo.getEncoding() == null : (encodingsEqual = this.encoding.equals(oxo.getEncoding()));
        boolean mimeTypesEqual = this.mimeType == null ? oxo.getMimeType() == null : this.mimeType.equals(oxo.getMimeType());
        List<XMLStructure> oxoContent = oxo.getContent();
        boolean contentEqual = this.equalsContent(oxoContent);
        return idsEqual && encodingsEqual && mimeTypesEqual && contentEqual;
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        if (this.encoding != null) {
            result = 31 * result + this.encoding.hashCode();
        }
        if (this.mimeType != null) {
            result = 31 * result + this.mimeType.hashCode();
        }
        result = 31 * result + this.content.hashCode();
        return result;
    }

    private boolean equalsContent(List<XMLStructure> otherContent) {
        if (this.content.size() != otherContent.size()) {
            return false;
        }
        int osize = otherContent.size();
        for (int i = 0; i < osize; ++i) {
            XMLStructure oxs = otherContent.get(i);
            XMLStructure xs = this.content.get(i);
            if (oxs instanceof DOMStructure) {
                if (!(xs instanceof DOMStructure)) {
                    return false;
                }
                Node onode = ((DOMStructure)oxs).getNode();
                Node node = ((DOMStructure)xs).getNode();
                if (DOMUtil.nodesEqual(node, onode)) continue;
                return false;
            }
            if (xs.equals(oxs)) continue;
            return false;
        }
        return true;
    }
}

