/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import sun.nio.ch.PollSelectorProvider;
import sun.security.action.GetPropertyAction;

public class DefaultSelectorProvider {
    private DefaultSelectorProvider() {
    }

    private static SelectorProvider createProvider(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        try {
            return (SelectorProvider)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    public static SelectorProvider create() {
        String string;
        String[] stringArray;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string2.equals("SunOS")) {
            return DefaultSelectorProvider.createProvider("sun.nio.ch.DevPollSelectorProvider");
        }
        if (string2.equals("Linux")) {
            return DefaultSelectorProvider.createProvider("sun.nio.ch.EPollSelectorProvider");
        }
        if ("AIX".equals(string2) && (stringArray = (string = AccessController.doPrivileged(new GetPropertyAction("os.version"))).split("\\.", 0)).length >= 2) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                if (n > 5 || n == 5 && n2 >= 3) {
                    return DefaultSelectorProvider.createProvider("sun.nio.ch.PollsetSelectorProvider");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new PollSelectorProvider();
    }
}

