/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jmxremote;

import com.sun.jmx.remote.internal.RMIExporter;
import com.sun.jmx.remote.security.JMXPluggableAuthenticator;
import com.sun.jmx.remote.util.ClassLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.security.KeyStore;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import javax.security.auth.Subject;
import sun.management.Agent;
import sun.management.AgentConfigurationError;
import sun.management.ConnectorAddressLink;
import sun.management.FileSystem;
import sun.management.jmxremote.LocalRMIServerSocketFactory;
import sun.management.jmxremote.SingleEntryRegistry;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;

public final class ConnectorBootstrap {
    private static Registry registry = null;
    private static final ClassLogger log = new ClassLogger(ConnectorBootstrap.class.getPackage().getName(), "ConnectorBootstrap");

    public static void unexportRegistry() {
        try {
            if (registry != null) {
                UnicastRemoteObject.unexportObject(registry, true);
                registry = null;
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public static synchronized JMXConnectorServer initialize() {
        Properties properties = Agent.loadManagementProperties();
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("com.sun.management.jmxremote.port");
        return ConnectorBootstrap.startRemoteConnectorServer(string, properties);
    }

    public static synchronized JMXConnectorServer initialize(String string, Properties properties) {
        return ConnectorBootstrap.startRemoteConnectorServer(string, properties);
    }

    public static synchronized JMXConnectorServer startRemoteConnectorServer(String string, Properties properties) {
        Object object;
        int n;
        Object object2;
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.port", (Throwable)numberFormatException, string);
        }
        if (n2 < 0) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.port", string);
        }
        int n3 = 0;
        String string2 = properties.getProperty("com.sun.management.jmxremote.rmi.port");
        try {
            if (string2 != null) {
                n3 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.rmi.port", (Throwable)numberFormatException, string2);
        }
        if (n3 < 0) {
            throw new AgentConfigurationError("agent.err.invalid.jmxremote.rmi.port", string2);
        }
        String string3 = properties.getProperty("com.sun.management.jmxremote.authenticate", "true");
        boolean bl = Boolean.valueOf(string3);
        String string4 = properties.getProperty("com.sun.management.jmxremote.ssl", "true");
        boolean bl2 = Boolean.valueOf(string4);
        String string5 = properties.getProperty("com.sun.management.jmxremote.registry.ssl", "false");
        boolean bl3 = Boolean.valueOf(string5);
        String string6 = properties.getProperty("com.sun.management.jmxremote.ssl.enabled.cipher.suites");
        String[] stringArray = null;
        if (string6 != null) {
            object2 = new StringTokenizer(string6, ",");
            int n4 = ((StringTokenizer)object2).countTokens();
            stringArray = new String[n4];
            for (int i = 0; i < n4; ++i) {
                stringArray[i] = ((StringTokenizer)object2).nextToken();
            }
        }
        object2 = properties.getProperty("com.sun.management.jmxremote.ssl.enabled.protocols");
        String[] stringArray2 = null;
        if (object2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, ",");
            n = stringTokenizer.countTokens();
            stringArray2 = new String[n];
            for (int i = 0; i < n; i += 1) {
                stringArray2[i] = stringTokenizer.nextToken();
            }
        }
        String string7 = properties.getProperty("com.sun.management.jmxremote.ssl.need.client.auth", "false");
        n = Boolean.valueOf(string7).booleanValue() ? 1 : 0;
        String string8 = properties.getProperty("com.sun.management.jmxremote.ssl.config.file");
        String string9 = null;
        String string10 = null;
        String string11 = null;
        if (bl) {
            string9 = properties.getProperty("com.sun.management.jmxremote.login.config");
            if (string9 == null) {
                string10 = properties.getProperty("com.sun.management.jmxremote.password.file", ConnectorBootstrap.getDefaultFileName("jmxremote.password"));
                ConnectorBootstrap.checkPasswordFile(string10);
            }
            string11 = properties.getProperty("com.sun.management.jmxremote.access.file", ConnectorBootstrap.getDefaultFileName("jmxremote.access"));
            ConnectorBootstrap.checkAccessFile(string11);
        }
        String string12 = properties.getProperty("com.sun.management.jmxremote.host");
        if (log.debugOn()) {
            log.debug("startRemoteConnectorServer", Agent.getText("jmxremote.ConnectorBootstrap.starting") + "\n\t" + "com.sun.management.jmxremote.port" + "=" + n2 + (string12 == null ? "" : "\n\tcom.sun.management.jmxremote.host=" + string12) + "\n\t" + "com.sun.management.jmxremote.rmi.port" + "=" + n3 + "\n\t" + "com.sun.management.jmxremote.ssl" + "=" + bl2 + "\n\t" + "com.sun.management.jmxremote.registry.ssl" + "=" + bl3 + "\n\t" + "com.sun.management.jmxremote.ssl.config.file" + "=" + string8 + "\n\t" + "com.sun.management.jmxremote.ssl.enabled.cipher.suites" + "=" + string6 + "\n\t" + "com.sun.management.jmxremote.ssl.enabled.protocols" + "=" + (String)object2 + "\n\t" + "com.sun.management.jmxremote.ssl.need.client.auth" + "=" + (n != 0) + "\n\t" + "com.sun.management.jmxremote.authenticate" + "=" + bl + (bl ? (string9 == null ? "\n\tcom.sun.management.jmxremote.password.file=" + string10 : "\n\tcom.sun.management.jmxremote.login.config=" + string9) : "\n\t" + Agent.getText("jmxremote.ConnectorBootstrap.noAuthentication")) + (bl ? "\n\tcom.sun.management.jmxremote.access.file=" + string11 : "") + "");
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        JMXConnectorServer jMXConnectorServer = null;
        JMXServiceURL jMXServiceURL = null;
        try {
            object = ConnectorBootstrap.exportMBeanServer(mBeanServer, n2, n3, bl2, bl3, string8, stringArray, stringArray2, n != 0, bl, string9, string10, string11, string12);
            jMXConnectorServer = ((JMXConnectorServerData)object).jmxConnectorServer;
            jMXServiceURL = ((JMXConnectorServerData)object).jmxRemoteURL;
            log.config("startRemoteConnectorServer", Agent.getText("jmxremote.ConnectorBootstrap.ready", jMXServiceURL.toString()));
        }
        catch (Exception exception) {
            throw new AgentConfigurationError("agent.err.exception", (Throwable)exception, exception.toString());
        }
        try {
            object = new HashMap();
            object.put("remoteAddress", jMXServiceURL.toString());
            object.put("authenticate", string3);
            object.put("ssl", string4);
            object.put("sslRegistry", string5);
            object.put("sslNeedClientAuth", string7);
            ConnectorAddressLink.exportRemote((Map<String, String>)object);
        }
        catch (Exception exception) {
            log.debug("startRemoteConnectorServer", exception);
        }
        return jMXConnectorServer;
    }

    public static JMXConnectorServer startLocalConnectorServer() {
        System.setProperty("java.rmi.server.randomIDs", "true");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("com.sun.jmx.remote.rmi.exporter", new PermanentExporter());
        hashMap.put("jmx.remote.rmi.server.credential.types", new String[]{String[].class.getName(), String.class.getName()});
        String string = "localhost";
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (inetAddress == null || !inetAddress.isLoopbackAddress()) {
            string = "127.0.0.1";
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            String string2;
            boolean bl;
            JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", string, 0);
            Properties properties = Agent.getManagementProperties();
            if (properties == null) {
                properties = new Properties();
            }
            if (bl = Boolean.valueOf(string2 = properties.getProperty("com.sun.management.jmxremote.local.only", "true")).booleanValue()) {
                hashMap.put("jmx.remote.rmi.server.socket.factory", new LocalRMIServerSocketFactory());
            }
            JMXConnectorServer jMXConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, hashMap, mBeanServer);
            jMXConnectorServer.start();
            return jMXConnectorServer;
        }
        catch (Exception exception) {
            throw new AgentConfigurationError("agent.err.exception", (Throwable)exception, exception.toString());
        }
    }

    private static void checkPasswordFile(String string) {
        if (string == null || string.length() == 0) {
            throw new AgentConfigurationError("agent.err.password.file.notset");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.password.file.notfound", string);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.password.file.not.readable", string);
        }
        FileSystem fileSystem = FileSystem.open();
        try {
            if (fileSystem.supportsFileSecurity(file) && !fileSystem.isAccessUserOnly(file)) {
                String string2 = Agent.getText("jmxremote.ConnectorBootstrap.password.readonly", string);
                log.config("startRemoteConnectorServer", string2);
                throw new AgentConfigurationError("agent.err.password.file.access.notrestricted", string);
            }
        }
        catch (IOException iOException) {
            throw new AgentConfigurationError("agent.err.password.file.read.failed", (Throwable)iOException, string);
        }
    }

    private static void checkAccessFile(String string) {
        if (string == null || string.length() == 0) {
            throw new AgentConfigurationError("agent.err.access.file.notset");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.access.file.notfound", string);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.access.file.not.readable", string);
        }
    }

    private static void checkRestrictedFile(String string) {
        if (string == null || string.length() == 0) {
            throw new AgentConfigurationError("agent.err.file.not.set");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new AgentConfigurationError("agent.err.file.not.found", string);
        }
        if (!file.canRead()) {
            throw new AgentConfigurationError("agent.err.file.not.readable", string);
        }
        FileSystem fileSystem = FileSystem.open();
        try {
            if (fileSystem.supportsFileSecurity(file) && !fileSystem.isAccessUserOnly(file)) {
                String string2 = Agent.getText("jmxremote.ConnectorBootstrap.file.readonly", string);
                log.config("startRemoteConnectorServer", string2);
                throw new AgentConfigurationError("agent.err.file.access.not.restricted", string);
            }
        }
        catch (IOException iOException) {
            throw new AgentConfigurationError("agent.err.file.read.failed", (Throwable)iOException, string);
        }
    }

    private static String getDefaultFileName(String string) {
        String string2 = File.separator;
        return System.getProperty("java.home") + string2 + "lib" + string2 + "management" + string2 + string;
    }

    private static SslRMIServerSocketFactory createSslRMIServerSocketFactory(String string, String[] stringArray, String[] stringArray2, boolean bl, String string2) {
        if (string == null) {
            return new HostAwareSslSocketFactory(stringArray, stringArray2, bl, string2);
        }
        ConnectorBootstrap.checkRestrictedFile(string);
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Properties properties = new Properties();
            Object object6 = new FileInputStream(string);
            Object object7 = null;
            try {
                object5 = new BufferedInputStream((InputStream)object6);
                properties.load((InputStream)object5);
            }
            catch (Throwable throwable) {
                object7 = throwable;
                throw throwable;
            }
            finally {
                if (object6 != null) {
                    if (object7 != null) {
                        try {
                            ((InputStream)object6).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object7).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object6).close();
                    }
                }
            }
            object6 = properties.getProperty("javax.net.ssl.keyStore");
            object7 = properties.getProperty("javax.net.ssl.keyStorePassword", "");
            object5 = properties.getProperty("javax.net.ssl.trustStore");
            String string3 = properties.getProperty("javax.net.ssl.trustStorePassword", "");
            char[] cArray = null;
            if (((String)object7).length() != 0) {
                cArray = ((String)object7).toCharArray();
            }
            char[] cArray2 = null;
            if (string3.length() != 0) {
                cArray2 = string3.toCharArray();
            }
            KeyStore keyStore = null;
            if (object6 != null) {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                object4 = new FileInputStream((String)object6);
                object3 = null;
                try {
                    keyStore.load((InputStream)object4, cArray);
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    if (object4 != null) {
                        if (object3 != null) {
                            try {
                                ((FileInputStream)object4).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                        } else {
                            ((FileInputStream)object4).close();
                        }
                    }
                }
            }
            object4 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ((KeyManagerFactory)object4).init(keyStore, cArray);
            object3 = null;
            if (object5 != null) {
                object3 = KeyStore.getInstance(KeyStore.getDefaultType());
                object2 = new FileInputStream((String)object5);
                object = null;
                try {
                    ((KeyStore)object3).load((InputStream)object2, cArray2);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((FileInputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((FileInputStream)object2).close();
                        }
                    }
                }
            }
            object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object2).init((KeyStore)object3);
            object = SSLContext.getInstance("SSL");
            ((SSLContext)object).init(((KeyManagerFactory)object4).getKeyManagers(), ((TrustManagerFactory)object2).getTrustManagers(), null);
            return new HostAwareSslSocketFactory((SSLContext)object, stringArray, stringArray2, bl, string2);
        }
        catch (Exception exception) {
            throw new AgentConfigurationError("agent.err.exception", (Throwable)exception, exception.toString());
        }
    }

    private static JMXConnectorServerData exportMBeanServer(MBeanServer mBeanServer, int n, int n2, boolean bl, boolean bl2, String string, String[] stringArray, String[] stringArray2, boolean bl3, boolean bl4, String string2, String string3, String string4, String string5) throws IOException, MalformedURLException {
        boolean bl5;
        System.setProperty("java.rmi.server.randomIDs", "true");
        JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", string5, n2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PermanentExporter permanentExporter = new PermanentExporter();
        hashMap.put("com.sun.jmx.remote.rmi.exporter", permanentExporter);
        hashMap.put("jmx.remote.rmi.server.credential.types", new String[]{String[].class.getName(), String.class.getName()});
        boolean bl6 = bl5 = string5 != null && !bl;
        if (bl4) {
            if (string2 != null) {
                hashMap.put("jmx.remote.x.login.config", string2);
            }
            if (string3 != null) {
                hashMap.put("jmx.remote.x.password.file", string3);
            }
            hashMap.put("jmx.remote.x.access.file", string4);
            if (hashMap.get("jmx.remote.x.password.file") != null || hashMap.get("jmx.remote.x.login.config") != null) {
                hashMap.put("jmx.remote.authenticator", new AccessFileCheckerAuthenticator(hashMap));
            }
        }
        SslRMIClientSocketFactory sslRMIClientSocketFactory = null;
        RMIServerSocketFactory rMIServerSocketFactory = null;
        if (bl || bl2) {
            sslRMIClientSocketFactory = new SslRMIClientSocketFactory();
            rMIServerSocketFactory = ConnectorBootstrap.createSslRMIServerSocketFactory(string, stringArray, stringArray2, bl3, string5);
        }
        if (bl) {
            hashMap.put("jmx.remote.rmi.client.socket.factory", sslRMIClientSocketFactory);
            hashMap.put("jmx.remote.rmi.server.socket.factory", rMIServerSocketFactory);
        }
        if (bl5) {
            rMIServerSocketFactory = new HostAwareSocketFactory(string5);
            hashMap.put("jmx.remote.rmi.server.socket.factory", rMIServerSocketFactory);
        }
        JMXConnectorServer jMXConnectorServer = null;
        try {
            jMXConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, hashMap, mBeanServer);
            jMXConnectorServer.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            if (jMXConnectorServer == null || jMXConnectorServer.getAddress() == null) {
                throw new AgentConfigurationError("agent.err.connector.server.io.error", (Throwable)iOException, jMXServiceURL.toString());
            }
            throw new AgentConfigurationError("agent.err.connector.server.io.error", (Throwable)iOException, jMXConnectorServer.getAddress().toString());
        }
        registry = bl2 ? new SingleEntryRegistry(n, sslRMIClientSocketFactory, rMIServerSocketFactory, "jmxrmi", permanentExporter.firstExported) : (bl5 ? new SingleEntryRegistry(n, sslRMIClientSocketFactory, rMIServerSocketFactory, "jmxrmi", permanentExporter.firstExported) : new SingleEntryRegistry(n, "jmxrmi", permanentExporter.firstExported));
        int n3 = ((UnicastRef)((RemoteObject)((Object)registry)).getRef()).getLiveRef().getPort();
        String string6 = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", jMXServiceURL.getHost(), n3);
        JMXServiceURL jMXServiceURL2 = new JMXServiceURL(string6);
        return new JMXConnectorServerData(jMXConnectorServer, jMXServiceURL2);
    }

    private ConnectorBootstrap() {
    }

    private static class AccessFileCheckerAuthenticator
    implements JMXAuthenticator {
        private final Map<String, Object> environment;
        private final Properties properties;
        private final String accessFile;

        public AccessFileCheckerAuthenticator(Map<String, Object> map) throws IOException {
            this.environment = map;
            this.accessFile = (String)map.get("jmx.remote.x.access.file");
            this.properties = AccessFileCheckerAuthenticator.propertiesFromFile(this.accessFile);
        }

        @Override
        public Subject authenticate(Object object) {
            JMXPluggableAuthenticator jMXPluggableAuthenticator = new JMXPluggableAuthenticator(this.environment);
            Subject subject = jMXPluggableAuthenticator.authenticate(object);
            this.checkAccessFileEntries(subject);
            return subject;
        }

        private void checkAccessFileEntries(Subject subject) {
            if (subject == null) {
                throw new SecurityException("Access denied! No matching entries found in the access file [" + this.accessFile + "] as the authenticated Subject is null");
            }
            Set<Principal> set = subject.getPrincipals();
            for (Principal object : set) {
                if (!this.properties.containsKey(object.getName())) continue;
                return;
            }
            HashSet hashSet = new HashSet();
            for (Principal principal : set) {
                hashSet.add(principal.getName());
            }
            throw new SecurityException("Access denied! No entries found in the access file [" + this.accessFile + "] for any of the authenticated identities " + hashSet);
        }

        private static Properties propertiesFromFile(String string) throws IOException {
            Properties properties = new Properties();
            if (string == null) {
                return properties;
            }
            try (FileInputStream fileInputStream = new FileInputStream(string);){
                properties.load(fileInputStream);
            }
            return properties;
        }
    }

    public static interface DefaultValues {
        public static final String PORT = "0";
        public static final String CONFIG_FILE_NAME = "management.properties";
        public static final String USE_SSL = "true";
        public static final String USE_LOCAL_ONLY = "true";
        public static final String USE_REGISTRY_SSL = "false";
        public static final String USE_AUTHENTICATION = "true";
        public static final String PASSWORD_FILE_NAME = "jmxremote.password";
        public static final String ACCESS_FILE_NAME = "jmxremote.access";
        public static final String SSL_NEED_CLIENT_AUTH = "false";
    }

    private static class HostAwareSocketFactory
    implements RMIServerSocketFactory {
        private final String bindAddress;

        private HostAwareSocketFactory(String string) {
            this.bindAddress = string;
        }

        @Override
        public ServerSocket createServerSocket(int n) throws IOException {
            if (this.bindAddress == null) {
                return new ServerSocket(n);
            }
            try {
                InetAddress inetAddress = InetAddress.getByName(this.bindAddress);
                return new ServerSocket(n, 0, inetAddress);
            }
            catch (UnknownHostException unknownHostException) {
                return new ServerSocket(n);
            }
        }
    }

    private static class HostAwareSslSocketFactory
    extends SslRMIServerSocketFactory {
        private final String bindAddress;
        private final String[] enabledCipherSuites;
        private final String[] enabledProtocols;
        private final boolean needClientAuth;
        private final SSLContext context;

        private HostAwareSslSocketFactory(String[] stringArray, String[] stringArray2, boolean bl, String string) throws IllegalArgumentException {
            this(null, stringArray, stringArray2, bl, string);
        }

        private HostAwareSslSocketFactory(SSLContext sSLContext, String[] stringArray, String[] stringArray2, boolean bl, String string) throws IllegalArgumentException {
            this.context = sSLContext;
            this.bindAddress = string;
            this.enabledProtocols = stringArray2;
            this.enabledCipherSuites = stringArray;
            this.needClientAuth = bl;
            HostAwareSslSocketFactory.checkValues(sSLContext, stringArray, stringArray2);
        }

        @Override
        public ServerSocket createServerSocket(int n) throws IOException {
            if (this.bindAddress != null) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(this.bindAddress);
                    return new SslServerSocket(n, 0, inetAddress, this.context, this.enabledCipherSuites, this.enabledProtocols, this.needClientAuth);
                }
                catch (UnknownHostException unknownHostException) {
                    return new SslServerSocket(n, this.context, this.enabledCipherSuites, this.enabledProtocols, this.needClientAuth);
                }
            }
            return new SslServerSocket(n, this.context, this.enabledCipherSuites, this.enabledProtocols, this.needClientAuth);
        }

        private static void checkValues(SSLContext sSLContext, String[] stringArray, String[] stringArray2) throws IllegalArgumentException {
            SSLSocketFactory sSLSocketFactory = sSLContext == null ? (SSLSocketFactory)SSLSocketFactory.getDefault() : sSLContext.getSocketFactory();
            SSLSocket sSLSocket = null;
            if (stringArray != null || stringArray2 != null) {
                try {
                    sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
                }
                catch (Exception exception) {
                    throw (IllegalArgumentException)new IllegalArgumentException("Unable to check if the cipher suites and protocols to enable are supported").initCause(exception);
                }
            }
            if (stringArray != null) {
                sSLSocket.setEnabledCipherSuites(stringArray);
            }
            if (stringArray2 != null) {
                sSLSocket.setEnabledProtocols(stringArray2);
            }
        }
    }

    private static class JMXConnectorServerData {
        JMXConnectorServer jmxConnectorServer;
        JMXServiceURL jmxRemoteURL;

        public JMXConnectorServerData(JMXConnectorServer jMXConnectorServer, JMXServiceURL jMXServiceURL) {
            this.jmxConnectorServer = jMXConnectorServer;
            this.jmxRemoteURL = jMXServiceURL;
        }
    }

    private static class PermanentExporter
    implements RMIExporter {
        Remote firstExported;

        private PermanentExporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Remote exportObject(Remote remote, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
            Object object = this;
            synchronized (object) {
                if (this.firstExported == null) {
                    this.firstExported = remote;
                }
            }
            object = rMIClientSocketFactory == null && rMIServerSocketFactory == null ? new UnicastServerRef(n) : new UnicastServerRef2(n, rMIClientSocketFactory, rMIServerSocketFactory);
            return ((UnicastServerRef)object).exportObject(remote, null, true);
        }

        @Override
        public boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
            return UnicastRemoteObject.unexportObject(remote, bl);
        }
    }

    public static interface PropertyNames {
        public static final String PORT = "com.sun.management.jmxremote.port";
        public static final String HOST = "com.sun.management.jmxremote.host";
        public static final String RMI_PORT = "com.sun.management.jmxremote.rmi.port";
        public static final String CONFIG_FILE_NAME = "com.sun.management.config.file";
        public static final String USE_LOCAL_ONLY = "com.sun.management.jmxremote.local.only";
        public static final String USE_SSL = "com.sun.management.jmxremote.ssl";
        public static final String USE_REGISTRY_SSL = "com.sun.management.jmxremote.registry.ssl";
        public static final String USE_AUTHENTICATION = "com.sun.management.jmxremote.authenticate";
        public static final String PASSWORD_FILE_NAME = "com.sun.management.jmxremote.password.file";
        public static final String ACCESS_FILE_NAME = "com.sun.management.jmxremote.access.file";
        public static final String LOGIN_CONFIG_NAME = "com.sun.management.jmxremote.login.config";
        public static final String SSL_ENABLED_CIPHER_SUITES = "com.sun.management.jmxremote.ssl.enabled.cipher.suites";
        public static final String SSL_ENABLED_PROTOCOLS = "com.sun.management.jmxremote.ssl.enabled.protocols";
        public static final String SSL_NEED_CLIENT_AUTH = "com.sun.management.jmxremote.ssl.need.client.auth";
        public static final String SSL_CONFIG_FILE_NAME = "com.sun.management.jmxremote.ssl.config.file";
    }

    private static class SslServerSocket
    extends ServerSocket {
        private static SSLSocketFactory defaultSSLSocketFactory;
        private final String[] enabledCipherSuites;
        private final String[] enabledProtocols;
        private final boolean needClientAuth;
        private final SSLContext context;

        private SslServerSocket(int n, SSLContext sSLContext, String[] stringArray, String[] stringArray2, boolean bl) throws IOException {
            super(n);
            this.enabledProtocols = stringArray2;
            this.enabledCipherSuites = stringArray;
            this.needClientAuth = bl;
            this.context = sSLContext;
        }

        private SslServerSocket(int n, int n2, InetAddress inetAddress, SSLContext sSLContext, String[] stringArray, String[] stringArray2, boolean bl) throws IOException {
            super(n, n2, inetAddress);
            this.enabledProtocols = stringArray2;
            this.enabledCipherSuites = stringArray;
            this.needClientAuth = bl;
            this.context = sSLContext;
        }

        @Override
        public Socket accept() throws IOException {
            SSLSocketFactory sSLSocketFactory = this.context == null ? SslServerSocket.getDefaultSSLSocketFactory() : this.context.getSocketFactory();
            Socket socket = super.accept();
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
            sSLSocket.setUseClientMode(false);
            if (this.enabledCipherSuites != null) {
                sSLSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            if (this.enabledProtocols != null) {
                sSLSocket.setEnabledProtocols(this.enabledProtocols);
            }
            sSLSocket.setNeedClientAuth(this.needClientAuth);
            return sSLSocket;
        }

        private static synchronized SSLSocketFactory getDefaultSSLSocketFactory() {
            if (defaultSSLSocketFactory == null) {
                defaultSSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                return defaultSSLSocketFactory;
            }
            return defaultSSLSocketFactory;
        }
    }
}

