/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms;

import com.sun.org.apache.xml.internal.security.algorithms.Algorithm;
import com.sun.org.apache.xml.internal.security.algorithms.ClassLoaderUtils;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.algorithms.implementations.IntegrityHmac;
import com.sun.org.apache.xml.internal.security.algorithms.implementations.SignatureBaseRSA;
import com.sun.org.apache.xml.internal.security.algorithms.implementations.SignatureDSA;
import com.sun.org.apache.xml.internal.security.algorithms.implementations.SignatureECDSA;
import com.sun.org.apache.xml.internal.security.algorithms.implementations.SignatureEDDSA;
import com.sun.org.apache.xml.internal.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithm
extends Algorithm {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureAlgorithm.class);
    private static Map<String, Class<? extends SignatureAlgorithmSpi>> algorithmHash = new ConcurrentHashMap<String, Class<? extends SignatureAlgorithmSpi>>();
    private final SignatureAlgorithmSpi signatureAlgorithmSpi;
    private final String algorithmURI;

    public SignatureAlgorithm(Document document, String string) throws XMLSecurityException {
        this(document, string, null);
    }

    public SignatureAlgorithm(Document document, String string, Provider provider) throws XMLSecurityException {
        this(document, string, provider, null);
    }

    public SignatureAlgorithm(Document document, String string, Provider provider, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSecurityException {
        super(document, string);
        this.algorithmURI = string;
        this.signatureAlgorithmSpi = SignatureAlgorithm.getSignatureAlgorithmSpi(string, provider);
        if (algorithmParameterSpec != null) {
            this.signatureAlgorithmSpi.engineSetParameter(algorithmParameterSpec);
            this.signatureAlgorithmSpi.engineAddContextToElement(this.getElement());
        }
    }

    public SignatureAlgorithm(Document document, String string, int n) throws XMLSecurityException {
        this(document, string, n, null);
    }

    public SignatureAlgorithm(Document document, String string, int n, Provider provider) throws XMLSecurityException {
        super(document, string);
        this.algorithmURI = string;
        this.signatureAlgorithmSpi = SignatureAlgorithm.getSignatureAlgorithmSpi(string, provider);
        this.signatureAlgorithmSpi.engineSetHMACOutputLength(n);
        this.signatureAlgorithmSpi.engineAddContextToElement(this.getElement());
    }

    public SignatureAlgorithm(Element element, String string) throws XMLSecurityException {
        this(element, string, true, null);
    }

    public SignatureAlgorithm(Element element, String string, Provider provider) throws XMLSecurityException {
        this(element, string, true, provider);
    }

    public SignatureAlgorithm(Element element, String string, boolean bl) throws XMLSecurityException {
        this(element, string, bl, null);
    }

    public SignatureAlgorithm(Element element, String string, boolean bl, Provider provider) throws XMLSecurityException {
        super(element, string);
        this.algorithmURI = this.getURI();
        Attr attr = element.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            element.setIdAttributeNode(attr, true);
        }
        if (bl && ("http://www.w3.org/2001/04/xmldsig-more#hmac-md5".equals(this.algorithmURI) || "http://www.w3.org/2001/04/xmldsig-more#rsa-md5".equals(this.algorithmURI))) {
            Object[] objectArray = new Object[]{this.algorithmURI};
            throw new XMLSecurityException("signature.signatureAlgorithm", objectArray);
        }
        this.signatureAlgorithmSpi = SignatureAlgorithm.getSignatureAlgorithmSpi(this.algorithmURI, provider);
        this.signatureAlgorithmSpi.engineGetContextFromElement(this.getElement());
    }

    private static SignatureAlgorithmSpi getSignatureAlgorithmSpi(String string, Provider provider) throws XMLSignatureException {
        try {
            Class<? extends SignatureAlgorithmSpi> clazz = algorithmHash.get(string);
            LOG.debug("Create URI \"{}\" class \"{}\"", string, clazz);
            if (clazz == null) {
                Object[] objectArray = new Object[]{string};
                throw new XMLSignatureException("algorithms.NoSuchAlgorithmNoEx", objectArray);
            }
            if (provider != null) {
                try {
                    Constructor<? extends SignatureAlgorithmSpi> constructor = clazz.getConstructor(Provider.class);
                    return constructor.newInstance(provider);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    LOG.warn("Class \"{}\" does not have a constructor with Provider", clazz);
                }
            }
            return JavaUtils.newInstanceWithEmptyConstructor(clazz);
        }
        catch (IllegalAccessException | InstantiationException | NullPointerException | InvocationTargetException exception) {
            Object[] objectArray = new Object[]{string, exception.getMessage()};
            throw new XMLSignatureException(exception, "algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    public byte[] sign() throws XMLSignatureException {
        return this.signatureAlgorithmSpi.engineSign();
    }

    public String getJCEAlgorithmString() {
        return this.signatureAlgorithmSpi.engineGetJCEAlgorithmString();
    }

    public String getJCEProviderName() {
        return this.signatureAlgorithmSpi.engineGetJCEProviderName();
    }

    public void update(byte[] byArray) throws XMLSignatureException {
        this.signatureAlgorithmSpi.engineUpdate(byArray);
    }

    public void update(byte by) throws XMLSignatureException {
        this.signatureAlgorithmSpi.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) throws XMLSignatureException {
        this.signatureAlgorithmSpi.engineUpdate(byArray, n, n2);
    }

    public void initSign(Key key) throws XMLSignatureException {
        this.signatureAlgorithmSpi.engineInitSign(key);
    }

    public void initSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        this.signatureAlgorithmSpi.engineInitSign(key, secureRandom);
    }

    public void initSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this.signatureAlgorithmSpi.engineInitSign(key, algorithmParameterSpec);
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this.signatureAlgorithmSpi.engineSetParameter(algorithmParameterSpec);
    }

    public void initVerify(Key key) throws XMLSignatureException {
        this.signatureAlgorithmSpi.engineInitVerify(key);
    }

    public boolean verify(byte[] byArray) throws XMLSignatureException {
        return this.signatureAlgorithmSpi.engineVerify(byArray);
    }

    public final String getURI() {
        return this.getLocalAttribute("Algorithm");
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException, ClassNotFoundException, XMLSignatureException {
        JavaUtils.checkRegisterPermission();
        LOG.debug("Try to register {} {}", string, string2);
        Class<? extends SignatureAlgorithmSpi> clazz = algorithmHash.get(string);
        if (clazz != null) {
            Object[] objectArray = new Object[]{string, clazz};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        try {
            Class<?> clazz2 = ClassLoaderUtils.loadClass(string2, SignatureAlgorithm.class);
            algorithmHash.put(string, clazz2);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string, nullPointerException.getMessage()};
            throw new XMLSignatureException(nullPointerException, "algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    public static void register(String string, Class<? extends SignatureAlgorithmSpi> clazz) throws AlgorithmAlreadyRegisteredException, ClassNotFoundException, XMLSignatureException {
        JavaUtils.checkRegisterPermission();
        LOG.debug("Try to register {} {}", string, clazz);
        Class<? extends SignatureAlgorithmSpi> clazz2 = algorithmHash.get(string);
        if (clazz2 != null) {
            Object[] objectArray = new Object[]{string, clazz2};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        algorithmHash.put(string, clazz);
    }

    public static void registerDefaultAlgorithms() {
        algorithmHash.put("http://www.w3.org/2000/09/xmldsig#dsa-sha1", SignatureDSA.class);
        algorithmHash.put("http://www.w3.org/2009/xmldsig11#dsa-sha256", SignatureDSA.SHA256.class);
        algorithmHash.put("http://www.w3.org/2000/09/xmldsig#rsa-sha1", SignatureBaseRSA.SignatureRSASHA1.class);
        algorithmHash.put("http://www.w3.org/2000/09/xmldsig#hmac-sha1", IntegrityHmac.IntegrityHmacSHA1.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#rsa-md5", SignatureBaseRSA.SignatureRSAMD5.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160", SignatureBaseRSA.SignatureRSARIPEMD160.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224", SignatureBaseRSA.SignatureRSASHA224.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", SignatureBaseRSA.SignatureRSASHA256.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", SignatureBaseRSA.SignatureRSASHA384.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", SignatureBaseRSA.SignatureRSASHA512.class);
        algorithmHash.put("http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1", SignatureBaseRSA.SignatureRSASHA1MGF1.class);
        algorithmHash.put("http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1", SignatureBaseRSA.SignatureRSASHA224MGF1.class);
        algorithmHash.put("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", SignatureBaseRSA.SignatureRSASHA256MGF1.class);
        algorithmHash.put("http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", SignatureBaseRSA.SignatureRSASHA384MGF1.class);
        algorithmHash.put("http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1", SignatureBaseRSA.SignatureRSASHA512MGF1.class);
        algorithmHash.put("http://www.w3.org/2007/05/xmldsig-more#rsa-pss", SignatureBaseRSA.SignatureRSASSAPSS.class);
        algorithmHash.put("http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1", SignatureBaseRSA.SignatureRSASHA3_224MGF1.class);
        algorithmHash.put("http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1", SignatureBaseRSA.SignatureRSASHA3_256MGF1.class);
        algorithmHash.put("http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1", SignatureBaseRSA.SignatureRSASHA3_384MGF1.class);
        algorithmHash.put("http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1", SignatureBaseRSA.SignatureRSASHA3_512MGF1.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", SignatureECDSA.SignatureECDSASHA1.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", SignatureECDSA.SignatureECDSASHA224.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", SignatureECDSA.SignatureECDSASHA256.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", SignatureECDSA.SignatureECDSASHA384.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", SignatureECDSA.SignatureECDSASHA512.class);
        algorithmHash.put("http://www.w3.org/2021/04/xmldsig-more#ecdsa-sha3-224", SignatureECDSA.SignatureECDSASHA3_224.class);
        algorithmHash.put("http://www.w3.org/2021/04/xmldsig-more#ecdsa-sha3-256", SignatureECDSA.SignatureECDSASHA3_256.class);
        algorithmHash.put("http://www.w3.org/2021/04/xmldsig-more#ecdsa-sha3-384", SignatureECDSA.SignatureECDSASHA3_384.class);
        algorithmHash.put("http://www.w3.org/2021/04/xmldsig-more#ecdsa-sha3-512", SignatureECDSA.SignatureECDSASHA3_512.class);
        algorithmHash.put("http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160", SignatureECDSA.SignatureECDSARIPEMD160.class);
        algorithmHash.put("http://www.w3.org/2021/04/xmldsig-more#eddsa-ed25519", SignatureEDDSA.SignatureEd25519.class);
        algorithmHash.put("http://www.w3.org/2021/04/xmldsig-more#eddsa-ed448", SignatureEDDSA.SignatureEd448.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#hmac-md5", IntegrityHmac.IntegrityHmacMD5.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160", IntegrityHmac.IntegrityHmacRIPEMD160.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224", IntegrityHmac.IntegrityHmacSHA224.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", IntegrityHmac.IntegrityHmacSHA256.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384", IntegrityHmac.IntegrityHmacSHA384.class);
        algorithmHash.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512", IntegrityHmac.IntegrityHmacSHA512.class);
    }

    @Override
    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    @Override
    public String getBaseLocalName() {
        return "SignatureMethod";
    }
}

