/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth.callback;

import com.ibm.security.util.Password;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class TextCallbackHandler
implements CallbackHandler {
    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        ConfirmationCallback confirmationCallback = null;
        for (int i = 0; i < callbackArray.length; ++i) {
            String string;
            Callback callback;
            if (callbackArray[i] instanceof TextOutputCallback) {
                callback = (TextOutputCallback)callbackArray[i];
                switch (((TextOutputCallback)callback).getMessageType()) {
                    case 0: {
                        string = "";
                        break;
                    }
                    case 1: {
                        string = "Warning: ";
                        break;
                    }
                    case 2: {
                        string = "Error: ";
                        break;
                    }
                    default: {
                        throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized message type");
                    }
                }
                String string2 = ((TextOutputCallback)callback).getMessage();
                if (string2 != null) {
                    string = string + string2;
                }
                if (string == null) continue;
                System.err.println(string);
                continue;
            }
            if (callbackArray[i] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[i];
                if (((NameCallback)callback).getDefaultName() == null) {
                    System.err.print(((NameCallback)callback).getPrompt());
                } else {
                    System.err.print(((NameCallback)callback).getPrompt() + " [" + ((NameCallback)callback).getDefaultName() + "] ");
                }
                System.err.flush();
                string = this.readLine();
                if (string.equals("")) {
                    string = ((NameCallback)callback).getDefaultName();
                }
                ((NameCallback)callback).setName(string);
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[i];
                System.err.print(((PasswordCallback)callback).getPrompt());
                System.err.flush();
                ((PasswordCallback)callback).setPassword(Password.readPassword((InputStream)System.in, (boolean)((PasswordCallback)callback).isEchoOn()));
                continue;
            }
            if (callbackArray[i] instanceof ConfirmationCallback) {
                confirmationCallback = (ConfirmationCallback)callbackArray[i];
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i], "Unrecognized Callback");
        }
        if (confirmationCallback != null) {
            this.doConfirmation(confirmationCallback);
        }
    }

    private String readLine() throws IOException {
        String string = new BufferedReader(new InputStreamReader(System.in)).readLine();
        if (string == null) {
            throw new IOException("Cannot read from System.in");
        }
        return string;
    }

    private void doConfirmation(ConfirmationCallback confirmationCallback) throws IOException, UnsupportedCallbackException {
        int n;
        class OptionInfo {
            String name;
            int value;

            OptionInfo(String string, int n) {
                this.name = string;
                this.value = n;
            }
        }
        OptionInfo[] optionInfoArray;
        String string;
        int n2 = confirmationCallback.getMessageType();
        switch (n2) {
            case 1: {
                string = "Warning: ";
                break;
            }
            case 2: {
                string = "Error: ";
                break;
            }
            case 0: {
                string = "";
                break;
            }
            default: {
                throw new UnsupportedCallbackException(confirmationCallback, "Unrecognized message type: " + n2);
            }
        }
        int n3 = confirmationCallback.getOptionType();
        switch (n3) {
            case 0: {
                optionInfoArray = new OptionInfo[]{new OptionInfo("Yes", 0), new OptionInfo("No", 1)};
                break;
            }
            case 1: {
                optionInfoArray = new OptionInfo[]{new OptionInfo("Yes", 0), new OptionInfo("No", 1), new OptionInfo("Cancel", 2)};
                break;
            }
            case 2: {
                optionInfoArray = new OptionInfo[]{new OptionInfo("OK", 3), new OptionInfo("Cancel", 2)};
                break;
            }
            case -1: {
                String[] stringArray = confirmationCallback.getOptions();
                optionInfoArray = new OptionInfo[stringArray.length];
                for (int i = 0; i < optionInfoArray.length; ++i) {
                    optionInfoArray[i] = new OptionInfo(stringArray[i], i);
                }
                break;
            }
            default: {
                throw new UnsupportedCallbackException(confirmationCallback, "Unrecognized option type: " + n3);
            }
        }
        int n4 = confirmationCallback.getDefaultOption();
        String string2 = confirmationCallback.getPrompt();
        if (string2 == null) {
            string2 = "";
        }
        if (!(string2 = string + string2).equals("")) {
            System.err.println(string2);
        }
        for (n = 0; n < optionInfoArray.length; ++n) {
            if (n3 == -1) {
                System.err.println(n + ". " + optionInfoArray[n].name + (n == n4 ? " [default]" : ""));
                continue;
            }
            System.err.println(n + ". " + optionInfoArray[n].name + (optionInfoArray[n].value == n4 ? " [default]" : ""));
        }
        System.err.print("Enter a number: ");
        System.err.flush();
        try {
            n = Integer.parseInt(this.readLine());
            if (n < 0 || n > optionInfoArray.length - 1) {
                n = n4;
            }
            n = optionInfoArray[n].value;
        }
        catch (NumberFormatException numberFormatException) {
            n = n4;
        }
        confirmationCallback.setSelectedIndex(n);
    }
}

