/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bidiTools.bdlayout;

import com.ibm.bidiTools.bdlayout.ArabicOption;
import com.ibm.bidiTools.bdlayout.ArabicOptionSet;
import com.ibm.bidiTools.bdlayout.BidiFlag;
import com.ibm.bidiTools.bdlayout.BidiFlagSet;

class BidiShape {
    ArabicDeShaper deShaper;
    ArabicShaper shaper;
    final char SPACE_CHARACTER = (char)32;
    final char Done = (char)65535;
    final byte NotArabicCharacter = 0;
    final byte NormalCase = 1;
    final byte TashkeelCase = (byte)2;
    final byte LamAlfCase = (byte)3;
    final byte SeenFamilyCase = (byte)4;
    final byte YehHamzaCase = (byte)5;
    final byte ShapedYehHamzaCase = (byte)7;
    final byte DigitCase = (byte)6;
    String inputCodePage = "utf-16";
    String outputCodepage = "utf-16";
    final String CP00420 = "cp420";
    final String CP00864 = "cp864";
    final String CP001046 = "cp1046";
    final String CPUTF16 = "utf-16";
    char OutputArabicTailFragment = (char)8203;
    BidiFlagSet inAttr;
    BidiFlagSet outAttr;
    ArabicOptionSet optionSet;

    public String getInputCodePage() {
        return this.inputCodePage;
    }

    public boolean setInputCodePage(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        if (string2.equals(this.CP001046) || string2.equals(this.CP00420) || string2.equals(this.CPUTF16) || string2.equals(this.CP00864)) {
            this.inputCodePage = string2;
            return true;
        }
        return false;
    }

    public String getOuputCodepage() {
        return this.outputCodepage;
    }

    public boolean setOutputCodepage(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        if (string2.equals(this.CP001046) || string2.equals(this.CP00420) || string2.equals(this.CPUTF16) || string2.equals(this.CP00864)) {
            this.outputCodepage = string2;
            return true;
        }
        return false;
    }

    synchronized char[] shape(BidiFlagSet bidiFlagSet, BidiFlagSet bidiFlagSet2, char[] cArray, ArabicOptionSet arabicOptionSet) {
        this.inAttr = bidiFlagSet;
        this.outAttr = bidiFlagSet2;
        this.optionSet = arabicOptionSet;
        boolean bl = true;
        int n = cArray.length;
        if (n == 0) {
            return cArray;
        }
        if (this.optionSet == null) {
            this.optionSet = new ArabicOptionSet();
        }
        BidiFlag bidiFlag = bidiFlagSet.getType();
        BidiFlag bidiFlag2 = this.outAttr.getType();
        bl = this.outAttr.getOrientation() == BidiFlag.ORIENTATION_RTL;
        this.setInputCodePage(bidiFlagSet.getCodePage());
        this.setOutputCodepage(bidiFlagSet2.getCodePage());
        this.setArabicTailFragment(bidiFlagSet2.getArabicTailFragment());
        if (bidiFlag == BidiFlag.TYPE_VISUAL && bidiFlag2 == BidiFlag.TYPE_IMPLICIT) {
            bl = false;
            if (this.deShaper == null) {
                this.deShaper = new ArabicDeShaper(cArray, bl);
            } else {
                this.deShaper.setDataBuffer(cArray, bl);
            }
            return this.deShaper.deShape();
        }
        if (this.shaper == null) {
            this.shaper = new ArabicShaper(cArray, bl);
        } else {
            this.shaper.setDataBuffer(cArray, bl);
        }
        return this.shaper.shape();
    }

    private void setArabicTailFragment(char c) {
        if (c == '\ufe73' || c == '\u200b') {
            this.OutputArabicTailFragment = c;
        }
    }

    static interface ArabicCharacterMapper {
        public static final char FE_RANGE_INTERVAL_BEGIN = '\ufe70';
        public static final char FE_RANGE_INTERVAL_END = '\ufeff';
        public static final char[] BaseForm = new char[]{'\u0627', '\u0628', '\u062a', '\u062b', '\u062c', '\u062d', '\u062e', '\u062f', '\u0630', '\u0631', '\u0632', '\u0633', '\u0634', '\u0635', '\u0636', '\u0637', '\u0638', '\u0639', '\u063a', '\u0641', '\u0642', '\u0643', '\u0644', '\u0645', '\u0646', '\u0647', '\u0648', '\u064a', '\u0625', '\u0623', '\u0622', '\u0629', '\u0649', '\u06cc', '\u0626', '\u0624', '\u064b', '\u064c', '\u064d', '\u064e', '\u064f', '\u0650', '\u0651', '\u0652', '\u0621'};
        public static final char[] IsolatedForm = new char[]{'\ufe8d', '\ufe8f', '\ufe95', '\ufe99', '\ufe9d', '\ufea1', '\ufea5', '\ufea9', '\ufeab', '\ufead', '\ufeaf', '\ufeb1', '\ufeb5', '\ufeb9', '\ufebd', '\ufec1', '\ufec5', '\ufec9', '\ufecd', '\ufed1', '\ufed5', '\ufed9', '\ufedd', '\ufee1', '\ufee5', '\ufee9', '\ufeed', '\ufef1', '\ufe87', '\ufe83', '\ufe81', '\ufe93', '\ufeef', '\ufbfc', '\ufe89', '\ufe85', '\ufe70', '\ufe72', '\ufe74', '\ufe76', '\ufe78', '\ufe7a', '\ufe7c', '\ufe7e', '\ufe80'};
        public static final char[] FinalForm = new char[]{'\ufe8e', '\ufe90', '\ufe96', '\ufe9a', '\ufe9e', '\ufea2', '\ufea6', '\ufeaa', '\ufeac', '\ufeae', '\ufeb0', '\ufeb2', '\ufeb6', '\ufeba', '\ufebe', '\ufec2', '\ufec6', '\ufeca', '\ufece', '\ufed2', '\ufed6', '\ufeda', '\ufede', '\ufee2', '\ufee6', '\ufeea', '\ufeee', '\ufef2', '\ufe88', '\ufe84', '\ufe82', '\ufe94', '\ufef0', '\ufbfd', '\ufe8a', '\ufe86', '\ufe70', '\ufe72', '\ufe74', '\ufe76', '\ufe78', '\ufe7a', '\ufe7c', '\ufe7e', '\ufe80'};
        public static final char[] MedialForm = new char[]{'\ufe8e', '\ufe92', '\ufe98', '\ufe9c', '\ufea0', '\ufea4', '\ufea8', '\ufeaa', '\ufeac', '\ufeae', '\ufeb0', '\ufeb4', '\ufeb8', '\ufebc', '\ufec0', '\ufec4', '\ufec8', '\ufecc', '\ufed0', '\ufed4', '\ufed8', '\ufedc', '\ufee0', '\ufee4', '\ufee8', '\ufeec', '\ufeee', '\ufef4', '\ufe88', '\ufe84', '\ufe82', '\ufe94', '\ufef0', '\ufbff', '\ufe8c', '\ufe86', '\ufe70', '\ufe72', '\ufe74', '\ufe76', '\ufe78', '\ufe7a', '\ufe7c', '\ufe7e', '\ufe80'};
        public static final char[] InitialForm = new char[]{'\ufe8d', '\ufe91', '\ufe97', '\ufe9b', '\ufe9f', '\ufea3', '\ufea7', '\ufea9', '\ufeab', '\ufead', '\ufeaf', '\ufeb3', '\ufeb7', '\ufebb', '\ufebf', '\ufec3', '\ufec7', '\ufecb', '\ufecf', '\ufed3', '\ufed7', '\ufedb', '\ufedf', '\ufee3', '\ufee7', '\ufeeb', '\ufeed', '\ufef3', '\ufe87', '\ufe83', '\ufe81', '\ufe93', '\ufeef', '\ufbfe', '\ufe8b', '\ufe85', '\ufe70', '\ufe72', '\ufe74', '\ufe76', '\ufe78', '\ufe7a', '\ufe7c', '\ufe7e', '\ufe80'};
        public static final char[] StandAlonForm = new char[]{'\u0621', '\u0627', '\u062f', '\u0630', '\u0631', '\u0632', '\u0648', '\u0622', '\u0629', '\u0626', '\u0624', '\u0625', '\u0675', '\u0623'};
        public static final char ArabicLamCharacter = '\u0644';
        public static final char ArabicLetter_LamAlf_Shaped_Interval_Begin = '\ufef5';
        public static final char ArabicLetter_LamAlf_Shaped_Interval_End = '\ufefc';
        public static final char[] ArabiclettersAlf = new char[]{'\u0622', '\u0623', '\u0625', '\u0627'};
        public static final char[] LamAlfIsolatedForm = new char[]{'\ufef5', '\ufef7', '\ufef9', '\ufefb'};
        public static final char[] LamAlfFianlForm = new char[]{'\ufef6', '\ufef8', '\ufefa', '\ufefc'};
        public static final char ArabicTashkeel_Interval_Begin = '\u064b';
        public static final char ArabicTashkeel_Interval_End = '\u0652';
        public static final char ArabicLetterYehHamza = '\u0626';
        public static final char ArabicLetter_Yeh = '\u064a';
        public static final char ArabicLetter_Hamza = '\u0621';
        public static final char ArabicLetter_YehHamza_InitialForm = '\ufe8b';
        public static final char ArabicLetter_Yeh_IsolatedForm = '\ufef1';
        public static final char ArabicLetter_Yeh_FinalForm = '\ufef2';
        public static final char ArabicLetter_Hamza_IsolatedForm = '\ufe80';
        public static final char ArabicLetter_YehHamza_FinalForm = '\ufe8a';
        public static final char ArabicLetter_YehHamza_IsolatedForm = '\ufe89';
        public static final char ArabicSeenFamily_Interval_Begin = '\u0633';
        public static final char ArabicSeenFamily_Interval_End = '\u0636';
        public static final char[] ArabicSeenFamily_FinalForm = new char[]{'\ufeb2', '\ufeb6', '\ufeba', '\ufebe'};
        public static final char[] ArabicSeenFamily_IsolatedForm = new char[]{'\ufeb1', '\ufeb5', '\ufeb9', '\ufebd'};
        public static final char ArabicTailFragment = '\ufe73';
        public static final char ArabicTailFragment_Legacy = '\u200b';
        public static final char ArabicLetterShadda = '\u0651';
        public static final char ArabicLetterShaddaIsolatedForm = '\ufe7c';
        public static final char DigitalIntervalBegin = '0';
        public static final char DigitalIntervalEnd = '9';
        public static final char[] EnglishPunctuationSybmols = new char[]{'%', '.', ',', '*', '?', ';'};
        public static final char[] ArabicPunctuations = new char[]{'\u066a', '\u066b', '\u066c', '\u066d', '\u061f', '\u061b'};
        public static final char ZeroWidthNonJoiner = '\u200c';
    }

    private class ArabicDeShaper
    implements ArabicCharacterMapper {
        int extraSavedSpace;
        int index;
        int lastIndex;
        char[] data;
        int length;
        int indexDirection;
        boolean rtl;

        ArabicDeShaper(char[] cArray, boolean bl) {
            this.data = cArray;
            this.length = cArray.length;
            this.rtl = bl;
            if (!bl) {
                this.index = 0;
                this.lastIndex = cArray.length - 1;
                this.indexDirection = 1;
            } else {
                this.index = cArray.length - 1;
                this.lastIndex = 0;
                this.indexDirection = -1;
            }
        }

        public char[] deShape() {
            StringBuffer stringBuffer = new StringBuffer();
            this.extraSavedSpace = 0;
            int n = 0;
            while (this.current() != '\uffff') {
                switch (this.getCharacterType()) {
                    case 1: {
                        n = this.deShapeNormalCharacter(stringBuffer, n);
                        break;
                    }
                    case 3: {
                        n = this.deShapeLamAlf(stringBuffer, n);
                        break;
                    }
                    case 4: {
                        n = this.deShapeSeenFamily(stringBuffer, n);
                        break;
                    }
                    case 7: {
                        n = this.deShapeYehHamza420(stringBuffer, n);
                        break;
                    }
                    case 5: {
                        n = this.deShapeYehHamza(stringBuffer, n);
                        break;
                    }
                    case 0: 
                    case 6: {
                        this.insert(stringBuffer, this.current(), n);
                        ++n;
                    }
                }
                this.next();
            }
            for (int i = 0; i < this.extraSavedSpace; ++i) {
                stringBuffer.append(' ');
            }
            if (!this.rtl) {
                return stringBuffer.toString().toCharArray();
            }
            return stringBuffer.reverse().toString().toCharArray();
        }

        private int deShapeYehHamza420(StringBuffer stringBuffer, int n) {
            ArabicOption arabicOption = BidiShape.this.optionSet.getYehHamzaMode();
            if (arabicOption == ArabicOption.YEHHAMZA_TWO_CELL_NEAR && this.nextSpace()) {
                this.insert(stringBuffer, '\u064a', n);
                this.insert(stringBuffer, '\u0621', n + 1);
                this.next();
                return n + 2;
            }
            this.insert(stringBuffer, '\ufe8b', n);
            return n + 1;
        }

        private char next() {
            this.index += this.indexDirection;
            --this.length;
            if (this.length > 0) {
                return this.data[this.index];
            }
            return '\uffff';
        }

        private boolean nextSpace() {
            int n = this.index + this.indexDirection;
            if (this.length - 1 > 0) {
                return this.data[n] == ' ';
            }
            return false;
        }

        private void deleteLastDataElement() {
            --this.length;
            this.lastIndex -= this.indexDirection;
        }

        private char getLastElement() {
            return this.data[this.lastIndex];
        }

        private char current() {
            if (this.length > 0) {
                return this.data[this.index];
            }
            return '\uffff';
        }

        private byte getCharacterType() {
            if (this.data[this.index] >= '\ufe70' && this.data[this.index] <= '\ufeff') {
                if (this.currentLamAlf() >= 0) {
                    return 3;
                }
                if (!BidiShape.this.outputCodepage.equals("cp420") && !BidiShape.this.outputCodepage.equals("cp864")) {
                    if (this.currentYehHamza()) {
                        return 5;
                    }
                } else if (this.currentShapedYehHamza()) {
                    return 7;
                }
                if (this.currentSeenFamily()) {
                    return 4;
                }
                return 1;
            }
            if (this.data[this.index] >= '\u0633' && this.data[this.index] <= '\u0636' && this.nextTailFragment()) {
                return 4;
            }
            return 0;
        }

        private boolean currentShapedYehHamza() {
            return this.current() == '\ufe8a' || this.current() == '\ufe89';
        }

        private int deShapeNormalCharacter(StringBuffer stringBuffer, int n) {
            for (int i = 0; i < BaseForm.length; ++i) {
                if (this.data[this.index] != IsolatedForm[i] && this.data[this.index] != FinalForm[i] && this.data[this.index] != MedialForm[i] && this.data[this.index] != InitialForm[i]) continue;
                this.insert(stringBuffer, BaseForm[i], n);
                if (BidiShape.this.outAttr.isDisableArabicIsolatedFormDeshap() && this.data[this.index] == IsolatedForm[i]) {
                    this.insert(stringBuffer, '\u200c', ++n);
                }
                return n + 1;
            }
            this.insert(stringBuffer, this.current(), n);
            return n + 1;
        }

        private int deShapeLamAlf(StringBuffer stringBuffer, int n) {
            ArabicOption arabicOption = BidiShape.this.optionSet.getLamAlefMode();
            if (arabicOption == ArabicOption.LAMALEF_RESIZE_BUFFER) {
                this.insertDeShapedLamAlf(stringBuffer, n, this.getAlfType());
                return n + 2;
            }
            if (arabicOption == ArabicOption.LAMALEF_ATEND || arabicOption == ArabicOption.LAMALEF_AUTO) {
                if (this.getLastElement() == ' ') {
                    this.deleteLastDataElement();
                    this.insertDeShapedLamAlf(stringBuffer, n, this.getAlfType());
                    return n + 2;
                }
                if (this.extraSavedSpace > 0) {
                    --this.extraSavedSpace;
                    this.insertDeShapedLamAlf(stringBuffer, n, this.getAlfType());
                    return n + 2;
                }
            }
            if ((arabicOption == ArabicOption.LAMALEF_ATBEGIN || arabicOption == ArabicOption.LAMALEF_AUTO) && stringBuffer.length() > 0 && stringBuffer.charAt(0) == ' ') {
                stringBuffer.deleteCharAt(0);
                this.insertDeShapedLamAlf(stringBuffer, --n, this.getAlfType());
                return n + 2;
            }
            if ((arabicOption == ArabicOption.LAMALEF_NEAR || arabicOption == ArabicOption.LAMALEF_AUTO) && this.nextSpace()) {
                this.insertDeShapedLamAlf(stringBuffer, n, this.getAlfType());
                this.next();
                return n + 2;
            }
            this.insert(stringBuffer, this.data[this.index], n);
            return n + 1;
        }

        private void insertDeShapedLamAlf(StringBuffer stringBuffer, int n, char c) {
            this.insert(stringBuffer, '\u0644', n);
            this.insert(stringBuffer, this.getAlfType(), n + 1);
        }

        private int deShapeSeenFamily(StringBuffer stringBuffer, int n) {
            if (this.data[this.index] >= '\u0633' && this.data[this.index] <= '\u0636') {
                this.insert(stringBuffer, this.data[this.index], n);
            } else {
                for (int i = 0; i < ArabicSeenFamily_FinalForm.length; ++i) {
                    if (this.data[this.index] != ArabicSeenFamily_FinalForm[i] && this.data[this.index] != ArabicSeenFamily_IsolatedForm[i]) continue;
                    this.insert(stringBuffer, (char)(1587 + i), n);
                    break;
                }
            }
            ArabicOption arabicOption = BidiShape.this.optionSet.getSeenMode();
            this.next();
            if (arabicOption == ArabicOption.SEEN_NEAR) {
                this.insert(stringBuffer, ' ', n + 1);
                return n + 2;
            }
            return n;
        }

        private int deShapeYehHamza(StringBuffer stringBuffer, int n) {
            this.insert(stringBuffer, '\u0626', n);
            ArabicOption arabicOption = BidiShape.this.optionSet.getYehHamzaMode();
            this.next();
            if (arabicOption == ArabicOption.YEHHAMZA_TWO_CELL_NEAR) {
                this.insert(stringBuffer, ' ', n + 1);
                return n + 2;
            }
            return n + 1;
        }

        private char getAlfType() {
            int n = this.currentLamAlf();
            if (n >= 0) {
                return ArabiclettersAlf[n];
            }
            return ArabiclettersAlf[0];
        }

        private boolean currentSeenFamily() {
            if (this.nextTailFragment()) {
                for (int i = 0; i < ArabicSeenFamily_FinalForm.length; ++i) {
                    if (this.data[this.index] != ArabicSeenFamily_FinalForm[i] && this.data[this.index] != ArabicSeenFamily_IsolatedForm[i]) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean nextTailFragment() {
            int n = this.index + this.indexDirection;
            if (this.length - 1 > 0) {
                return this.data[n] == '\ufe73' || this.data[n] == '\u200b';
            }
            return false;
        }

        private boolean currentYehHamza() {
            return this.nextHamza() && (this.data[this.index] == '\ufef2' || this.data[this.index] == '\ufef1');
        }

        private boolean nextHamza() {
            int n = this.index + this.indexDirection;
            if (this.length - 1 > 0) {
                return this.data[n] == '\ufe80';
            }
            return false;
        }

        private int currentLamAlf() {
            if (this.data[this.index] >= '\ufef5' && this.data[this.index] <= '\ufefc') {
                return (this.data[this.index] - 65269) / 2;
            }
            return -1;
        }

        public void setDataBuffer(char[] cArray, boolean bl) {
            this.data = cArray;
            this.length = cArray.length;
            this.rtl = bl;
            if (!bl) {
                this.index = 0;
                this.lastIndex = cArray.length - 1;
                this.indexDirection = 1;
            } else {
                this.index = cArray.length - 1;
                this.lastIndex = 0;
                this.indexDirection = -1;
            }
        }

        private void insert(StringBuffer stringBuffer, char c, int n) {
            if (n >= stringBuffer.length()) {
                for (int i = stringBuffer.length(); i < n; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(c);
                return;
            }
            stringBuffer.insert(n, c);
        }
    }

    private class ArabicShaper
    implements ArabicCharacterMapper {
        int index;
        int lastIndex;
        char[] data;
        int length;
        int indexDirection;
        boolean rtl;
        int extraSavedSpace;
        final byte ISOLATEDFORM = 0;
        final byte FINALFORM = 1;
        final byte MEDIALFORM = (byte)2;
        final byte INITIATEFORM = (byte)3;

        ArabicShaper(char[] cArray, boolean bl) {
            this.data = cArray;
            this.length = cArray.length;
            this.rtl = bl;
            if (bl) {
                this.index = 0;
                this.lastIndex = cArray.length - 1;
                this.indexDirection = 1;
            } else {
                this.index = cArray.length - 1;
                this.lastIndex = 0;
                this.indexDirection = -1;
            }
        }

        private char next() {
            this.index += this.indexDirection;
            --this.length;
            if (this.length > 0) {
                return this.data[this.index];
            }
            return '\uffff';
        }

        private byte getCharacterType() {
            if (this.data[this.index] >= '\u0600' && this.data[this.index] <= '\u06ff') {
                if (this.data[this.index] == '\u0644' && this.isNextAlf() >= 0) {
                    return 3;
                }
                if (BidiShape.this.outputCodepage.equals("cp1046") || BidiShape.this.outputCodepage.equals("cp420") || BidiShape.this.outputCodepage.equals("cp864")) {
                    if (!BidiShape.this.outputCodepage.equals("cp1046") && this.data[this.index] >= '\u064b' && this.data[this.index] <= '\u0652') {
                        return 2;
                    }
                    if (this.data[this.index] == '\u0626') {
                        return 5;
                    }
                    if (this.data[this.index] >= '\u0633' && this.data[this.index] <= '\u0636' && !this.isNextAr()) {
                        return 4;
                    }
                }
                return 1;
            }
            if (this.data[this.index] >= '0' && this.data[this.index] <= '9') {
                return 6;
            }
            return 0;
        }

        private int shapeNormalType(StringBuffer stringBuffer, int n) {
            for (int i = 0; i < BaseForm.length; ++i) {
                if (this.data[this.index] != BaseForm[i]) continue;
                switch (this.getShapedForm(i)) {
                    case 0: {
                        this.insert(stringBuffer, this.getIsolatedForm(i), n);
                        return n + 1;
                    }
                    case 1: {
                        this.insert(stringBuffer, this.getFinalForm(i), n);
                        return n + 1;
                    }
                    case 2: {
                        this.insert(stringBuffer, this.getMedialForm(i), n);
                        return n + 1;
                    }
                    case 3: {
                        this.insert(stringBuffer, this.getInitiateForm(i), n);
                        return n + 1;
                    }
                }
            }
            this.insert(stringBuffer, this.data[this.index], n);
            return n + 1;
        }

        private byte getShapedForm(int n) {
            if (this.isPreviousCursiveAr()) {
                if (this.isNextAr()) {
                    return 2;
                }
                return 1;
            }
            if (this.isNextAr()) {
                return 3;
            }
            return 0;
        }

        private char getIsolatedForm(int n) {
            return IsolatedForm[n];
        }

        private char getInitiateForm(int n) {
            return InitialForm[n];
        }

        private char getFinalForm(int n) {
            return FinalForm[n];
        }

        private char getMedialForm(int n) {
            return MedialForm[n];
        }

        private boolean isNextAr() {
            int n = this.index + this.indexDirection;
            while (this.length - 1 > 0) {
                if (Character.getDirectionality(this.data[n]) == 2) {
                    return true;
                }
                if (Character.getDirectionality(this.data[n]) == 8) {
                    n += this.indexDirection;
                    continue;
                }
                return false;
            }
            return false;
        }

        private boolean isPreviousCursiveAr() {
            int n = this.index - this.indexDirection;
            int n2 = 1;
            while (this.length + n2 <= this.data.length) {
                if (Character.getDirectionality(this.data[n]) == 2) {
                    for (int i = 0; i < StandAlonForm.length; ++i) {
                        if (this.data[n] != StandAlonForm[i]) continue;
                        return false;
                    }
                    return true;
                }
                if (Character.getDirectionality(this.data[n]) == 8) {
                    n -= this.indexDirection;
                    ++n2;
                    continue;
                }
                return false;
            }
            return false;
        }

        private int isNextAlf() {
            int n = this.index + this.indexDirection;
            if (this.length - 1 > 0) {
                for (int i = 0; i < ArabiclettersAlf.length; ++i) {
                    if (ArabiclettersAlf[i] != this.data[n]) continue;
                    return i;
                }
            }
            return -1;
        }

        private char getLamAlfShapedForm() {
            int n = this.isNextAlf();
            switch (this.getShapedForm(this.index)) {
                case 0: 
                case 3: {
                    return LamAlfIsolatedForm[n];
                }
            }
            return LamAlfFianlForm[n];
        }

        private int shapeLamAlf(StringBuffer stringBuffer, int n) {
            this.insert(stringBuffer, this.getLamAlfShapedForm(), n);
            this.next();
            ArabicOption arabicOption = BidiShape.this.optionSet.getLamAlefMode();
            if (arabicOption == ArabicOption.LAMALEF_ATBEGIN) {
                this.insert(stringBuffer, ' ', 0);
                return n + 2;
            }
            if (arabicOption == ArabicOption.LAMALEF_ATEND || arabicOption == ArabicOption.LAMALEF_AUTO) {
                ++this.extraSavedSpace;
                return n + 1;
            }
            if (arabicOption == ArabicOption.LAMALEF_NEAR) {
                this.insert(stringBuffer, ' ', n + 1);
                return n + 2;
            }
            return n + 1;
        }

        private void insert(StringBuffer stringBuffer, char c, int n) {
            if (n >= stringBuffer.length()) {
                for (int i = stringBuffer.length(); i < n; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(c);
                return;
            }
            stringBuffer.insert(n, c);
        }

        private int shapeSeenFamily(StringBuffer stringBuffer, int n) {
            int n2 = this.data[this.index] - 1587;
            if (this.isPreviousCursiveAr()) {
                this.insert(stringBuffer, ArabicSeenFamily_FinalForm[n2], n);
            } else {
                this.insert(stringBuffer, ArabicSeenFamily_IsolatedForm[n2], n);
            }
            ArabicOption arabicOption = BidiShape.this.optionSet.getSeenMode();
            if (arabicOption == ArabicOption.SEEN_NEAR && this.nextSpace()) {
                this.next();
                this.insert(stringBuffer, BidiShape.this.OutputArabicTailFragment, n + 1);
                return n + 2;
            }
            return n + 1;
        }

        private int shapeYehHamza(StringBuffer stringBuffer, int n) {
            if (this.isPreviousCursiveAr()) {
                this.insert(stringBuffer, '\ufef1', n);
            } else {
                this.insert(stringBuffer, '\ufef2', n);
            }
            ArabicOption arabicOption = BidiShape.this.optionSet.getYehHamzaMode();
            if (arabicOption == ArabicOption.YEHHAMZA_TWO_CELL_NEAR && this.nextSpace()) {
                this.next();
                this.insert(stringBuffer, '\ufe80', n + 1);
                return n + 2;
            }
            this.replace(stringBuffer, n, '\ufe8b');
            return n + 1;
        }

        private int shapeTashkeel(StringBuffer stringBuffer, int n) {
            if (this.data[this.index] == '\u0651') {
                this.insert(stringBuffer, '\ufe7c', n);
                return n + 1;
            }
            ArabicOption arabicOption = BidiShape.this.optionSet.getTashkeelMode();
            if (arabicOption == ArabicOption.TASHKEEL_AUTO || arabicOption == ArabicOption.TASHKEEL_CUSTOMIZED_ATEND) {
                ++this.extraSavedSpace;
                return n;
            }
            if (arabicOption == ArabicOption.TASHKEEL_CUSTOMIZED_ATBEGIN) {
                this.insert(stringBuffer, ' ', 0);
                return n + 1;
            }
            if (arabicOption == ArabicOption.TASHKEEL_CUSTOMIZED_Near) {
                this.insert(stringBuffer, ' ', 0);
                return n + 1;
            }
            return n;
        }

        private void replace(StringBuffer stringBuffer, int n, char c) {
            if (n > stringBuffer.length()) {
                for (int i = stringBuffer.length(); i < n; ++i) {
                    stringBuffer.insert(i, ' ');
                }
                stringBuffer.insert(n, c);
                return;
            }
            stringBuffer.setCharAt(n, c);
        }

        private boolean nextSpace() {
            int n = this.index + this.indexDirection;
            if (this.length - 1 > 0) {
                return this.data[n] == ' ';
            }
            return false;
        }

        public char[] shape() {
            StringBuffer stringBuffer = new StringBuffer();
            this.extraSavedSpace = 0;
            int n = 0;
            while (this.current() != '\uffff') {
                switch (this.getCharacterType()) {
                    case 1: {
                        n = this.shapeNormalType(stringBuffer, n);
                        break;
                    }
                    case 3: {
                        n = this.shapeLamAlf(stringBuffer, n);
                        break;
                    }
                    case 2: {
                        n = this.shapeTashkeel(stringBuffer, n);
                        break;
                    }
                    case 4: {
                        n = this.shapeSeenFamily(stringBuffer, n);
                        break;
                    }
                    case 5: {
                        n = this.shapeYehHamza(stringBuffer, n);
                        break;
                    }
                    case 0: 
                    case 6: {
                        if (this.data[this.index] == '\u200c') break;
                        this.insert(stringBuffer, this.current(), n);
                        ++n;
                    }
                }
                this.next();
            }
            for (int i = 0; i < this.extraSavedSpace; ++i) {
                stringBuffer.append(' ');
            }
            if (!this.rtl) {
                return stringBuffer.reverse().toString().toCharArray();
            }
            return stringBuffer.toString().toCharArray();
        }

        private char current() {
            if (this.length > 0) {
                return this.data[this.index];
            }
            return '\uffff';
        }

        public void setDataBuffer(char[] cArray, boolean bl) {
            this.data = cArray;
            this.length = cArray.length;
            this.rtl = bl;
            if (bl) {
                this.index = 0;
                this.lastIndex = cArray.length - 1;
                this.indexDirection = 1;
            } else {
                this.index = cArray.length - 1;
                this.lastIndex = 0;
                this.indexDirection = -1;
            }
        }
    }
}

