/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.types;

import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.I8;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.IScalar;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.UScalar;
import java.math.BigInteger;

public class UDATA
extends UScalar {
    public static final int SIZEOF;
    public static final long MASK;
    public static final UDATA MIN;
    public static final UDATA MAX;

    public UDATA(long value) {
        super(value & MASK);
    }

    public UDATA(Scalar parameter) {
        super(parameter);
    }

    public UDATA add(long parameter) {
        return new UDATA(this.data + parameter);
    }

    public UDATA add(UScalar parameter) {
        return new UDATA(this.data + parameter.data);
    }

    public U64 add(U64 parameter) {
        return new U64(this).add(parameter);
    }

    public UDATA add(IScalar parameter) {
        return this.add(new UDATA(parameter));
    }

    public boolean eq(IScalar parameter) {
        return this.eq(new UDATA(parameter));
    }

    public UDATA sub(long parameter) {
        return new UDATA(this.data - parameter);
    }

    public UDATA sub(UScalar parameter) {
        return new UDATA(this.data - parameter.data);
    }

    public U64 sub(U64 parameter) {
        return new U64(this).sub(parameter);
    }

    public UDATA sub(I8 parameter) {
        return this.sub(new UDATA(parameter));
    }

    public UDATA sub(I16 parameter) {
        return this.sub(new UDATA(parameter));
    }

    public UDATA sub(I32 parameter) {
        return this.sub(new UDATA(parameter));
    }

    public UDATA sub(IDATA parameter) {
        return this.sub(new UDATA(parameter));
    }

    @Override
    public int intValue() {
        long value = this.data;
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new InvalidDataTypeException("UDATA contains value larger than Integer.MAX_VALUE");
        }
        return (int)value;
    }

    public UDATA bitOr(int parameter) {
        return new UDATA(this.data | (long)parameter);
    }

    public UDATA bitOr(long parameter) {
        return new UDATA(this.data | parameter);
    }

    public UDATA bitOr(UScalar parameter) {
        return new UDATA(this.data | parameter.data);
    }

    public U64 bitOr(U64 parameter) {
        return new U64(this).bitOr(parameter);
    }

    public UDATA bitOr(I8 parameter) {
        return this.bitOr(new UDATA(parameter));
    }

    public UDATA bitOr(I16 parameter) {
        return this.bitOr(new UDATA(parameter));
    }

    public UDATA bitOr(I32 parameter) {
        return this.bitOr(new UDATA(parameter));
    }

    public UDATA bitOr(IDATA parameter) {
        return this.bitOr(new UDATA(parameter));
    }

    public UDATA bitXor(int parameter) {
        return new UDATA(this.data ^ (long)parameter);
    }

    public UDATA bitXor(long parameter) {
        return new UDATA(this.data ^ parameter);
    }

    public UDATA bitXor(Scalar parameter) {
        return this.bitXor(new UDATA(parameter));
    }

    public UDATA bitXor(UDATA parameter) {
        return new UDATA(this.data ^ parameter.data);
    }

    public I64 bitXor(I64 parameter) {
        return new I64(this).bitXor(parameter);
    }

    public U64 bitXor(U64 parameter) {
        return new U64(this).bitXor(parameter);
    }

    public UDATA bitAnd(int parameter) {
        return new UDATA(this.data & (long)parameter);
    }

    public UDATA bitAnd(long parameter) {
        return new UDATA(this.data & parameter);
    }

    public UDATA bitAnd(UScalar parameter) {
        return new UDATA(this.data & parameter.data);
    }

    public U64 bitAnd(U64 parameter) {
        return new U64(this).bitAnd(parameter);
    }

    public UDATA bitAnd(I8 parameter) {
        return this.bitAnd(new UDATA(parameter));
    }

    public UDATA bitAnd(I16 parameter) {
        return this.bitAnd(new UDATA(parameter));
    }

    public UDATA bitAnd(I32 parameter) {
        return this.bitAnd(new UDATA(parameter));
    }

    public UDATA bitAnd(IDATA parameter) {
        return this.bitAnd(new UDATA(parameter));
    }

    public UDATA leftShift(int i) {
        return new UDATA(this.data << i);
    }

    public UDATA leftShift(UDATA i) {
        return new UDATA(this.data << (int)i.longValue());
    }

    public UDATA rightShift(int i) {
        return new UDATA(this.data >>> i);
    }

    public UDATA rightShift(UDATA i) {
        return new UDATA(this.data >>> (int)i.longValue());
    }

    public UDATA bitNot() {
        return new UDATA(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public UDATA mult(int parameter) {
        return new UDATA(this.data * (long)parameter);
    }

    public UDATA mult(long parameter) {
        return new UDATA(this.data * parameter);
    }

    public UDATA mult(UDATA parameter) {
        return this.mult(parameter.longValue());
    }

    public UDATA mod(int parameter) {
        return this.mod((long)parameter);
    }

    public UDATA mod(long parameter) {
        if (parameter < 0L) {
            throw new IllegalArgumentException("mod by negative number is not supported, yet");
        }
        if (this.data < 0L) {
            long lowBit = this.data & 1L;
            long half = this.data >>> 1;
            long result = (half % parameter * 2L + lowBit) % parameter;
            return new UDATA(result);
        }
        return new UDATA(this.data % parameter);
    }

    public UDATA mod(Scalar parameter) {
        return this.mod(parameter.longValue());
    }

    public UDATA div(long divisor) {
        long dividend = this.data;
        if (divisor >= 0L && dividend >= 0L) {
            return new UDATA(dividend / divisor);
        }
        BigInteger x = new BigInteger(Long.toHexString(dividend), 16);
        BigInteger y = new BigInteger(Long.toHexString(divisor), 16);
        return new UDATA(x.divide(y).longValue());
    }

    public UDATA div(Scalar parameter) {
        return this.div(parameter.longValue());
    }

    public int numberOfLeadingZeros() {
        int leadingZeroes = Long.numberOfLeadingZeros(this.data);
        int extraLeadingZeroes = 64 - SIZEOF * 8;
        return leadingZeroes - extraLeadingZeroes;
    }

    public int numberOfTrailingZeros() {
        if (0L == this.data) {
            return SIZEOF * 8;
        }
        return Long.numberOfTrailingZeros(this.data);
    }

    public static UDATA cast(AbstractPointer ptr) {
        if (ptr != null) {
            return new UDATA(ptr.getAddress());
        }
        return new UDATA(0L);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    static {
        if (J9BuildFlags.J9VM_ENV_DATA64) {
            SIZEOF = 8;
            MASK = -1L;
        } else {
            SIZEOF = 4;
            MASK = 0xFFFFFFFFL;
        }
        MIN = new UDATA(0L);
        MAX = new UDATA(MASK);
    }
}

