/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.Table;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;

public class FindInstances
extends Command {
    private String className;
    private J9ClassPointer classPointer;
    private Table data;
    private long corruptCount;
    private long objectsFound;

    public FindInstances() {
        this.addCommand("findinstances", "<classname>", "find all instances of the specific class and its subclasses");
    }

    private static void printUsage(PrintStream out) {
        out.println("findinstances <name> - find all instances of the specific class and its subclasses");
    }

    private boolean parseArgs(PrintStream out, String[] args) throws DDRInteractiveCommandException {
        if (args == null || args.length != 1) {
            out.println("Exactly one argument expected");
            return false;
        }
        String firstArg = args[0];
        if (firstArg.equals("help")) {
            FindInstances.printUsage(out);
            return false;
        }
        this.className = firstArg;
        return true;
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (!this.parseArgs(out, args)) {
            return;
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            ClassSegmentIterator iterator = new ClassSegmentIterator(vm.classMemorySegments());
            out.format("Searching for class named '%s' in VM=%s%n", this.className, Long.toHexString(vm.getAddress()));
            this.classPointer = null;
            while (iterator.hasNext()) {
                J9ClassPointer clsPointer = (J9ClassPointer)iterator.next();
                String javaName = J9ClassHelper.getJavaName(clsPointer);
                if (!this.className.equals(javaName)) continue;
                String hexString = clsPointer.getHexAddress();
                this.classPointer = clsPointer;
                out.format("Found !j9class %s named %s%n", hexString, javaName);
                break;
            }
            if (this.classPointer == null) {
                out.format("No class named %s found%n", this.className);
                return;
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
        this.data = new Table("Instances of " + this.className);
        this.data.row("Address", "Class Name");
        this.corruptCount = 0L;
        this.objectsFound = 0L;
        this.scanHeap();
        out.format("Objects found: %d%n", this.objectsFound);
        out.format("Corruptions encountered: %d%n", this.corruptCount);
        this.data.render(out);
    }

    private void scanHeap() {
        try {
            GCHeapRegionIterator regions = GCHeapRegionIterator.from();
            while (regions.hasNext()) {
                GCHeapRegionDescriptor region = regions.next();
                this.scanObjects(region);
            }
        }
        catch (CorruptDataException e) {
            e.printStackTrace();
        }
    }

    private void scanObjects(GCHeapRegionDescriptor region) throws CorruptDataException {
        GCObjectHeapIterator heapIterator = GCObjectHeapIterator.fromHeapRegionDescriptor(region, true, true);
        while (heapIterator.hasNext()) {
            J9ObjectPointer object = heapIterator.next();
            try {
                J9ClassPointer objClass = J9ObjectHelper.clazz(object);
                if (!objClass.notNull() || !J9ClassHelper.isSameOrSuperClassOf(this.classPointer, objClass)) continue;
                this.data.row(object.getHexAddress(), J9ClassHelper.getJavaName(objClass));
                ++this.objectsFound;
            }
            catch (CorruptDataException e) {
                ++this.corruptCount;
            }
        }
    }
}

