/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm28.pointer.generated.MM_UnfinalizedObjectListPointer;
import com.ibm.j9ddr.vm28.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm28.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckUnfinalizedList
extends Check {
    CheckUnfinalizedList() {
    }

    @Override
    public void check() {
        try {
            MM_UnfinalizedObjectListPointer unfinalizedObjectList = this.getGCExtensions().unfinalizedObjectLists();
            while (unfinalizedObjectList.notNull()) {
                J9ObjectPointer object = unfinalizedObjectList._head();
                while (object.notNull()) {
                    if (this._engine.checkSlotUnfinalizedList(object, unfinalizedObjectList) != 0) {
                        return;
                    }
                    object = ObjectAccessBarrier.getFinalizeLink(object);
                }
                unfinalizedObjectList = unfinalizedObjectList._nextList();
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "UNFINALIZED";
    }

    @Override
    public void print() {
        try {
            MM_UnfinalizedObjectListPointer unfinalizedObjectList = this.getGCExtensions().unfinalizedObjectLists();
            ScanFormatter formatter = new ScanFormatter(this, "unfinalizedObjectList");
            while (unfinalizedObjectList.notNull()) {
                formatter.section("list", unfinalizedObjectList);
                J9ObjectPointer object = unfinalizedObjectList._head();
                while (object.notNull()) {
                    formatter.entry(object);
                    object = ObjectAccessBarrier.getFinalizeLink(object);
                }
                formatter.endSection();
                unfinalizedObjectList = unfinalizedObjectList._nextList();
            }
            formatter.end("unfinalizedObjectList");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

