/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.events.EventManager;
import com.ibm.j9ddr.vm28.j9.gc.GCMixedObjectIterator_V1;
import com.ibm.j9ddr.vm28.j9.gc.GCPackedObjectModel;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9ObjectHelper;

public class GCPackedObjectIterator_V1
extends GCMixedObjectIterator_V1 {
    protected GCPackedObjectModel _packedObjectModel;
    private boolean _isTargetReturned;

    public GCPackedObjectIterator_V1(J9ObjectPointer object, boolean includeClassSlot, boolean includeTargetObject) throws CorruptDataException {
        super(object, includeClassSlot);
        if (!J9ObjectHelper.isPacked(object)) {
            throw new UnsupportedOperationException("object is not packed");
        }
        this._isTargetReturned = !includeTargetObject;
        this._packedObjectModel = GCPackedObjectModel.from();
        if (this._packedObjectModel.isPackedObjectHeader(object)) {
            this.scanIndex = this.scanLimit;
        }
    }

    public GCPackedObjectIterator_V1(J9ClassPointer clazz, VoidPointer addr) throws CorruptDataException {
        super(clazz, addr);
        if (!J9ClassHelper.isPacked(clazz)) {
            throw new UnsupportedOperationException("object is not packed");
        }
        this._isTargetReturned = true;
        this._packedObjectModel = GCPackedObjectModel.from();
    }

    @Override
    public J9ObjectPointer next() {
        try {
            if (this.object != null && !this._isTargetReturned) {
                J9ObjectPointer next = this._packedObjectModel.getTargetObject(this.object);
                this._isTargetReturned = true;
                return next;
            }
            return super.next();
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return J9ObjectPointer.NULL;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        try {
            if (this.object != null && !this._isTargetReturned) {
                VoidPointer next = VoidPointer.cast(this._packedObjectModel.getTargetObjectEA(this.object));
                this._isTargetReturned = true;
                return next;
            }
            return super.nextAddress();
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return VoidPointer.NULL;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.object != null && !this._isTargetReturned) {
            return true;
        }
        return super.hasNext();
    }
}

