/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.tenant;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm27.j9.gc.GCBase;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionManager;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm27.j9.tenant.TenantDataHelper;
import com.ibm.j9ddr.vm27.j9.tenant.TenantModel;
import com.ibm.j9ddr.vm27.j9.tenant.UncheckedReferenceHelper;
import com.ibm.j9ddr.vm27.pointer.I32Pointer;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9TenantNativeDataPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_AllocationContextMultiTenantPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_AllocationContextTarokPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionDescriptorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionDescriptorVLHGCPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_RegionListTarokPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassLoaderHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm27.structure.MM_AllocationContextTarok$AllocationContextType;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TenantContextHelper {
    static final int ROW_INDEX_BITS = 16;
    static final int COL_INDEX_MASK = 65535;
    public static final String tenantContextClassName = "Lcom/ibm/tenant/TenantContext;";
    private J9JavaVMPointer vm;
    private J9ClassPointer tenantContextClazz;
    private GCHeapRegionManager heapRegionManager;
    private TenantDataHelper tenantDataHelper;
    private HashMap<String, J9ObjectFieldOffset> tenantContextFieldOffsets;
    private HashMap<Integer, String> tenantStateMap;
    private MM_GCExtensionsPointer gcExtensions;
    private UncheckedReferenceHelper uncheckedReferenceHelper;
    private static TenantContextHelper defaultInstance = null;

    public static TenantContextHelper getDefault() {
        if (null == defaultInstance) {
            try {
                J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
                defaultInstance = new TenantContextHelper(vm);
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
        return defaultInstance;
    }

    public TenantContextHelper(J9JavaVMPointer vm) throws CorruptDataException {
        this.vm = vm;
        J9ClassLoaderPointer loader = vm.systemClassLoader();
        this.tenantContextClazz = J9ClassLoaderHelper.findClass(loader, tenantContextClassName);
        this.tenantContextFieldOffsets = new HashMap();
        this.computeFieldOffsets(this.tenantContextClazz, this.tenantContextFieldOffsets);
        this.tenantStateMap = new HashMap();
        this.computeStateMap(this.tenantStateMap);
        MM_HeapRegionManagerPointer hrmPointer = MM_GCExtensionsPointer.cast(vm.gcExtensions()).heapRegionManager();
        this.heapRegionManager = GCHeapRegionManager.fromHeapRegionManager(hrmPointer);
        this.gcExtensions = GCBase.getExtensions();
        this.tenantDataHelper = new TenantDataHelper(vm);
        try {
            this.uncheckedReferenceHelper = new UncheckedReferenceHelper(vm);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void computeFieldOffsets(J9ClassPointer clazz, HashMap<String, J9ObjectFieldOffset> offsets) throws CorruptDataException {
        if (J9ClassHelper.superclass(clazz).notNull()) {
            this.computeFieldOffsets(J9ClassHelper.superclass(clazz), offsets);
        }
        Iterator<J9ObjectFieldOffset> ofoIterator = J9ClassHelper.getFieldOffsets(clazz);
        while (ofoIterator.hasNext()) {
            J9ObjectFieldOffset ofo = ofoIterator.next();
            offsets.put(ofo.getName(), ofo);
        }
    }

    private void computeStateMap(HashMap<Integer, String> statemap) throws CorruptDataException {
        J9ClassPointer clazz = J9ClassLoaderHelper.findClass(this.vm.systemClassLoader(), "Lcom/ibm/tenant/TenantState;");
        Iterator<J9ObjectFieldOffset> ofoIterator = J9ClassHelper.getFieldOffsets(clazz);
        while (ofoIterator.hasNext()) {
            J9ObjectFieldOffset ofo = ofoIterator.next();
            J9ROMFieldShapePointer fieldShape = ofo.getField();
            String name = J9UTF8Helper.stringValue(fieldShape.nameAndSignature().name());
            try {
                if (!ofo.isStatic()) continue;
                int stateValue = I32Pointer.cast(clazz.ramStatics().addOffset(ofo.getOffsetOrAddress())).at(0L).intValue();
                statemap.put(stateValue, name);
            }
            catch (Exception exception) {}
        }
    }

    public J9ClassPointer tenantContextClazz() {
        return this.tenantContextClazz;
    }

    public int threadTotal(J9ObjectPointer tenantObject) throws CorruptDataException {
        return J9ObjectHelper.getIntField(tenantObject, this.tenantContextFieldOffsets.get("threadTotal"));
    }

    public int daemonThreadTotal(J9ObjectPointer tenantObject) throws CorruptDataException {
        return J9ObjectHelper.getIntField(tenantObject, this.tenantContextFieldOffsets.get("daemonThreadTotal"));
    }

    public long allocationContextRef(J9ObjectPointer tenantObject) throws CorruptDataException {
        return J9ObjectHelper.getLongField(tenantObject, this.tenantContextFieldOffsets.get("allocationContextRef"));
    }

    public String id(J9ObjectPointer tenantObject) throws CorruptDataException {
        return J9ObjectHelper.getStringField(tenantObject, this.tenantContextFieldOffsets.get("id"));
    }

    public J9ObjectPointer data(J9ObjectPointer tenantObject) throws CorruptDataException {
        J9ObjectPointer uncheckedReference = J9ObjectHelper.getObjectField(tenantObject, this.tenantContextFieldOffsets.get("data"));
        return this.uncheckedReferenceHelper.referent(uncheckedReference);
    }

    public MM_AllocationContextMultiTenantPointer allocationContext(J9ObjectPointer tenantObject) throws CorruptDataException {
        return MM_AllocationContextMultiTenantPointer.cast(this.allocationContextRef(tenantObject));
    }

    public long tenantNativeDataRef(J9ObjectPointer tenantObject) throws CorruptDataException {
        return J9ObjectHelper.getLongField(tenantObject, this.tenantContextFieldOffsets.get("tenantNativeDataRef"));
    }

    public J9TenantNativeDataPointer nativeData(J9ObjectPointer tenantObject) throws CorruptDataException {
        return J9TenantNativeDataPointer.cast(this.tenantNativeDataRef(tenantObject));
    }

    public String state(J9ObjectPointer tenantObject) throws CorruptDataException {
        int state = J9ObjectHelper.getIntField(tenantObject, this.tenantContextFieldOffsets.get("state"));
        return this.tenantStateMap.get(state);
    }

    public J9ObjectPointer rootTenantContext() throws CorruptDataException {
        PointerPointer rootTenantGlobalRef = this.vm.tenantGlobals().rootTenantContext();
        return J9ObjectPointer.cast(rootTenantGlobalRef.at(0L));
    }

    public J9ObjectPointer currentTenantContext() throws CorruptDataException {
        return this.rootTenantContext();
    }

    public int getRowIndex(UDATA index) {
        return index.intValue() >>> 16;
    }

    public int getColIndex(UDATA index) {
        return index.intValue() & 0xFFFF;
    }

    private J9IndexableObjectPointer tenantDataRow(J9IndexableObjectPointer slotArray, UDATA index) throws CorruptDataException {
        J9ObjectPointer[] slices = new J9ObjectPointer[1];
        J9IndexableObjectHelper.getObjectData(slotArray, slices, this.getRowIndex(index), 1, 0);
        return J9IndexableObjectPointer.cast(slices[0]);
    }

    public J9ObjectPointer getObject(J9ObjectPointer tenant, UDATA index) throws CorruptDataException {
        J9ObjectPointer tenantData = this.data(tenant);
        J9IndexableObjectPointer slots = this.tenantDataHelper.dataObj(tenantData);
        J9ObjectPointer[] value = new J9ObjectPointer[1];
        J9IndexableObjectHelper.getObjectData(this.tenantDataRow(slots, index), value, this.getColIndex(index), 1, 0);
        return value[0];
    }

    public int getInt(J9ObjectPointer tenant, UDATA index) throws CorruptDataException {
        J9ObjectPointer tenantData = this.data(tenant);
        J9IndexableObjectPointer slots = this.tenantDataHelper.data32(tenantData);
        int[] value = new int[1];
        J9IndexableObjectHelper.getIntData(this.tenantDataRow(slots, index), value, this.getColIndex(index), 1, 0);
        return value[0];
    }

    public long getLong(J9ObjectPointer tenant, UDATA index) throws CorruptDataException {
        J9ObjectPointer tenantData = this.data(tenant);
        J9IndexableObjectPointer slots = this.tenantDataHelper.data64(tenantData);
        long[] value = new long[1];
        J9IndexableObjectHelper.getLongData(this.tenantDataRow(slots, index), value, this.getColIndex(index), 1, 0);
        return value[0];
    }

    public List<MM_HeapRegionDescriptorVLHGCPointer> getRegions(J9ObjectPointer tenantObject) throws CorruptDataException {
        MM_AllocationContextMultiTenantPointer ac = this.allocationContext(tenantObject);
        ArrayList<MM_HeapRegionDescriptorVLHGCPointer> tenantRegions = new ArrayList<MM_HeapRegionDescriptorVLHGCPointer>();
        GCHeapRegionIterator regions = GCHeapRegionIterator.from();
        while (regions.hasNext()) {
            GCHeapRegionDescriptor region = regions.next();
            MM_HeapRegionDescriptorPointer mmRegion = region.getHeapRegionDescriptorPointer();
            MM_HeapRegionDescriptorVLHGCPointer vlhgcRegion = MM_HeapRegionDescriptorVLHGCPointer.cast(mmRegion);
            if (!ac.equals(vlhgcRegion._allocateData()._owningContext())) continue;
            tenantRegions.add(vlhgcRegion);
        }
        MM_RegionListTarokPointer freeRegionList = ac._freeRegions();
        MM_HeapRegionDescriptorVLHGCPointer cursor = freeRegionList._regions();
        while (!cursor.isNull()) {
            tenantRegions.add(cursor);
            cursor = MM_HeapRegionDescriptorVLHGCPointer.cast(cursor._nextRegion());
        }
        return tenantRegions;
    }

    public List<J9VMThreadPointer> getThreads(J9ObjectPointer tenantObject) throws CorruptDataException {
        ArrayList<J9VMThreadPointer> threads = new ArrayList<J9VMThreadPointer>();
        J9VMThreadPointer mainThread = this.vm.mainThread();
        if (mainThread.notNull()) {
            J9VMThreadPointer threadCursor = this.vm.mainThread();
            do {
                if (!threadCursor.tenantObject().equals(tenantObject)) continue;
                threads.add(threadCursor);
            } while (!(threadCursor = threadCursor.linkNext()).eq(mainThread));
        }
        return threads;
    }

    public Set<J9ObjectPointer> getAllTenants() throws CorruptDataException {
        final HashSet<J9ObjectPointer> allTenants = new HashSet<J9ObjectPointer>();
        final HashSet<J9ObjectPointer> visitedObjects = new HashSet<J9ObjectPointer>(1000000);
        visitedObjects.add(J9ObjectPointer.NULL);
        GCHeapRegionIterator regions = GCHeapRegionIterator.from();
        class HeapVisitor {
            HeapVisitor() {
            }

            private void visitHeapObject(J9ObjectPointer object) throws CorruptDataException {
                if (visitedObjects.contains(object)) {
                    return;
                }
                visitedObjects.add(object);
                if (J9ObjectHelper.clazz(object).equals(TenantContextHelper.this.tenantContextClazz)) {
                    allTenants.add(object);
                }
            }
        }
        HeapVisitor visitor = new HeapVisitor();
        while (regions.hasNext()) {
            GCHeapRegionDescriptor region = regions.next();
            GCObjectHeapIterator heapIterator = GCObjectHeapIterator.fromHeapRegionDescriptor(region, true, false);
            while (heapIterator.hasNext()) {
                visitor.visitHeapObject(heapIterator.next());
            }
        }
        return allTenants;
    }

    public Set<J9ObjectPointer> getClasses(final J9ObjectPointer tenantObject) throws CorruptDataException {
        final HashSet<J9ObjectPointer> allClasses = new HashSet<J9ObjectPointer>();
        final J9ClassPointer javaLangClass = J9ClassLoaderHelper.findClass(this.vm.systemClassLoader(), "Ljava/lang/Class;");
        String tenantID = this.id(tenantObject);
        final boolean isRootTenant = tenantID.equalsIgnoreCase("_ROOT_TENANT_");
        final HashSet<J9ObjectPointer> visitedObjects = new HashSet<J9ObjectPointer>(1000000);
        visitedObjects.add(J9ObjectPointer.NULL);
        GCHeapRegionIterator regions = GCHeapRegionIterator.from();
        class HeapVisitor {
            HeapVisitor() {
            }

            private void visitHeapObject(J9ObjectPointer object) throws CorruptDataException {
                if (visitedObjects.contains(object)) {
                    return;
                }
                visitedObjects.add(object);
                if (J9ObjectHelper.clazz(object).equals(javaLangClass)) {
                    J9ClassPointer ramClass = ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(object);
                    PointerPointer tenantJNIRef = ramClass.classLoader().hostTenant();
                    if (tenantJNIRef.isNull()) {
                        if (isRootTenant) {
                            allClasses.add(object);
                        }
                    } else {
                        J9ObjectPointer classLoaderTenant = J9ObjectPointer.cast(tenantJNIRef.at(0L));
                        if (tenantObject.equals(classLoaderTenant)) {
                            allClasses.add(object);
                        }
                    }
                }
            }
        }
        HeapVisitor visitor = new HeapVisitor();
        while (regions.hasNext()) {
            GCHeapRegionDescriptor region = regions.next();
            GCObjectHeapIterator heapIterator = GCObjectHeapIterator.fromHeapRegionDescriptor(region, true, false);
            while (heapIterator.hasNext()) {
                visitor.visitHeapObject(heapIterator.next());
            }
        }
        return allClasses;
    }

    public J9ObjectPointer tenantForObject(StructurePointer objectPointer) throws CorruptDataException {
        MM_AllocationContextMultiTenantPointer acmt;
        PointerPointer tenantContextJNIRef;
        MM_HeapRegionDescriptorVLHGCPointer vlhgcRegionPointer;
        MM_AllocationContextTarokPointer act;
        GCHeapRegionDescriptor region;
        J9ObjectPointer tenantObject = null;
        if (TenantModel.isTenantEnabled() && this.gcExtensions._isVLHGC() && null != objectPointer && !objectPointer.isNull() && null != (region = this.heapRegionManager.regionDescriptorForAddress(objectPointer)) && MM_AllocationContextTarok$AllocationContextType.MULTI_TENANT == (act = (vlhgcRegionPointer = MM_HeapRegionDescriptorVLHGCPointer.cast(region.getHeapRegionDescriptorPointer()))._allocateData()._owningContext())._allocationContextType() && (tenantContextJNIRef = (acmt = MM_AllocationContextMultiTenantPointer.cast(act))._tenantContext()).notNull()) {
            tenantObject = J9ObjectPointer.cast(tenantContextJNIRef.at(0L));
        }
        return tenantObject;
    }
}

