/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.HashTable;
import com.ibm.j9ddr.vm27.j9.IHashTable;
import com.ibm.j9ddr.vm27.pointer.generated.J9JVMTIEnvPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JVMTIObjectTagPointer;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.util.Iterator;

public class JVMTIObjectTagTable
implements IHashTable<J9JVMTIObjectTagPointer> {
    protected HashTable<J9JVMTIObjectTagPointer> objectTagTable;

    protected JVMTIObjectTagTable(HashTable<J9JVMTIObjectTagPointer> hashTable) throws CorruptDataException {
        this.objectTagTable = hashTable;
    }

    public static JVMTIObjectTagTable fromJ9JVMTIEnv(J9JVMTIEnvPointer jvmtiEnv) throws CorruptDataException {
        HashTable<J9JVMTIObjectTagPointer> hashTable = HashTable.fromJ9HashTable(jvmtiEnv.objectTagTable(), true, J9JVMTIObjectTagPointer.class, new ObjectTagEqualFunction(), new ObjectTagHashFunction());
        return new JVMTIObjectTagTable(hashTable);
    }

    @Override
    public Iterator<J9JVMTIObjectTagPointer> iterator() {
        return this.objectTagTable.iterator();
    }

    @Override
    public long getCount() {
        return this.objectTagTable.getCount();
    }

    @Override
    public String getTableName() {
        return this.objectTagTable.getTableName();
    }

    protected static class ObjectTagEqualFunction
    implements HashTable.HashEqualFunction<J9JVMTIObjectTagPointer> {
        protected ObjectTagEqualFunction() {
        }

        @Override
        public boolean equal(J9JVMTIObjectTagPointer entry1, J9JVMTIObjectTagPointer entry2) {
            try {
                return entry1.ref().equals(entry2.ref());
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error checking equality", e, true);
                return false;
            }
        }
    }

    protected static class ObjectTagHashFunction
    implements HashTable.HashFunction<J9JVMTIObjectTagPointer> {
        protected ObjectTagHashFunction() {
        }

        @Override
        public UDATA hash(J9JVMTIObjectTagPointer entry) {
            try {
                UDATA hash = UDATA.cast(entry.ref());
                if (4 == UDATA.SIZEOF) {
                    return hash.rightShift(2);
                }
                return hash.rightShift(3);
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting hash", e, false);
                return new UDATA(0L);
            }
        }
    }
}

