/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.gc.GCClassHeapIterator;
import com.ibm.j9ddr.vm26.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm26.structure.J9MemorySegment;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.Check;

class CheckClassHeap
extends Check {
    CheckClassHeap() {
    }

    @Override
    public void check() {
        try {
            GCSegmentIterator segmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(this._javaVM.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
            while (segmentIterator.hasNext()) {
                J9MemorySegmentPointer segment = segmentIterator.next();
                this._engine.clearPreviousObjects();
                GCClassHeapIterator classHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(segment);
                while (classHeapIterator.hasNext()) {
                    J9ClassPointer clazz = classHeapIterator.next();
                    if (this._engine.checkClassHeap(clazz, segment) != 0) {
                        return;
                    }
                    this._engine.pushPreviousClass(clazz);
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "CLASS HEAP";
    }

    @Override
    public void print() {
        this.getReporter().println("Printing of class heap not currently supported");
    }
}

