/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm26.j9.gc.GCMarkMap;
import com.ibm.j9ddr.vm26.j9.gc.GCMarkMapSegregated;
import com.ibm.j9ddr.vm26.j9.gc.GCMarkMapStandard;
import com.ibm.j9ddr.vm26.pointer.UDATAPointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_HeapMapPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_IncrementalGenerationalGCPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_MarkMapPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_MarkMapSegregatedPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_ParallelGlobalGCPointer;
import com.ibm.j9ddr.vm26.structure.MM_HeapMap;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.util.ArrayList;

public abstract class GCHeapMap {
    public static final long J9BITS_BITS_IN_SLOT = (long)UDATA.SIZEOF * 8L;
    public static final long BITS_IN_BYTES = 8L;
    public static final UDATA J9MODRON_HEAP_SLOTS_PER_HEAPMAP_SLOT = new UDATA(MM_HeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT * J9BITS_BITS_IN_SLOT);
    public static final UDATA J9MODRON_HEAP_BYTES_PER_HEAPMAP_BIT = new UDATA(MM_HeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT * (long)UDATA.SIZEOF);
    public static final UDATA J9MODRON_HEAP_BYTES_PER_HEAPMAP_BYTE = J9MODRON_HEAP_BYTES_PER_HEAPMAP_BIT.mult(8L);
    public static final UDATA J9MODRON_HEAP_BYTES_PER_HEAPMAP_SLOT = J9MODRON_HEAP_BYTES_PER_HEAPMAP_BYTE.mult(UDATA.SIZEOF);
    protected MM_HeapMapPointer _heapMap;
    protected VoidPointer _heapBase;
    protected VoidPointer _heapTop;
    protected UDATAPointer _heapMapBits;
    protected UDATA _maxOffset;

    public static GCHeapMap from() throws CorruptDataException {
        MM_GCExtensionsPointer extensions = GCExtensions.getGCExtensionsPointer();
        if (GCExtensions.isStandardGC()) {
            MM_ParallelGlobalGCPointer pgc = MM_ParallelGlobalGCPointer.cast(extensions._globalCollector());
            MM_MarkMapPointer markMap = pgc._markingScheme()._markMap();
            return new GCMarkMapStandard(markMap);
        }
        if (GCExtensions.isVLHGC()) {
            MM_IncrementalGenerationalGCPointer igc = MM_IncrementalGenerationalGCPointer.cast(extensions._globalCollector());
            MM_MarkMapPointer markMap = igc._markMapManager()._previousMarkMap();
            return new GCMarkMap(markMap);
        }
        if (GCExtensions.isMetronomeGC()) {
            MM_MarkMapSegregatedPointer markMap = extensions.realtimeGC()._markingScheme()._markMap();
            return new GCMarkMapSegregated(markMap);
        }
        throw new UnsupportedOperationException("GC policy not supported");
    }

    public static GCHeapMap fromHeapMap(MM_HeapMapPointer heapMap) throws CorruptDataException {
        if (GCExtensions.isStandardGC()) {
            return new GCMarkMapStandard(heapMap);
        }
        if (GCExtensions.isVLHGC()) {
            return new GCMarkMap(heapMap);
        }
        if (GCExtensions.isMetronomeGC()) {
            return new GCMarkMapSegregated(MM_MarkMapSegregatedPointer.cast(heapMap));
        }
        throw new UnsupportedOperationException("GC policy not supported");
    }

    public GCHeapMap(MM_HeapMapPointer heapMap) throws CorruptDataException {
        this._heapMap = heapMap;
        this._heapBase = heapMap._heapBase();
        this._heapTop = heapMap._heapTop();
        this._heapMapBits = heapMap._heapMapBits();
        this._maxOffset = UDATA.cast(this._heapTop).sub(UDATA.cast(this._heapBase));
    }

    public MM_HeapMapPointer getHeapMap() {
        return this._heapMap;
    }

    public VoidPointer getHeapBase() {
        return this._heapBase;
    }

    public UDATAPointer getHeapMapBits() {
        return this._heapMapBits;
    }

    public VoidPointer getHeapTop() {
        return this._heapTop;
    }

    public int getObjectGrain() {
        return 1 << (int)MM_HeapMap.J9MODRON_HEAPMAP_BIT_SHIFT;
    }

    public int getPageSize(J9ObjectPointer object) {
        return (int)MM_HeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT * UDATA.SIZEOF * 8 * UDATA.SIZEOF;
    }

    public UDATA[] getSlotIndexAndMask(J9ObjectPointer object) {
        UDATA heapBaseOffset = UDATA.cast(object).sub(UDATA.cast(this._heapBase));
        if (heapBaseOffset.gte(this._maxOffset)) {
            throw new IllegalArgumentException("Object is not in heap: " + object);
        }
        UDATA bitIndex = heapBaseOffset.bitAnd(MM_HeapMap.J9MODRON_HEAPMAP_BIT_MASK);
        bitIndex = bitIndex.rightShift(new UDATA(MM_HeapMap.J9MODRON_HEAPMAP_BIT_SHIFT));
        UDATA bitMask = new UDATA(1L).leftShift(bitIndex);
        UDATA slotIndex = heapBaseOffset.rightShift(new UDATA(MM_HeapMap.J9MODRON_HEAPMAP_INDEX_SHIFT));
        UDATA[] result = new UDATA[]{slotIndex, bitMask};
        return result;
    }

    public boolean isBitSet(J9ObjectPointer address) throws CorruptDataException {
        if (address.gte(this._heapTop) || address.lt(this._heapBase)) {
            throw new IllegalArgumentException("Pointer outside of the committed heap");
        }
        return this.isBitSetNoCheck(address);
    }

    public boolean isMarked(J9ObjectPointer address) throws CorruptDataException {
        if (address.gte(this._heapTop) || address.lt(this._heapBase)) {
            return true;
        }
        return this.isBitSetNoCheck(address);
    }

    protected boolean isBitSetNoCheck(J9ObjectPointer object) throws CorruptDataException {
        UDATA[] indexAndMask = this.getSlotIndexAndMask(object);
        boolean result = this._heapMapBits.add(indexAndMask[0]).at(0L).bitAnd(indexAndMask[1]).gt(0);
        return result;
    }

    public MarkedObject queryObject(J9ObjectPointer object) throws CorruptDataException {
        MarkedObject[] result = this.queryRange(object, object.addOffset(this.getObjectGrain()));
        if (result.length > 0 && result[0].object.eq(object)) {
            return result[0];
        }
        return null;
    }

    public MarkedObject[] queryRange(J9ObjectPointer base, J9ObjectPointer top) throws CorruptDataException {
        ArrayList<MarkedObject> results = new ArrayList<MarkedObject>();
        if (base.lt(this._heapBase)) {
            base = J9ObjectPointer.cast(this._heapBase);
        }
        if (top.gt(this._heapTop)) {
            top = J9ObjectPointer.cast(this._heapTop);
        }
        if (base.gt(top)) {
            base = top;
        }
        J9ObjectPointer cursor = base;
        while (cursor.lt(top)) {
            UDATA[] indexAndMask = this.getSlotIndexAndMask(cursor);
            UDATAPointer slot = this._heapMapBits.add(indexAndMask[0]);
            if (slot.at(0L).bitAnd(indexAndMask[1]).gt(0)) {
                results.add(new MarkedObject(cursor, slot));
            }
            cursor = cursor.addOffset(this.getObjectGrain());
        }
        return results.toArray(new MarkedObject[results.size()]);
    }

    public static class MarkedObject {
        public final J9ObjectPointer object;
        public final UDATAPointer markBitsSlot;
        public final J9ObjectPointer relocatedObject;

        public MarkedObject(J9ObjectPointer object, UDATAPointer markBitsSlot) {
            this(object, markBitsSlot, null);
        }

        public MarkedObject(J9ObjectPointer object, UDATAPointer markBitsSlot, J9ObjectPointer relocatedObject) {
            this.object = object;
            this.markBitsSlot = markBitsSlot;
            this.relocatedObject = relocatedObject;
        }

        public boolean wasRelocated() {
            return this.relocatedObject != null;
        }
    }
}

