/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.ObjectModel;
import com.ibm.j9ddr.vm26.j9.gc.GCArrayObjectModel;
import com.ibm.j9ddr.vm26.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMArrayClassPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm26.structure.J9Consts;
import com.ibm.j9ddr.vm26.structure.J9IndexableObjectContiguous;
import com.ibm.j9ddr.vm26.structure.J9IndexableObjectDiscontiguous;
import com.ibm.j9ddr.vm26.structure.J9Object;
import com.ibm.j9ddr.vm26.types.U32;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.util.NoSuchElementException;

class GCArrayletObjectModel_V1
extends GCArrayObjectModel {
    GCArrayletObjectModel_V1() {
    }

    private boolean isInlineContiguousArraylet(J9IndexableObjectPointer array) throws CorruptDataException {
        U32 flags = J9IndexableObjectHelper.flags(array);
        long layoutMask = J9Consts.J9_GC_ARRAYLET_LAYOUT_MASK;
        U32 layoutFlags = flags.bitAnd(layoutMask);
        long inlineContiguousPattern = J9Consts.J9_GC_ARRAYLET_LAYOUT_DATA_IN_SPINE_BIT;
        return layoutFlags.eq(inlineContiguousPattern);
    }

    private boolean isHybridArrayletLayout(J9IndexableObjectPointer array) throws CorruptDataException {
        U32 flags = J9IndexableObjectHelper.flags(array);
        long layoutMask = J9Consts.J9_GC_ARRAYLET_LAYOUT_MASK;
        U32 layoutFlags = flags.bitAnd(layoutMask);
        long hybridPattern = J9Consts.J9_GC_ARRAYLET_LAYOUT_DATA_IN_SPINE_BIT | J9Consts.J9_GC_ARRAYLET_LAYOUT_DISCONTIGUOUS_BIT;
        return layoutFlags.eq(hybridPattern);
    }

    @Override
    public UDATA getSizeInBytesWithHeader(J9IndexableObjectPointer array) throws CorruptDataException {
        return this.getSpineSizeWithoutHeader(array).add(this.getHeaderSize(array));
    }

    @Override
    public UDATA getHashcodeOffset(J9IndexableObjectPointer array) throws CorruptDataException {
        return this.getHeaderSize(array).add(this.getSpineSizeWithoutHeader(array));
    }

    @Override
    public UDATA getHeaderSize(J9IndexableObjectPointer array) throws CorruptDataException {
        long indexableHeaderSize = 0L;
        indexableHeaderSize = this.isInlineContiguousArraylet(array) ? J9IndexableObjectContiguous.SIZEOF : J9IndexableObjectDiscontiguous.SIZEOF;
        return new UDATA(indexableHeaderSize);
    }

    private UDATA getSpineSizeWithoutHeader(J9IndexableObjectPointer array) throws CorruptDataException {
        long spineArrayoidSize = 0L;
        long spinePaddingSize = 0L;
        boolean shouldAlignData = this.shouldAlignSpineDataSection(array);
        long dataSize = this.getDataSizeInBytes(array);
        long numberOfArraylets = this.numArraylets(array);
        if (J9BuildFlags.gc_hybridArraylets) {
            if (!this.isInlineContiguousArraylet(array)) {
                spinePaddingSize = shouldAlignData ? ObjectReferencePointer.SIZEOF : 0L;
                spineArrayoidSize = numberOfArraylets * ObjectReferencePointer.SIZEOF;
            } else if (0L == dataSize) {
                spinePaddingSize = J9IndexableObjectDiscontiguous.SIZEOF - J9IndexableObjectContiguous.SIZEOF;
            }
        } else {
            spinePaddingSize = shouldAlignData ? ObjectReferencePointer.SIZEOF : 0L;
            spineArrayoidSize = numberOfArraylets * ObjectReferencePointer.SIZEOF;
        }
        long spineDataSize = 0L;
        if (this.isInlineContiguousArraylet(array)) {
            spineDataSize = dataSize;
        } else if (this.isHybridArrayletLayout(array)) {
            long leafSize = GCArrayletObjectModel_V1.getJavaVM().arrayletLeafSize().longValue();
            spineDataSize = dataSize & leafSize - 1L;
        }
        return new UDATA(spinePaddingSize + spineArrayoidSize + spineDataSize);
    }

    private boolean shouldAlignSpineDataSection(J9IndexableObjectPointer array) throws CorruptDataException {
        boolean needAlignment = false;
        if (J9BuildFlags.gc_compressedPointers) {
            needAlignment = true;
        } else {
            J9ClassPointer clazz;
            UDATA classShape;
            int sizeof_double = 8;
            if (ObjectReferencePointer.SIZEOF < (long)sizeof_double && J9Object.OBJECT_HEADER_SHAPE_DOUBLES == (classShape = ObjectModel.getClassShape(clazz = J9ObjectHelper.clazz(J9ObjectPointer.cast(array)))).longValue()) {
                needAlignment = true;
            }
        }
        return needAlignment;
    }

    private long numArraylets(J9IndexableObjectPointer array) throws CorruptDataException {
        long dataSizeInBytes = this.getDataSizeInBytes(array);
        if (0L == dataSizeInBytes) {
            return 1L;
        }
        J9JavaVMPointer vm = GCArrayletObjectModel_V1.getJavaVM();
        long leafSize = vm.arrayletLeafSize().longValue();
        long leafSizeMask = leafSize - 1L;
        long leafLogSize = vm.arrayletLeafLogSize().longValue();
        return (dataSizeInBytes >> (int)leafLogSize) + ((dataSizeInBytes & leafSizeMask) + leafSizeMask >> (int)leafLogSize);
    }

    private long getDataSizeInBytes(J9IndexableObjectPointer array) throws CorruptDataException {
        J9ClassPointer clazz = J9ObjectHelper.clazz(J9ObjectPointer.cast(array));
        U32 arrayShape = J9ROMArrayClassPointer.cast(clazz.romClass()).arrayShape();
        UDATA numberOfElements = this.getSizeInElements(array);
        UDATA size = numberOfElements.leftShift(arrayShape.bitAnd(65535).intValue());
        return UDATA.roundToSizeofUDATA(size).longValue();
    }

    @Override
    public VoidPointer getElementAddress(J9IndexableObjectPointer indexableObjectPointer, int elementIndex, int elementSize) throws CorruptDataException {
        long leafSize = GCArrayletObjectModel_V1.getJavaVM().arrayletLeafSize().longValue();
        long byteOffsetIntoData = elementIndex * elementSize;
        long numberOfArraylets = this.numArraylets(indexableObjectPointer);
        boolean isInlineContiguous = this.isInlineContiguousArraylet(indexableObjectPointer);
        if (J9BuildFlags.gc_hybridArraylets && isInlineContiguous) {
            numberOfArraylets = 0L;
        }
        long arrayletIndex = byteOffsetIntoData / leafSize;
        long spinePaddingSize = 0L;
        if (J9BuildFlags.gc_hybridArraylets && isInlineContiguous && 0L == this.getDataSizeInBytes(indexableObjectPointer)) {
            spinePaddingSize = J9IndexableObjectDiscontiguous.SIZEOF - J9IndexableObjectContiguous.SIZEOF;
        }
        long headerSize = this.getHeaderSize(indexableObjectPointer).longValue();
        VoidPointer arrayletLeafBaseAddress = null;
        if (numberOfArraylets > 0L || !J9BuildFlags.gc_hybridArraylets) {
            ObjectReferencePointer arrayoid = ObjectReferencePointer.cast(indexableObjectPointer).addOffset(headerSize + spinePaddingSize);
            arrayletLeafBaseAddress = VoidPointer.cast(arrayoid.at(arrayletIndex));
            if (arrayletLeafBaseAddress.isNull()) {
                throw new NoSuchElementException("Arraylet leaf not yet initialized");
            }
        } else {
            arrayletLeafBaseAddress = VoidPointer.cast(indexableObjectPointer).addOffset(headerSize + spinePaddingSize);
        }
        long indexIntoArraylet = byteOffsetIntoData % leafSize;
        return arrayletLeafBaseAddress.addOffset(indexIntoArraylet);
    }
}

