/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySpacePointer;
import com.ibm.j9ddr.vm24.pointer.generated.MM_MemorySpacePointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9MemorySpaceHelper;
import com.ibm.j9ddr.vm24.structure.J9MemorySegment;
import com.ibm.j9ddr.vm24.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm24.view.dtfj.java.j9.HeapObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DTFJJavaHeap
implements JavaHeap {
    private final J9MemorySpacePointer j9MemorySpace;
    private final MM_MemorySpacePointer memorySpace;
    private String description;
    private String name;
    private List<J9MemorySegmentPointer> segments;
    private List<ImageSection> sections = null;

    public DTFJJavaHeap(J9MemorySpacePointer j9MemorySpace, String memorySpaceName) throws CorruptDataException {
        this.j9MemorySpace = j9MemorySpace;
        this.memorySpace = J9MemorySpaceHelper.getMemorySpace(j9MemorySpace);
        this.name = memorySpaceName + "@" + Long.toHexString(j9MemorySpace.getAddress());
        this.initSegments();
    }

    private void initSegments() throws CorruptDataException {
        J9MemorySegmentListPointer segmentList = DTFJContext.getVm().objectMemorySegments();
        GCSegmentIterator segmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(segmentList, J9MemorySegment.MEMORY_TYPE_RAM);
        Iterator<J9MemorySegmentPointer> memorySpaceSegmentIterator = IteratorHelpers.filterIterator(segmentIterator, new IteratorHelpers.IteratorFilter<J9MemorySegmentPointer>(){

            @Override
            public boolean accept(J9MemorySegmentPointer segment) {
                J9MemorySpacePointer memorySpace;
                try {
                    memorySpace = segment.memorySpace();
                }
                catch (CorruptDataException e) {
                    EventManager.raiseCorruptDataEvent("error reading segments", e, false);
                    return false;
                }
                return memorySpace.equals(DTFJJavaHeap.this.j9MemorySpace);
            }
        });
        this.segments = IteratorHelpers.toList(memorySpaceSegmentIterator);
    }

    public String getName() {
        return this.name;
    }

    public Iterator getObjects() {
        return new Iterator(){
            Iterator currentSegmentIterator = null;
            Iterator<J9MemorySegmentPointer> segmentListIterator = DTFJJavaHeap.access$100(DTFJJavaHeap.this).iterator();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                CurrentSegmentListener currentSegmentListener = new CurrentSegmentListener();
                try {
                    EventManager.register(currentSegmentListener);
                    if (null == this.currentSegmentIterator || !this.currentSegmentIterator.hasNext()) {
                        while (this.segmentListIterator.hasNext()) {
                            try {
                                this.currentSegmentIterator = new HeapObjectIterator(DTFJJavaHeap.this, this.segmentListIterator.next());
                            }
                            catch (Throwable t) {
                                CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                                this.currentSegmentIterator = J9DDRDTFJUtils.corruptIterator(cd);
                            }
                            if (!this.currentSegmentIterator.hasNext()) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    if (null != this.currentSegmentIterator) {
                        boolean bl = this.currentSegmentIterator.hasNext();
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    EventManager.unregister(currentSegmentListener);
                }
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.currentSegmentIterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }

            class CurrentSegmentListener
            implements IEventListener {
                CurrentSegmentListener() {
                }

                @Override
                public void corruptData(String message2, CorruptDataException e, boolean fatal) {
                    if (fatal) {
                        currentSegmentIterator = J9DDRDTFJUtils.corruptIterator(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e));
                    }
                }
            }
        };
    }

    public Iterator getSections() {
        try {
            if (null == this.sections) {
                ArrayList<ImageSection> sectionList = new ArrayList<ImageSection>();
                Iterator<J9MemorySegmentPointer> segmentIterator = this.segments.iterator();
                while (segmentIterator.hasNext()) {
                    try {
                        J9MemorySegmentPointer segment = segmentIterator.next();
                        long base = segment.baseAddress().longValue();
                        long size = segment.size().longValue();
                        String name = String.format("Heap extent at 0x%x (0x%x bytes)", base, size);
                        sectionList.add(new J9DDRImageSection(DTFJContext.getProcess(), base, size, name));
                    }
                    catch (Throwable t) {
                        CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                        sectionList.add((ImageSection)cd);
                    }
                }
                this.sections = sectionList;
            }
            return this.sections.iterator();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof DTFJJavaHeap)) {
            return false;
        }
        DTFJJavaHeap compareTo = (DTFJJavaHeap)obj;
        return this.memorySpace.equals(compareTo.memorySpace);
    }

    public int hashCode() {
        return this.memorySpace.hashCode();
    }

    public String toString() {
        if (null == this.description) {
            try {
                U8Pointer minBase = U8Pointer.cast(-1L);
                U8Pointer maxTop = U8Pointer.cast(0L);
                String name = "<UNKNOWN>";
                if (this.memorySpace._name().notNull()) {
                    name = this.memorySpace._name().getCStringAtOffset(0L);
                }
                for (J9MemorySegmentPointer segment : this.segments) {
                    U8Pointer base = segment.baseAddress();
                    U8Pointer top = base.add(segment.size());
                    if (base.lt(minBase)) {
                        minBase = base;
                    }
                    if (!top.gt(maxTop)) continue;
                    maxTop = top;
                }
                this.description = J9BuildFlags.env_data64 ? String.format("%s [%s, Span: 0x%016x->0x%016x, Segments: %d]", this.getName(), name, minBase.getAddress(), maxTop.getAddress(), this.segments.size()) : String.format("%s [%s, Span: 0x%08x->0x%08x, Segments: %d]", this.getName(), name, minBase.getAddress(), maxTop.getAddress(), this.segments.size());
            }
            catch (Throwable t) {
                J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
                this.description = super.toString();
            }
        }
        return this.description;
    }

    static /* synthetic */ List access$100(DTFJJavaHeap x0) {
        return x0.segments;
    }
}

