/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.gc.GCObjectModel;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;

public final class ObjectModel {
    protected static final GCObjectModel gcObjectModel;

    private ObjectModel() {
    }

    public static UDATA adjustSizeInBytes(UDATA sizeInBytes) {
        return gcObjectModel.adjustSizeInBytes(sizeInBytes);
    }

    public static U32 getObjectShape(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getObjectShape(object);
    }

    public static U32 getClassShape(J9ClassPointer clazz) throws CorruptDataException {
        return gcObjectModel.getClassShape(clazz);
    }

    public static boolean isIndexable(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isIndexable(object);
    }

    public static boolean isDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isDeadObject(object);
    }

    public static boolean isSingleSlotDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isSingleSlotDeadObject(object);
    }

    public static UDATA getSizeInBytesMultiSlotDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesMultiSlotDeadObject(object);
    }

    public static UDATA getSizeInBytesSingleSlotDeadObject(J9ObjectPointer object) {
        return gcObjectModel.getSizeInBytesSingleSlotDeadObject(object);
    }

    public static UDATA getSizeInBytesDeadObject(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesDeadObject(object);
    }

    public static UDATA getSizeInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getSizeInBytesWithHeader(object);
    }

    public static UDATA getConsumedSizeInBytesWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getConsumedSizeInBytesWithHeader(object);
    }

    public UDATA getSizeInSlotsWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return UDATA.convertBytesToSlots(ObjectModel.getSizeInBytesWithHeader(object));
    }

    public UDATA getConsumedSizeInSlotsWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return UDATA.convertBytesToSlots(ObjectModel.getConsumedSizeInBytesWithHeader(object));
    }

    public static U32 getAge(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getAge(object);
    }

    public static boolean isRemembered(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isRemembered(object);
    }

    public static boolean isOld(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.isOld(object);
    }

    public static UDATA getSizeInElements(J9ObjectPointer object) throws IllegalArgumentException, CorruptDataException {
        return gcObjectModel.getSizeInElements(object);
    }

    public static int getObjectHashCode(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getObjectHashCode(object);
    }

    public static UDATA getHeaderSize(J9ObjectPointer object) throws CorruptDataException {
        return gcObjectModel.getHeaderSize(object);
    }

    public static VoidPointer getElementAddress(J9IndexableObjectPointer indexableObjectPointer, int elementIndex, int elementSize) throws CorruptDataException {
        return gcObjectModel.getElementAddress(indexableObjectPointer, elementIndex, elementSize);
    }

    static {
        GCObjectModel objectModel = null;
        try {
            objectModel = GCObjectModel.from();
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error initializing the object model", cde, true);
            objectModel = null;
        }
        gcObjectModel = objectModel;
    }
}

