/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.BytecodeGenerator;
import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import com.ibm.j9ddr.tools.FlagStructureList;
import com.ibm.j9ddr.tools.store.J9DDRStructureStore;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PointerGenerator {
    private static final String BEGIN_USER_IMPORTS = "[BEGIN USER IMPORTS]";
    private static final String END_USER_IMPORTS = "[END USER IMPORTS]";
    private static final String BEGIN_USER_CODE = "[BEGIN USER CODE]";
    private static final String END_USER_CODE = "[END USER CODE]";
    private final Map<String, String> opts = new HashMap<String, String>();
    StructureReader structureReader;
    File outputDir;
    File outputDirHelpers;
    private boolean cacheClass;
    private boolean cacheFields;
    private boolean generalizeSimpleTypes;
    private Properties cacheProperties;
    private int errorCount;
    private StructureTypeManager typeManager;
    private static final Pattern offsetPattern = Pattern.compile("^(.+)_v\\d+$");
    private static final Pattern ConstPattern = Pattern.compile("\\s*\\bconst\\s+");
    private static final Pattern TypeTagPattern = Pattern.compile("\\s*\\b(class|enum|struct)\\s+");

    public PointerGenerator() {
        this.opts.put("-p", null);
        this.opts.put("-o", null);
        this.opts.put("-f", null);
        this.opts.put("-v", null);
        this.opts.put("-s", "superset.dat");
        this.opts.put("-h", null);
        this.opts.put("-u", "true");
        this.opts.put("-c", "");
        this.opts.put("-l", "false");
        this.opts.put("-a", null);
    }

    public static void main(String[] args) throws Exception {
        PointerGenerator app = new PointerGenerator();
        app.parseArgs(args);
        app.generateClasses();
        if (app.errorCount == 0) {
            System.out.println("Pointer class generation complete");
        } else {
            System.out.println("Pointer class generation failed");
            System.exit(1);
        }
    }

    private void generateClasses() {
        Throwable throwable;
        String fileName = this.opts.get("-f");
        String supersetFileName = this.opts.get("-s");
        try {
            J9DDRStructureStore store = new J9DDRStructureStore(fileName, supersetFileName);
            System.out.println("superset directory name : " + fileName);
            System.out.println("superset file name : " + store.getSuperSetFileName());
            throwable = null;
            try (InputStream inputStream = store.getSuperset();){
                this.structureReader = new StructureReader(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            ++this.errorCount;
            System.out.println("Problem with file: " + fileName);
            e.printStackTrace();
            return;
        }
        this.structureReader.removeReservedTypeNames();
        String auxFieldInfo = this.opts.get("-a");
        if (auxFieldInfo != null) {
            try {
                throwable = null;
                try (FileInputStream stream = new FileInputStream(auxFieldInfo);){
                    this.structureReader.loadAuxFieldInfo(stream);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                ++this.errorCount;
                System.out.println("Problem with file: " + auxFieldInfo);
                e.printStackTrace();
                return;
            }
        }
        this.outputDir = this.getOutputDir("-p");
        if (this.opts.get("-h") != null) {
            this.outputDirHelpers = this.getOutputDir("-h");
        }
        this.typeManager = new StructureTypeManager(this.structureReader.getStructures());
        for (StructureReader.StructureDescriptor structure : this.structureReader.getStructures()) {
            String error;
            try {
                if (FlagStructureList.isFlagsStructure(structure.getName())) {
                    this.generateBuildFlags(structure);
                    continue;
                }
                this.generateClass(structure);
            }
            catch (FileNotFoundException e) {
                ++this.errorCount;
                error = String.format("File not found processing: %s: %s", structure.getPointerName(), e.getMessage());
                System.out.println(error);
            }
            catch (IOException e) {
                ++this.errorCount;
                error = String.format("IOException processing: %s: %s", structure.getPointerName(), e.getMessage());
                System.out.println(error);
            }
        }
    }

    private void generateBuildFlags(StructureReader.StructureDescriptor structure) throws IOException {
        String className = structure.getName();
        boolean useCName = "29".equals(this.opts.get("-v")) && BytecodeGenerator.shouldUseCNameFor(className);
        File javaFile = new File(this.outputDir, className + ".java");
        ArrayList<String> userImports = new ArrayList<String>();
        ArrayList<String> userCode = new ArrayList<String>();
        this.collectMergeData(javaFile, userImports, userCode);
        byte[] original = null;
        int length = 0;
        if (javaFile.exists()) {
            length = (int)javaFile.length();
            original = new byte[length];
            try (FileInputStream fis = new FileInputStream(javaFile);){
                fis.read(original);
            }
        }
        ByteArrayOutputStream newContents = new ByteArrayOutputStream(length);
        try (PrintWriter writer = new PrintWriter(newContents);){
            List<StructureReader.ConstantDescriptor> constants = structure.getConstants();
            PointerGenerator.writeCopyright(writer);
            writer.format("package %s;%n", this.opts.get("-p"));
            PointerGenerator.writeBuildFlagImports(writer, useCName);
            writer.println();
            this.writeClassComment(writer, className);
            writer.format("public final class %s {%n", className);
            writer.println();
            writer.println("\t// Do not instantiate constant classes");
            writer.format("\tprivate %s() {%n", className);
            writer.format("\t}%n", new Object[0]);
            writer.println();
            PointerGenerator.writeBuildFlags(writer, constants, useCName);
            writer.println();
            PointerGenerator.writeBuildFlagsStaticInitializer(writer, className, constants, useCName);
            writer.println("}");
        }
        byte[] newContentsBytes = newContents.toByteArray();
        if (null == original || !Arrays.equals(original, newContentsBytes)) {
            try (FileOutputStream fos = new FileOutputStream(javaFile);){
                fos.write(newContentsBytes);
            }
        }
    }

    private static void writeBuildFlagsStaticInitializer(PrintWriter writer, String className, List<StructureReader.ConstantDescriptor> constants, boolean useCName) {
        writer.println("\tstatic {");
        writer.println("\t\tHashSet<String> flags$ = new HashSet<>();");
        writer.println();
        writer.println("\t\ttry {");
        writer.println("\t\t\tClassLoader loader$ = " + className + ".class.getClassLoader();");
        writer.println("\t\t\tif (!(loader$ instanceof com.ibm.j9ddr.J9DDRClassLoader)) {");
        writer.println("\t\t\t\tthrow new IllegalArgumentException(\"Cannot determine the runtime loader\");");
        writer.println("\t\t\t}");
        writer.println("\t\t\tClass<?> runtimeClass = ((com.ibm.j9ddr.J9DDRClassLoader) loader$).loadClassRelativeToStream(\"structure." + className + "\", false);");
        writer.println("\t\t\tfor (Field field : runtimeClass.getFields()) {");
        writer.println("\t\t\t\tif (field.getLong(runtimeClass) != 0) {");
        if (useCName) {
            writer.println("\t\t\t\t\tflags$.add(BytecodeGenerator.getFlagCName(field.getName()));");
        } else {
            writer.println("\t\t\t\t\tflags$.add(field.getName());");
        }
        writer.println("\t\t\t\t}");
        writer.println("\t\t\t}");
        writer.println("\t\t} catch (ClassNotFoundException | IllegalAccessException e) {");
        writer.println("\t\t\tthrow new IllegalArgumentException(String.format(\"Can not initialize flags from core file.%n%s\", e.getMessage()));");
        writer.println("\t\t}");
        writer.println();
        for (StructureReader.ConstantDescriptor constant : constants) {
            String name = constant.getName();
            String cname = useCName ? BytecodeGenerator.getFlagCName(name) : name;
            writer.format("\t\t%s = flags$.contains(\"%s\")", cname, cname);
            if (useCName && !name.equals(cname)) {
                writer.format(" || flags$.contains(\"%s\")", name);
            }
            writer.println(";");
        }
        writer.println("\t}");
    }

    private void generateClass(StructureReader.StructureDescriptor structure) throws IOException {
        Object superName;
        File javaFile = new File(this.outputDir, structure.getPointerName() + ".java");
        ArrayList<String> userImports = new ArrayList<String>();
        ArrayList<String> userCode = new ArrayList<String>();
        if (this.opts.get("-u").equals("true")) {
            this.collectMergeData(javaFile, userImports, userCode);
        } else {
            this.setCacheStatusFromPropertyFile(structure);
        }
        if (this.cacheClass || this.cacheFields) {
            System.out.println("Caching enabled for " + structure.getName() + "=" + this.cacheClass + "," + this.cacheFields);
        }
        int length = 0;
        byte[] original = null;
        if (javaFile.exists()) {
            length = (int)javaFile.length();
            original = new byte[length];
            try (FileInputStream fis = new FileInputStream(javaFile);){
                fis.read(original);
            }
        }
        ByteArrayOutputStream newContents = new ByteArrayOutputStream(length);
        try (PrintWriter writer = new PrintWriter(newContents);){
            PointerGenerator.writeCopyright(writer);
            writer.println();
            this.writeGeneratedWarning(writer);
            writer.format("package %s;%n", this.opts.get("-p"));
            writer.println();
            if (this.opts.get("-u").equals("true")) {
                PointerGenerator.writerUserData(BEGIN_USER_IMPORTS, END_USER_IMPORTS, userImports, writer);
            }
            writer.println();
            this.writeImports(writer, structure);
            writer.println();
            this.writeClassComment(writer, structure.getPointerName());
            writer.format("@com.ibm.j9ddr.GeneratedPointerClass(structureClass=%s.class)", structure.getName());
            writer.println();
            superName = structure.getSuperName();
            if (((String)superName).isEmpty()) {
                superName = "Structure";
            }
            writer.format("public class %s extends %sPointer {%n", structure.getPointerName(), superName);
            writer.println();
            writer.println("\t// NULL");
            writer.format("\tpublic static final %s NULL = new %s(0);%n", structure.getPointerName(), structure.getPointerName());
            writer.println();
            if (this.cacheClass) {
                writer.println("\t// Class Cache");
                if (this.opts.get("-u").equals("false")) {
                    writer.println("\tprivate static final boolean CACHE_CLASS = true;");
                }
                writer.format("\tprivate static HashMap<Long, %s> CLASS_CACHE = new HashMap<>();%n", structure.getPointerName());
                writer.println();
            }
            if (this.cacheFields && this.opts.get("-u").equals("false")) {
                writer.println("\tprivate static final boolean CACHE_FIELDS = true;");
            }
            if (this.opts.get("-u").equals("true")) {
                PointerGenerator.writerUserData(BEGIN_USER_CODE, END_USER_CODE, userCode, writer);
            }
            writer.println();
            this.writeConstructor(writer, structure);
            if (this.cacheClass) {
                writer.println("\t// Caching support methods");
                writer.println();
                this.generateCacheSupportMethods(writer, structure);
            }
            writer.println("\t// Implementation methods");
            writer.println();
            this.generateImplementationMethods(writer, structure);
            writer.println("}");
        }
        byte[] newContentsBytes = newContents.toByteArray();
        if (null == original || !Arrays.equals(original, newContentsBytes)) {
            FileOutputStream fos = new FileOutputStream(javaFile);
            superName = null;
            try {
                fos.write(newContentsBytes);
            }
            catch (Throwable throwable) {
                superName = throwable;
                throw throwable;
            }
            finally {
                if (fos != null) {
                    if (superName != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)superName).addSuppressed(throwable);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
        }
        if (this.outputDirHelpers != null && userCode.size() > 4) {
            File helperFile = new File(this.outputDirHelpers, structure.getPointerName() + ".java");
            try (PrintWriter helperWriter = new PrintWriter(helperFile);){
                for (String line : userImports) {
                    helperWriter.println(line);
                }
                for (String line : userCode) {
                    helperWriter.println(line);
                }
            }
        }
    }

    private void setCacheStatusFromPropertyFile(StructureReader.StructureDescriptor structure) {
        String opt = this.opts.get("-c");
        if (opt == null || opt.isEmpty()) {
            this.cacheClass = false;
            this.cacheFields = false;
        } else {
            String values;
            String[] parts;
            block19: {
                if (this.cacheProperties == null) {
                    this.cacheProperties = new Properties();
                    File file = new File(opt);
                    if (file.exists()) {
                        try (FileInputStream in = new FileInputStream(file);){
                            this.cacheProperties.load(in);
                            break block19;
                        }
                        catch (Exception e) {
                            String msg = String.format("The cache properties file [%s] specified by the -c option could not be read", file.getAbsolutePath());
                            throw new IllegalArgumentException(msg, e);
                        }
                    }
                    String msg = String.format("The cache properties file [%s] specified by the -c option does not exist", file.getAbsolutePath());
                    throw new IllegalArgumentException(msg);
                }
            }
            if ((parts = (values = this.cacheProperties.getProperty(structure.getName(), "false,false")).split(",")).length != 2) {
                String msg = String.format("The cache properties file [%s] contains an invalid setting for the key [%s]. The value should be in the format <boolean>,<boolean>", opt);
                throw new IllegalArgumentException(msg);
            }
            this.cacheClass = Boolean.parseBoolean(parts[0]);
            this.cacheFields = Boolean.parseBoolean(parts[1]);
        }
    }

    private void generateCacheSupportMethods(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        if (this.cacheClass) {
            writer.format("\tprivate static void setCache(Long address, %s clazz) {%n", structure.getPointerName());
            writer.format("\t\tCLASS_CACHE.put(address, clazz);%n", new Object[0]);
            writer.format("\t}%n", new Object[0]);
            writer.println();
            writer.format("\tprivate static %s checkCache(Long address) {%n", structure.getPointerName());
            writer.format("\t\treturn CLASS_CACHE.get(address);%n", new Object[0]);
            writer.format("\t}%n", new Object[0]);
            writer.println();
        }
    }

    private static void writeBuildFlags(PrintWriter writer, List<StructureReader.ConstantDescriptor> constants, boolean useCName) {
        writer.println("\t// Build Flags");
        for (StructureReader.ConstantDescriptor constant : constants) {
            String name = constant.getName();
            if (useCName) {
                name = BytecodeGenerator.getFlagCName(name);
            }
            writer.format("\tpublic static final boolean %s;%n", name);
        }
    }

    private void collectMergeData(File javaFile, List<String> userImports, List<String> userCode) throws IOException {
        if (javaFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(javaFile));){
                String aLine;
                while ((aLine = reader.readLine()) != null) {
                    if (aLine.contains(BEGIN_USER_IMPORTS)) {
                        PointerGenerator.collectUserData(userImports, reader, END_USER_IMPORTS);
                        continue;
                    }
                    if (!aLine.contains(BEGIN_USER_CODE)) continue;
                    PointerGenerator.collectUserData(userCode, reader, END_USER_CODE);
                }
            }
        }
        this.cacheClass = false;
        this.cacheFields = false;
        for (String line : userCode) {
            int pos = 0;
            pos = line.indexOf("private static final boolean CACHE_FIELDS");
            if (pos != -1) {
                this.cacheFields |= PointerGenerator.getFlagValue(line, pos);
            }
            if ((pos = line.indexOf("private static final boolean CACHE_CLASS")) == -1) continue;
            this.cacheClass |= PointerGenerator.getFlagValue(line, pos);
        }
    }

    private static boolean getFlagValue(String line, int start) {
        int semicolon;
        int equals = line.indexOf("=", start);
        if (equals != -1 && (semicolon = line.indexOf(";", equals)) != -1) {
            String value = line.substring(equals + 1, semicolon).trim();
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    private static void collectUserData(List<String> userData, BufferedReader reader, String endTag) throws IOException {
        String aLine;
        while ((aLine = reader.readLine()) != null && !aLine.contains(endTag)) {
            userData.add(aLine);
        }
    }

    private static void writerUserData(String beginTag, String endTag, List<String> data, PrintWriter writer) {
        writer.print("/*");
        writer.print(beginTag);
        writer.println("*/");
        for (String line : data) {
            writer.println(line);
        }
        writer.print("/*");
        writer.print(endTag);
        writer.println("*/");
    }

    private void writeGeneratedWarning(PrintWriter writer) {
        writer.println("/*");
        writer.println(" * WARNING!!! GENERATED FILE");
        writer.println(" *");
        writer.println(" * This class is generated.");
        writer.println(" * Do not use the Eclipse \"Organize Imports\" feature on this class.");
        if (this.opts.get("-u").equals("true")) {
            writer.println(" *");
            writer.println(" * It can contain user content, but that content must be delimited with the");
            writer.println(" * the tags");
            writer.println(" * [BEGIN USER IMPORTS]");
            writer.println(" * [END USER IMPORTS]");
            writer.println(" *");
            writer.println(" * or");
            writer.println(" *");
            writer.println(" * [BEGIN USER CODE]");
            writer.println(" * [END USER CODE]");
            writer.println(" *");
            writer.println(" * These tags are entered as comments.  Characters before [ and after ] are ignored.");
            writer.println(" * Lines between the tags are inserted into the newly generated file.");
            writer.println(" *");
            writer.println(" * IMPORTS are combined and inserted above newly generated imports.  CODE is combined");
            writer.println(" * and inserted immediately after the class declaration");
            writer.println(" *");
            writer.println(" * All lines outside these tags are lost and replaced with newly generated code.");
        }
        writer.println(" */");
    }

    private void writeClassComment(PrintWriter writer, String name) {
        writer.println("/**");
        writer.format(" * Structure: %s%n", name);
        writer.println(" *");
        writer.println(" * A generated implementation of a VM structure");
        writer.println(" *");
        if (this.opts.get("-u").equals("true")) {
            writer.println(" * This class contains generated code and MAY contain hand written user code.");
            writer.println(" *");
            writer.println(" * Hand written user code must be contained at the top of");
            writer.println(" * the class file, specifically above");
            writer.println(" * the comment line containing WARNING!!! GENERATED CODE");
            writer.println(" *");
            writer.println(" * ALL code below the GENERATED warning will be replaced with new generated code");
            writer.println(" * each time the PointerGenerator utility is run.");
            writer.println(" *");
            writer.format(" * The generated code will provide getters for all elements in the %s%n", name);
            writer.println(" * structure.  Where possible, meaningful return types are inferred.");
            writer.println(" *");
            writer.println(" * The user may add methods to provide meaningful return types where only pointers");
            writer.println(" * could be automatically inferred.");
        } else {
            writer.println(" * Do not place hand written user code in this class as it will be overwritten.");
        }
        writer.println(" */");
    }

    private void generateImplementationMethods(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        List<StructureReader.FieldDescriptor> fields = structure.getFields();
        Collections.sort(fields);
        block23: for (StructureReader.FieldDescriptor fieldDescriptor : fields) {
            if (PointerGenerator.omitFieldImplementation(structure, fieldDescriptor)) continue;
            if (fieldDescriptor.isRequired() && !fieldDescriptor.isPresent()) {
                ++this.errorCount;
                System.out.printf("Missing required field: %s.%s%n", structure.getName(), fieldDescriptor.getName());
                continue;
            }
            String typeName = fieldDescriptor.getType();
            int type2 = this.typeManager.getType(typeName);
            switch (type2) {
                case 120: {
                    this.writeStructureMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 121: {
                    this.writeStructurePointerMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 110: {
                    this.writePointerMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 113: {
                    this.writeArrayMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 111: {
                    this.writeSRPMethod(writer, structure, fieldDescriptor, false);
                    continue block23;
                }
                case 112: {
                    this.writeSRPMethod(writer, structure, fieldDescriptor, true);
                    continue block23;
                }
                case 114: {
                    this.writeSRPPointerMethod(writer, structure, fieldDescriptor, false);
                    continue block23;
                }
                case 115: {
                    this.writeSRPPointerMethod(writer, structure, fieldDescriptor, true);
                    continue block23;
                }
                case 130: {
                    this.writeFJ9ObjectMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 131: {
                    this.writeFJ9ObjectPointerMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 132: {
                    this.writeJ9ObjectClassMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 133: {
                    this.writeJ9ObjectClassPointerMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 134: {
                    this.writeJ9ObjectMonitorMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 135: {
                    this.writeJ9ObjectMonitorPointerMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 0: {
                    this.writeStructureMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 100: {
                    this.writeBoolMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 102: {
                    this.writeDoubleMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 103: {
                    this.writeFloatMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 101: {
                    this.writeEnumMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 105: {
                    this.writeEnumPointerMethod(writer, structure, fieldDescriptor);
                    continue block23;
                }
                case 104: {
                    int colonIndex = typeName.indexOf(58);
                    if (colonIndex == -1) {
                        throw new IllegalArgumentException(String.format("%s is not a bitfield", fieldDescriptor));
                    }
                    this.writeBitFieldMethod(writer, structure, fieldDescriptor, fieldDescriptor.getName());
                    continue block23;
                }
            }
            if (1 <= type2 && type2 <= 99) {
                this.writeSimpleTypeMethod(writer, structure, fieldDescriptor, type2);
                continue;
            }
            String error = String.format("Unhandled structure type: %s->%s %s", structure.getPointerName(), fieldDescriptor.getName(), typeName);
            System.out.println(error);
        }
    }

    private void writeSRPPointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor, boolean wide) {
        String pointerType;
        String getter = fieldDescriptor.getName();
        String string = pointerType = wide ? "WideSelfRelativePointer" : "SelfRelativePointer";
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", pointerType, getter);
        }
        this.writeMethodSignature(writer, pointerType, getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "%s.cast(getPointerAtOffset(%s._%sOffset_))", pointerType, structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeBitFieldMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor, String getter) {
        CTypeParser parser = new CTypeParser(fieldDescriptor.getType());
        String typeString = parser.getCoreType();
        if (getter.isEmpty()) {
            writer.format("\t// %s %s%n", fieldDescriptor.getDeclaredType(), fieldDescriptor.getName());
            writer.println();
            return;
        }
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", typeString, getter);
        }
        this.writeMethodSignature(writer, this.generalizeSimpleType(typeString), getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "get%sBitfield(%s._%s_s_, %s._%s_b_)", typeString, structure.getName(), getter, structure.getName(), getter);
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
    }

    static boolean omitFieldImplementation(StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor field) {
        String name = structure.getPointerName() + "." + field.getName();
        return name.contains("#");
    }

    private void writeMethodSignature(PrintWriter writer, String returnType, String getter, StructureReader.FieldDescriptor field, boolean fieldAccessor) {
        boolean optional;
        writer.format("\t// %s %s%n", field.getDeclaredType(), field.getDeclaredName());
        if (fieldAccessor) {
            writer.format("\t@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName=\"_%sOffset_\", declaredType=\"%s\")", this.getOffsetConstant(field), field.getDeclaredType());
            writer.println();
        }
        String exceptions = (optional = field.isOptional()) ? "CorruptDataException, NoSuchFieldException" : "CorruptDataException";
        writer.format("\tpublic %s %s() throws %s {%n", returnType, getter, exceptions);
        if (optional) {
            writer.println("\ttry {");
        }
    }

    private void writeEAMethod(PrintWriter writer, String returnType, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName() + "EA";
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, this.generalizeSimplePointer(returnType), getter, fieldDescriptor, false);
        this.writeMethodReturn(writer, getter, "%s.cast(nonNullFieldEA(%s._%sOffset_))", returnType, structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
    }

    private void writeEnumEAMethod(PrintWriter writer, String returnType, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName() + "EA";
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, false);
        this.writeMethodReturn(writer, getter, "%s.cast(nonNullFieldEA(%s._%sOffset_), %s.class)", returnType, structure.getName(), this.getOffsetConstant(fieldDescriptor), PointerGenerator.getEnumType(fieldDescriptor.getType()));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
    }

    private String getOffsetConstant(StructureReader.FieldDescriptor fieldDescriptor) {
        String fieldName = fieldDescriptor.getName();
        if (this.opts.get("-l").equals("true")) {
            return PointerGenerator.getOffsetConstant(fieldName);
        }
        return fieldName;
    }

    public static String getOffsetConstant(String fieldName) {
        Matcher matcher = offsetPattern.matcher(fieldName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return fieldName;
    }

    private void writeSRPEAMethod(PrintWriter writer, String returnType, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName() + "EA";
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, false);
        this.writeMethodReturn(writer, getter, "%s.cast(nonNullFieldEA(%s._%sOffset_))", returnType, structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
    }

    private static void writeMethodClose(PrintWriter writer, StructureReader.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.isOptional()) {
            writer.println("\t} catch (NoClassDefFoundError | NoSuchFieldError e) {");
            writer.println("\t\tthrow new NoSuchFieldException();");
            writer.println("\t}");
        }
        writer.println("\t}");
        writer.println();
    }

    private void writePointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        String pointerType = PointerGenerator.getPointerType(fieldDescriptor.getType());
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", pointerType, getter);
        }
        this.writeMethodSignature(writer, this.generalizeSimplePointer(pointerType), getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "%s.cast(getPointerAtOffset(%s._%sOffset_))", pointerType, structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private static String getPointerType(String pointerType) {
        int firstStar;
        String type2 = ConstPattern.matcher(pointerType).replaceAll("").trim();
        if (type2.indexOf(42, (firstStar = type2.indexOf(42)) + 1) > 0) {
            return "PointerPointer";
        }
        if ((type2 = type2.substring(0, firstStar).trim()).equals("bool")) {
            return "BoolPointer";
        }
        if (type2.equals("double")) {
            return "DoublePointer";
        }
        if (type2.equals("float")) {
            return "FloatPointer";
        }
        if (type2.equals("void")) {
            return "VoidPointer";
        }
        return type2 + "Pointer";
    }

    private void writeArrayMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        try {
            String fieldType = fieldDescriptor.getType();
            String returnType = this.getArrayType(fieldType);
            if (returnType == null) {
                String error = String.format("Unhandled array type: %s->%s %s", structure.getPointerName(), fieldDescriptor.getName(), fieldType);
                System.out.println(error);
            } else if (returnType.equals("EnumPointer")) {
                this.writeEnumEAMethod(writer, returnType, structure, fieldDescriptor);
            } else {
                this.writeEAMethod(writer, returnType, structure, fieldDescriptor);
            }
        }
        catch (RuntimeException e) {
            ++this.errorCount;
            if (this.errorCount < 100) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    private static String getEnumType(String enumDeclaration) {
        int start = 0;
        int end = enumDeclaration.length();
        if (enumDeclaration.startsWith("enum ")) {
            start = "enum ".length();
        }
        if (enumDeclaration.endsWith("[]")) {
            end -= 2;
        }
        return enumDeclaration.substring(start, end);
    }

    private String getArrayType(String arrayDeclaration) {
        String componentType = arrayDeclaration.substring(0, arrayDeclaration.lastIndexOf(91)).trim();
        int arrayType = this.typeManager.getType(componentType);
        switch (arrayType) {
            case 100: {
                return "BoolPointer";
            }
            case 101: {
                return "EnumPointer";
            }
            case 102: {
                return "DoublePointer";
            }
            case 103: {
                return "FloatPointer";
            }
            case 104: {
                break;
            }
            case 110: 
            case 113: 
            case 121: 
            case 131: 
            case 133: 
            case 135: {
                return "PointerPointer";
            }
            case 111: 
            case 112: {
                break;
            }
            case 120: {
                return PointerGenerator.removeTypeTags(componentType) + "Pointer";
            }
            case 130: {
                return "ObjectReferencePointer";
            }
            case 132: {
                return "ObjectClassReferencePointer";
            }
            case 134: {
                return "ObjectMonitorReferencePointer";
            }
            default: {
                if (1 > arrayType || arrayType > 99) break;
                return componentType + "Pointer";
            }
        }
        return null;
    }

    private void writeBoolMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        if (this.cacheFields) {
            writer.format("\tprivate Boolean %s_cache;%n", getter);
        }
        this.writeMethodSignature(writer, "boolean", getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "getBoolAtOffset(%s._%sOffset_)", structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "BoolPointer", structure, fieldDescriptor);
    }

    private void writeDoubleMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        if (this.cacheFields) {
            writer.format("\tprivate Double %s_cache;%n", getter);
        }
        this.writeMethodSignature(writer, "double", getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "getDoubleAtOffset(%s._%sOffset_)", structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "DoublePointer", structure, fieldDescriptor);
    }

    private void writeEnumMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = this.getOffsetConstant(fieldDescriptor);
        String enumType = PointerGenerator.getEnumType(fieldDescriptor.getType());
        if (this.cacheFields) {
            writer.format("\tprivate Long %s_cache;%n", getter);
        }
        this.writeMethodSignature(writer, "long", getter, fieldDescriptor, true);
        String name = structure.getName();
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\tif (%s.SIZEOF == 1) {%n", enumType);
            writer.format("\t\t\t\t\t%s_cache = Long.valueOf(getByteAtOffset(%s._%sOffset_));%n", getter, name, offsetConstant);
            writer.format("\t\t\t\t} else if (%s.SIZEOF == 2) {%n", enumType);
            writer.format("\t\t\t\t\t%s_cache = Long.valueOf(getShortAtOffset(%s._%sOffset_));%n", getter, name, offsetConstant);
            writer.format("\t\t\t\t} else if (%s.SIZEOF == 4) {%n", enumType);
            writer.format("\t\t\t\t\t%s_cache = Long.valueOf(getIntAtOffset(%s._%sOffset_));%n", getter, name, offsetConstant);
            writer.format("\t\t\t\t} else if (%s.SIZEOF == 8) {%n", enumType);
            writer.format("\t\t\t\t\t%s_cache = Long.valueOf(getLongAtOffset(%s._%sOffset_));%n", getter, name, offsetConstant);
            writer.format("\t\t\t\t} else {%n", new Object[0]);
            writer.format("\t\t\t\t\tthrow new IllegalArgumentException(\"Unexpected ENUM size in core file\");%n", new Object[0]);
            writer.format("\t\t\t\t}%n", new Object[0]);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache.longValue();%n", getter);
            writer.format("\t\t}%n", new Object[0]);
        }
        writer.format("\t\tif (%s.SIZEOF == 1) {%n", enumType);
        writer.format("\t\t\treturn getByteAtOffset(%s._%sOffset_);%n", name, offsetConstant);
        writer.format("\t\t} else if (%s.SIZEOF == 2) {%n", enumType);
        writer.format("\t\t\treturn getShortAtOffset(%s._%sOffset_);%n", name, offsetConstant);
        writer.format("\t\t} else if (%s.SIZEOF == 4) {%n", enumType);
        writer.format("\t\t\treturn getIntAtOffset(%s._%sOffset_);%n", name, offsetConstant);
        writer.format("\t\t} else if (%s.SIZEOF == 8) {%n", enumType);
        writer.format("\t\t\treturn getLongAtOffset(%s._%sOffset_);%n", name, offsetConstant);
        writer.format("\t\t} else {%n", new Object[0]);
        writer.format("\t\t\tthrow new IllegalArgumentException(\"Unexpected ENUM size in core file\");%n", new Object[0]);
        writer.format("\t\t}%n", new Object[0]);
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEnumEAMethod(writer, "EnumPointer", structure, fieldDescriptor);
    }

    private void writeEnumPointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        String pointerType = "EnumPointer";
        String type2 = fieldDescriptor.getType();
        String enumType = PointerGenerator.getEnumType(type2.substring(0, type2.indexOf(42)));
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", pointerType, getter);
        }
        this.writeMethodSignature(writer, pointerType, getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "%s.cast(getPointerAtOffset(%s._%sOffset_), %s.class)", pointerType, structure.getName(), this.getOffsetConstant(fieldDescriptor), enumType);
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeFloatMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        if (this.cacheFields) {
            writer.format("\tprivate Float %s_cache;%n", getter);
        }
        this.writeMethodSignature(writer, "float", getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "getFloatAtOffset(%s._%sOffset_)", structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "FloatPointer", structure, fieldDescriptor);
    }

    private String generalizeSimpleType(String type2) {
        if (this.generalizeSimpleTypes) {
            if ("I32".equals(type2) || "I64".equals(type2)) {
                return "IDATA";
            }
            if ("U32".equals(type2) || "U64".equals(type2)) {
                return "UDATA";
            }
        }
        return type2;
    }

    private String generalizeSimplePointer(String type2) {
        if (this.generalizeSimpleTypes) {
            if ("I32Pointer".equals(type2) || "I64Pointer".equals(type2)) {
                return "IDATAPointer";
            }
            if ("U32Pointer".equals(type2) || "U64Pointer".equals(type2)) {
                return "UDATAPointer";
            }
        }
        return type2;
    }

    private void writeSimpleTypeMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor, int type2) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = this.getOffsetConstant(fieldDescriptor);
        String typeString = fieldDescriptor.getType();
        String returnType = this.generalizeSimpleType(typeString);
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", typeString, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        String accessor = StructureTypeManager.simpleTypeAccessorMap.get(type2);
        switch (type2) {
            case 5: 
            case 10: {
                this.writeMethodReturn(writer, getter, "%s(%s._%sOffset_)", accessor, structure.getName(), offsetConstant);
                break;
            }
            default: {
                this.writeMethodReturn(writer, getter, "new %s(%s(%s._%sOffset_))", typeString, accessor, structure.getName(), offsetConstant);
            }
        }
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, returnType + "Pointer", structure, fieldDescriptor);
    }

    private static String removeTypeTags(String type2) {
        return TypeTagPattern.matcher(type2).replaceAll("").trim();
    }

    private void writeSRPMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor, boolean isWide) {
        String pointerType;
        String getter = fieldDescriptor.getName();
        String offsetConstant = this.getOffsetConstant(fieldDescriptor);
        String typeString = fieldDescriptor.getType();
        String prefix = isWide ? "J9WSRP" : "J9SRP";
        int prefixLength = prefix.length();
        String getAtOffsetFunction = isWide ? "getPointerAtOffset" : "getIntAtOffset";
        String referencedTypeString = null;
        referencedTypeString = typeString.startsWith(prefix) && typeString.startsWith("(", prefixLength) ? typeString.substring(prefixLength + 1, typeString.length() - 1).trim() : "void";
        int type2 = this.typeManager.getType(referencedTypeString);
        switch (type2) {
            case 120: {
                pointerType = PointerGenerator.removeTypeTags(referencedTypeString) + "Pointer";
                break;
            }
            case 0: {
                pointerType = "VoidPointer";
                break;
            }
            case 111: {
                pointerType = "SelfRelativePointer";
                break;
            }
            case 112: {
                pointerType = "WideSelfRelativePointer";
                break;
            }
            default: {
                if (1 <= type2 && type2 <= 99) {
                    pointerType = referencedTypeString + "Pointer";
                    break;
                }
                throw new RuntimeException("Unexpected SRP reference type: " + type2 + " from " + typeString);
            }
        }
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", pointerType, getter);
        }
        this.writeMethodSignature(writer, this.generalizeSimplePointer(pointerType), getter, fieldDescriptor, true);
        String value = String.format("%s.cast(address + (%s._%sOffset_ + nextAddress))", pointerType, structure.getName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\tlong nextAddress = %s(%s._%sOffset_);%n", getAtOffsetFunction, structure.getName(), offsetConstant);
            writer.format("\t\t\t\tif (nextAddress == 0) {%n", new Object[0]);
            writer.format("\t\t\t\t\t%s_cache = %s.NULL;%n", getter, pointerType);
            writer.format("\t\t\t\t} else {%n", new Object[0]);
            writer.format("\t\t\t\t\t%s_cache = %s;%n", getter, value);
            writer.format("\t\t\t\t}%n", new Object[0]);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t}%n", new Object[0]);
        }
        writer.format("\t\tlong nextAddress = %s(%s._%sOffset_);%n", getAtOffsetFunction, structure.getName(), offsetConstant);
        writer.format("\t\tif (nextAddress == 0) {%n", new Object[0]);
        writer.format("\t\t\treturn %s.NULL;%n", pointerType);
        writer.format("\t\t}%n", new Object[0]);
        writer.format("\t\treturn %s;%n", value);
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeSRPEAMethod(writer, isWide ? "WideSelfRelativePointer" : "SelfRelativePointer", structure, fieldDescriptor);
    }

    private void writeStructurePointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String type2 = fieldDescriptor.getType();
        String targetType = type2.substring(0, type2.indexOf(42));
        String returnType = PointerGenerator.removeTypeTags(targetType) + "Pointer";
        String getter = fieldDescriptor.getName();
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "%s.cast(getPointerAtOffset(%s._%sOffset_))", returnType, structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeFJ9ObjectMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "J9ObjectPointer";
        String getter = fieldDescriptor.getName();
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "getObjectReferenceAtOffset(%s._%sOffset_)", structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "ObjectReferencePointer", structure, fieldDescriptor);
    }

    private void writeFJ9ObjectPointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "ObjectReferencePointer";
        String getter = fieldDescriptor.getName();
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "%s.cast(getPointerAtOffset(%s._%sOffset_))", returnType, structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeJ9ObjectClassMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "J9ClassPointer";
        String getter = fieldDescriptor.getName();
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "getObjectClassAtOffset(%s._%sOffset_)", structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "ObjectClassReferencePointer", structure, fieldDescriptor);
    }

    private void writeJ9ObjectClassPointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "ObjectClassReferencePointer";
        String getter = fieldDescriptor.getName();
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        writer.println("\t\t// j9objectclass_t* method goes here");
        writer.println("\t\treturn null;");
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeJ9ObjectMonitorMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "J9ObjectMonitorPointer";
        String getter = fieldDescriptor.getName();
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "getObjectMonitorAtOffset(%s._%sOffset_)", structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "ObjectMonitorReferencePointer", structure, fieldDescriptor);
    }

    private void writeJ9ObjectMonitorPointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "ObjectMonitorReferencePointer";
        String getter = fieldDescriptor.getName();
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        writer.println("\t\t// j9objectmonitor_t* method goes here");
        writer.println("\t\treturn null;");
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeStructureMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String type2 = fieldDescriptor.getType();
        String returnType = type2.equals("void") ? "VoidPointer" : PointerGenerator.removeTypeTags(type2) + "Pointer";
        String getter = fieldDescriptor.getName();
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        this.writeMethodReturn(writer, getter, "%s.cast(nonNullFieldEA(%s._%sOffset_))", returnType, structure.getName(), this.getOffsetConstant(fieldDescriptor));
        PointerGenerator.writeMethodClose(writer, fieldDescriptor);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeMethodReturn(PrintWriter writer, String getter, String valueFormat, Object ... valueArgs) {
        String value = String.format(valueFormat, valueArgs);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = %s;%n", getter, value);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t}%n", new Object[0]);
        }
        writer.format("\t\treturn %s;%n", value);
    }

    private void writeConstructor(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        String name = structure.getPointerName();
        String structureName = structure.getName();
        writer.println("\t// Do not call this constructor.  Use static method cast instead.");
        writer.format("\tprotected %s(long address) {%n", name);
        writer.println("\t\tsuper(address);");
        writer.println("\t}");
        writer.println();
        writer.format("\tpublic static %s cast(AbstractPointer structure) {%n", name);
        writer.format("\t\treturn cast(structure.getAddress());%n", new Object[0]);
        writer.println("\t}");
        writer.println();
        writer.format("\tpublic static %s cast(UDATA udata) {%n", name);
        writer.format("\t\treturn cast(udata.longValue());%n", new Object[0]);
        writer.println("\t}");
        writer.println();
        writer.format("\tpublic static %s cast(long address) {%n", name);
        writer.format("\t\tif (address == 0) {%n", new Object[0]);
        writer.format("\t\t\treturn NULL;%n", new Object[0]);
        writer.format("\t\t}%n", new Object[0]);
        if (this.cacheClass) {
            writer.format("\t\tif (CACHE_CLASS) {%n", new Object[0]);
            writer.format("\t\t\t%s clazz = checkCache(address);%n", name);
            writer.format("\t\t\tif (null == clazz) {%n", new Object[0]);
            writer.format("\t\t\t\tclazz = new %s(address);%n", name, name);
            writer.format("\t\t\t\tsetCache(address, clazz);%n", new Object[0]);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn clazz;%n", new Object[0]);
            writer.format("\t\t}%n", new Object[0]);
        }
        writer.format("\t\treturn new %s(address);%n", name, name);
        writer.println("\t}");
        writer.println();
        writer.format("\tpublic %s add(long count) {%n", name);
        writer.format("\t\treturn %s.cast(address + (%s.SIZEOF * count));%n", name, structureName);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s add(Scalar count) {%n", name);
        writer.format("\t\treturn add(count.longValue());%n", name);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s addOffset(long offset) {%n", name);
        writer.format("\t\treturn %s.cast(address + offset);%n", name);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s addOffset(Scalar offset) {%n", name);
        writer.format("\t\treturn addOffset(offset.longValue());%n", name);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s sub(long count) {%n", name);
        writer.format("\t\treturn %s.cast(address - (%s.SIZEOF * count));%n", name, structureName);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s sub(Scalar count) {%n", name);
        writer.format("\t\treturn sub(count.longValue());%n", name);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s subOffset(long offset) {%n", name);
        writer.format("\t\treturn %s.cast(address - offset);%n", name);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s subOffset(Scalar offset) {%n", name);
        writer.format("\t\treturn subOffset(offset.longValue());%n", name);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s untag(long mask) {%n", name);
        writer.format("\t\treturn %s.cast(address & ~mask);%n", name);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s untag() {%n", name);
        writer.format("\t\treturn untag(UDATA.SIZEOF - 1);%n", new Object[0]);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tprotected long sizeOfBaseType() {%n", new Object[0]);
        writer.format("\t\treturn %s.SIZEOF;%n", structureName);
        writer.format("\t}%n", new Object[0]);
        writer.println();
    }

    private void writeImports(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        if (structure.getFields().size() > 0) {
            writer.println("import com.ibm.j9ddr.CorruptDataException;");
        }
        String version = this.opts.get("-v");
        writer.println(String.format("import com.ibm.j9ddr.vm%s.pointer.*;", version));
        writer.println(String.format("import com.ibm.j9ddr.vm%s.structure.*;", version));
        writer.println(String.format("import com.ibm.j9ddr.vm%s.types.*;", version));
        if (this.cacheClass) {
            writer.println("import java.util.HashMap;");
        }
    }

    private static void writeBuildFlagImports(PrintWriter writer, boolean useCName) {
        writer.println();
        if (useCName) {
            writer.println("import com.ibm.j9ddr.BytecodeGenerator;");
        }
        writer.println("import java.lang.reflect.Field;");
        writer.println("import java.util.HashSet;");
    }

    private void parseArgs(String[] args) {
        if (args.length == 0 || args.length % 2 != 0) {
            PointerGenerator.printHelp();
            System.exit(1);
        }
        for (int i = 0; i < args.length; i += 2) {
            if (this.opts.containsKey(args[i])) {
                this.opts.put(args[i], args[i + 1]);
                continue;
            }
            System.out.println("Invalid option : " + args[i]);
            PointerGenerator.printHelp();
            System.exit(1);
        }
        for (Map.Entry<String, String> entry : this.opts.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value != null || key.equals("-a") || key.equals("-h") || key.equals("-s")) continue;
            System.err.println("The option " + key + " has not been set.");
            PointerGenerator.printHelp();
            System.exit(1);
        }
        this.generalizeSimpleTypes = "29".equals(this.opts.get("-v"));
    }

    private static void printHelp() {
        System.out.println("Usage: PointerGenerator {option value} ...");
        System.out.println("  required:");
        System.out.println("    -p <package name>         : package name for generated classes, e.g. com.ibm.j9ddr.vm29.pointer.generated");
        System.out.println("    -o <output path>          : where to write class files (path to base of package hierarchy, e.g. C:\\src\\)");
        System.out.println("    -f <superset folder>      : folder containing superset file");
        System.out.println("    -v <vm version>           : VM version for which the pointers are generated, e.g. 29 (corresponds to the stub package name)");
        System.out.println("  optional:");
        System.out.println("    -s <superset file>        : superset file (default: superset.dat)");
        System.out.println("    -h <helper class package> : package for pointer helper files to be generated in from user code");
        System.out.println("    -u <user code support>    : enable user code support (true or false; default: true)");
        System.out.println("    -c <cache properties>     : cache control properties file");
        System.out.println("    -l <legacy mode>          : true or false indicating if legacy DDR is used");
        System.out.println("    -r <path>                 : path to superset file for restricting available constants");
        System.out.println("    -a <path>                 : path to auxiliary field information");
    }

    private File getOutputDir(String option) {
        String outputPath = this.opts.get("-o").replace('\\', '/');
        if (!outputPath.endsWith("/")) {
            outputPath = outputPath + "/";
        }
        outputPath = outputPath + this.opts.get(option).replace('.', '/');
        System.out.println("Writing generated classes to " + outputPath);
        File output = new File(outputPath);
        output.mkdirs();
        return output;
    }

    private static void writeCopyright(PrintWriter writer) {
        writer.println("/*");
        writer.println(" * Copyright IBM Corp. and others 1991");
        writer.println(" *");
        writer.println(" * This program and the accompanying materials are made available under");
        writer.println(" * the terms of the Eclipse Public License 2.0 which accompanies this");
        writer.println(" * distribution and is available at https://www.eclipse.org/legal/epl-2.0/");
        writer.println(" * or the Apache License, Version 2.0 which accompanies this distribution");
        writer.println(" * and is available at https://www.apache.org/licenses/LICENSE-2.0.");
        writer.println(" *");
        writer.println(" * This Source Code may also be made available under the following");
        writer.println(" * Secondary Licenses when the conditions for such availability set");
        writer.println(" * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU");
        writer.println(" * General Public License, version 2 with the GNU Classpath");
        writer.println(" * Exception [1] and GNU General Public License, version 2 with the");
        writer.println(" * OpenJDK Assembly Exception [2].");
        writer.println(" *");
        writer.println(" * [1] https://www.gnu.org/software/classpath/license.html");
        writer.println(" * [2] https://openjdk.org/legal/assembly-exception.html");
        writer.println(" *");
        writer.println(" * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0");
        writer.println(" */");
    }
}

