/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressRange;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.Emulator;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ObjectMap;
import java.io.IOException;
import java.util.logging.Logger;

public final class MutableAddressSpace
extends AddressSpace
implements Emulator.ImageSpace {
    private ObjectMap mutableBlockCache = new ObjectMap();
    private AddressSpace parentSpace;
    protected long lastMutableBlockAddress;
    private byte[] lastMutableBlock;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public MutableAddressSpace(AddressSpace space) {
        super(space.dump, space.asid);
        this.addressMap = space.addressMap;
        this.ranges = space.getAddressRanges();
        this.parentSpace = space;
        this.setIs64bit(space.is64bit());
    }

    @Override
    protected byte[] getBlockFromCacheOrDisk(long address) throws IOException {
        assert ((address & 0xFFFL) == 0L);
        byte[] block = (byte[])this.mutableBlockCache.get(address);
        if (block == null) {
            block = this.parentSpace.getBlock(address);
        }
        this.putBlockInQuickCache(address, block);
        return block;
    }

    private byte[] getMutableBlock(long address) throws IOException {
        byte[] block;
        if ((address = this.roundToPage(address)) == this.lastMutableBlockAddress) {
            block = this.lastMutableBlock;
        } else {
            block = (byte[])this.mutableBlockCache.get(address);
            if (block == null) {
                byte[] tmp = this.parentSpace.getBlock(address);
                block = new byte[4096];
                System.arraycopy(tmp, 0, block, 0, block.length);
                this.mutableBlockCache.put(address, block);
            }
            this.lastMutableBlock = block;
            this.lastMutableBlockAddress = address;
        }
        this.putBlockInQuickCache(address, block);
        return block;
    }

    public void writeBytes(long address, byte[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            this.writeByte(address++, array[i]);
        }
    }

    public void writeWord(long address, long value) throws IOException {
        if (this.is64bit()) {
            this.writeInt(address, (int)(value >>> 32));
            this.writeInt(address + 4L, (int)value);
        } else {
            this.writeInt(address, (int)value);
        }
    }

    @Override
    public void writeByte(long address, int value) throws IOException {
        this.getMutableBlock((long)address)[(int)address & 0xFFF] = (byte)value;
    }

    @Override
    public void writeShort(long address, int value) throws IOException {
        this.writeByte(address, value >> 8);
        this.writeByte(address + 1L, value);
    }

    @Override
    public void writeInt(long address, int value) throws IOException {
        int offset = (int)address & 0xFFF;
        if (offset < 4093) {
            byte[] b = this.getMutableBlock(address);
            b[offset] = (byte)(value >> 24);
            b[offset + 1] = (byte)(value >> 16);
            b[offset + 2] = (byte)(value >> 8);
            b[offset + 3] = (byte)value;
        } else {
            this.writeByte(address, value >>> 24);
            this.writeByte(address + 1L, value >>> 16);
            this.writeByte(address + 2L, value >>> 8);
            this.writeByte(address + 3L, value);
        }
    }

    @Override
    public void writeLong(long address, long value) throws IOException {
        this.writeInt(address, (int)(value >>> 32));
        this.writeInt(address + 4L, (int)value);
    }

    @Override
    public long malloc(int size) throws IOException {
        AddressRange[] unused = this.getUnusedAddressRanges();
        size += 8;
        int roundSize = (size += 4) + 4096 - 1 & 0xFFFFF000;
        int count = roundSize / 4096;
        assert (unused[0].getLength() > 16L);
        for (int i = 0; i < unused.length; ++i) {
            long startAddress = unused[i].getStartAddress();
            if ((long)size >= unused[i].getLength() || this.mutableBlockCache.get(startAddress) != null) continue;
            for (int j = 0; j < count; ++j) {
                byte[] block = new byte[4096];
                this.mutableBlockCache.put(startAddress + (long)(j * 4096), block);
            }
            this.writeInt(startAddress, (int)startAddress);
            this.writeInt(startAddress + 4L, size);
            log.fine("allocated 0x" + MutableAddressSpace.hex(size - 12) + " bytes at 0x" + MutableAddressSpace.hex(startAddress + 8L));
            return startAddress + 8L;
        }
        throw new IOException("could not malloc " + (size - 12));
    }

    public long rmalloc(int size) throws IOException {
        AddressRange[] unused = this.getUnusedAddressRanges();
        size += 8;
        int roundSize = (size += 4) + 4096 - 1 & 0xFFFFF000;
        int count = roundSize / 4096;
        for (int i = unused.length - count; i >= 0; --i) {
            long startAddress = unused[i].getStartAddress();
            if ((long)size >= unused[i].getLength() || this.mutableBlockCache.get(startAddress) != null) continue;
            for (int j = 0; j < count; ++j) {
                byte[] block = new byte[4096];
                this.mutableBlockCache.put(startAddress + (long)(j * 4096), block);
            }
            this.writeInt(startAddress, (int)startAddress);
            this.writeInt(startAddress + 4L, size);
            log.fine("allocated 0x" + MutableAddressSpace.hex(size - 12) + " bytes at 0x" + MutableAddressSpace.hex(startAddress + 8L));
            return startAddress + 8L;
        }
        throw new IOException("could not malloc " + (size - 12));
    }

    public void free(long ptr) throws IOException {
        if ((long)this.readInt(ptr -= 8L) != ptr) {
            return;
        }
        int size = this.readInt(ptr + 4L);
        assert (size >= 0 && size < 0x10000000);
        int roundSize = size + 4096 - 1 & 0xFFFFF000;
        int count = roundSize / 4096;
        for (int j = 0; j < count; ++j) {
            Object block = this.mutableBlockCache.remove(ptr + (long)(j * 4096));
            assert (block != null);
        }
    }

    public void allocPage(long address) throws IOException {
        if (address % 4096L != 0L) {
            throw new IOException("address " + MutableAddressSpace.hex(address) + " not on page boundary");
        }
        if (this.isValidAddress(address) || this.mutableBlockCache.get(address) != null) {
            throw new IOException("address " + MutableAddressSpace.hex(address) + " already in use");
        }
        this.mutableBlockCache.put(address, new byte[4096]);
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }
}

