/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class EnvironmentUtils {
    public static Properties readEnvironment(IProcess proc, long environPointer) throws MemoryFault {
        Properties env = new Properties();
        long slotCursor = environPointer;
        long stringPtr = proc.getPointerAt(slotCursor);
        while (0L != stringPtr) {
            long ptr = stringPtr;
            while (proc.getByteAt(ptr) != 0) {
                ++ptr;
            }
            byte[] byteBuffer = new byte[(int)(ptr - stringPtr)];
            proc.getBytesAt(stringPtr, byteBuffer);
            String pair = null;
            try {
                pair = new String(byteBuffer, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            int equal = pair.indexOf(61);
            if (equal != -1) {
                String variable = pair.substring(0, equal);
                String value = pair.substring(equal + 1, pair.length());
                env.put(variable, value);
            }
            stringPtr = proc.getPointerAt(slotCursor += (long)proc.bytesPerPointer());
        }
        return env;
    }

    public static Properties readEnvironmentStrings(IProcess proc, long environmentPtr) throws MemoryFault {
        Properties env = new Properties();
        if (environmentPtr == 0L) {
            return env;
        }
        long stringPtr = environmentPtr;
        while (proc.getByteAt(stringPtr) != 0) {
            long ptr = stringPtr;
            while (proc.getByteAt(ptr) != 0) {
                ++ptr;
            }
            byte[] byteBuffer = new byte[(int)(ptr - stringPtr)];
            proc.getBytesAt(stringPtr, byteBuffer);
            String pair = null;
            try {
                pair = new String(byteBuffer, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            int equal = pair.indexOf(61);
            if (equal != -1) {
                String variable = pair.substring(0, equal);
                String value = pair.substring(equal + 1, pair.length());
                env.put(variable, value);
            }
            stringPtr = ptr + 1L;
        }
        return env;
    }
}

