/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.JCEPlusKeyRep;
import com.ibm.crypto.plus.provider.JCEPlusKeyRep$Type;
import com.ibm.crypto.plus.provider.icc.RSAKey;
import com.ibm.crypto.plus.provider.v;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class RSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -4315189411360884318L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger modulus;
    private BigInteger privateExponent;
    private BigInteger publicExponent = BigInteger.ZERO;
    private BigInteger primeP = BigInteger.ZERO;
    private BigInteger primeQ = BigInteger.ZERO;
    private BigInteger primeExponentP = BigInteger.ZERO;
    private BigInteger primeExponentQ = BigInteger.ZERO;
    private BigInteger crtCoefficient = BigInteger.ZERO;
    private transient boolean destroyed = false;
    private transient RSAKey rsaKey = null;
    private AlgorithmParameterSpec keyParams;
    private static final String[] z;

    public RSAPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.rsaPrivateKey(this.algid, iBMJCEPlusProvider, bigInteger, bigInteger2);
    }

    public RSAPrivateKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.rsaPrivateKey(this.algid, iBMJCEPlusProvider, bigInteger, bigInteger2);
    }

    public void rsaPrivateKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        block8: {
            this.provider = iBMJCEPlusProvider;
            this.modulus = bigInteger;
            this.privateExponent = bigInteger2;
            this.keyParams = RSAUtil.getParamSpec((AlgorithmId)algorithmId);
            if (this.modulus != null && this.privateExponent != null) break block8;
            throw new InvalidKeyException(z[5]);
        }
        v.a(this.provider, this.modulus.bitLength(), null);
        try {
            this.key = RSAPrivateKey.a(bigInteger, bigInteger2);
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[4] + iOException.getMessage());
        }
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[3]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[9] + iOException.getMessage());
        }
        v.a(iBMJCEPlusProvider, this.modulus.bitLength(), null);
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[10]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateKey(IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.algid = new AlgIdRSA();
        this.rsaPrivateKey(this.algid, iBMJCEPlusProvider, rSAKey);
    }

    public RSAPrivateKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.rsaPrivateKey(algorithmId, iBMJCEPlusProvider, rSAKey);
    }

    public void rsaPrivateKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = algorithmId;
            this.key = rSAKey.getPrivateKeyBytes();
            this.rsaKey = rSAKey;
            this.keyParams = RSAUtil.getParamSpec((AlgorithmId)algorithmId);
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[1]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public static RSAPrivateKey newKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(iBMJCEPlusProvider, byArray);
        return rSAPrivateKey;
    }

    public static RSAPrivateKey newKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(iBMJCEPlusProvider, bigInteger, bigInteger2);
        return rSAPrivateKey;
    }

    @Override
    public String getAlgorithm() {
        this.b();
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        this.b();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.b();
        return super.getEncoded();
    }

    RSAKey a() {
        return this.rsaKey;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            int n2 = derValue.getData().getInteger().intValue();
            if (n2 != 0) {
                throw new IOException(z[7]);
            }
            this.modulus = derValue.getData().getPositiveBigInteger();
            this.publicExponent = derValue.getData().getPositiveBigInteger();
            this.privateExponent = derValue.getData().getPositiveBigInteger();
            this.primeP = derValue.getData().getPositiveBigInteger();
            this.primeQ = derValue.getData().getPositiveBigInteger();
            this.primeExponentP = derValue.getData().getPositiveBigInteger();
            this.primeExponentQ = derValue.getData().getPositiveBigInteger();
            this.crtCoefficient = derValue.getData().getPositiveBigInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[8]);
            }
        }
        catch (IOException iOException) {
            throw new IOException(z[6], iOException);
        }
    }

    private static byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger2.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    @Override
    public BigInteger getPrivateExponent() {
        this.b();
        return this.privateExponent;
    }

    @Override
    public BigInteger getModulus() {
        this.b();
        return this.modulus;
    }

    private Object writeReplace() throws ObjectStreamException {
        this.b();
        return new JCEPlusKeyRep(JCEPlusKeyRep$Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded(), this.provider.getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException(z[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.rsaKey = null;
            this.modulus = null;
            this.publicExponent = null;
            this.privateExponent = null;
            this.primeP = null;
            this.primeQ = null;
            this.primeExponentP = null;
            this.primeExponentQ = null;
            this.crtCoefficient = null;
            this.keyParams = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void b() {
        if (this.destroyed) {
            throw new IllegalStateException(z[2]);
        }
    }

    protected RSAKey c() {
        return this.rsaKey;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[11];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "9?!1\u007f\u0002\u001a\u0001\u0015h \t\u0019Af\u000e\u0015\u0013Al\u0019\t@\u000fb\u001fL\u0004\b\u007f\u000e\u000f\u0014\rtK\b\u0005\u0012h\u0019\u0005\u0001\rd\u0011\r\u0002\rh";
        int n3 = -1;
        block18: while (true) {
            char[] cArray;
            block22: {
                int n4;
                int n5;
                block21: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block21;
                    n5 = n5;
                    if (n5 <= n4) break block22;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 107;
                            break;
                        }
                        case 1: {
                            n6 = 108;
                            break;
                        }
                        case 2: {
                            n6 = 96;
                            break;
                        }
                        case 3: {
                            n6 = 97;
                            break;
                        }
                        default: {
                            n6 = 13;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "-\r\t\rh\u000fL\u0014\u000e-\b\u001e\u0005\u0000y\u000eL22LK\u001c\u0012\b{\n\u0018\u0005Af\u000e\u0015";
                    n3 = 0;
                    continue block18;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "?\u0004\t\u0012-\u0000\t\u0019Ad\u0018L\u000e\u000e-\u0007\u0003\u000e\u0006h\u0019L\u0016\u0000a\u0002\b";
                    n3 = 1;
                    continue block18;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "-\r\t\rh\u000fL\u0014\u000e-\b\u001e\u0005\u0000y\u000eL22LK\u001c\u0012\b{\n\u0018\u0005Af\u000e\u0015";
                    n3 = 2;
                    continue block18;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\b\u0003\u0015\riK\u0002\u000f\u0015-/)2Ah\u0005\u000f\u000f\u0005hQL";
                    n3 = 3;
                    continue block18;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "9?!AF\u000e\u0015@\u0011l\u0019\r\r\u0004y\u000e\u001e\u0013An\n\u0002\u000e\u000eyK\u000e\u0005Ac\u001e\u0000\f";
                    n3 = 4;
                    continue block18;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\"\u0002\u0016\u0000a\u0002\b@3^*L\u0010\u0013d\u001d\r\u0014\u0004-\u0000\t\u0019";
                    n3 = 5;
                    continue block18;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "=\t\u0012\u0012d\u0004\u0002@\fx\u0018\u0018@\u0003hK\\";
                    n3 = 6;
                    continue block18;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\"\u0002\u0016\u0000a\u0002\b@3^*<\u0012\b{\n\u0018\u0005*h\u0012L\u0005\u000fn\u0004\b\t\u000fjGL\u0004\u0000y\nL\u000f\u0017h\u0019\u001e\u0015\u000f";
                    n3 = 7;
                    continue block18;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\b\u0003\u0015\riK\u0002\u000f\u0015-/)2Ah\u0005\u000f\u000f\u0005hQL";
                    n3 = 8;
                    continue block18;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "-\r\t\rh\u000fL\u0014\u000e-\b\u001e\u0005\u0000y\u000eL22LK\u001c\u0012\b{\n\u0018\u0005Af\u000e\u0015";
                    n3 = 9;
                    continue block18;
                }
                case 9: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

