/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.JCEPlusKeyRep;
import com.ibm.crypto.plus.provider.JCEPlusKeyRep$Type;
import com.ibm.crypto.plus.provider.icc.RSAKey;
import com.ibm.crypto.plus.provider.v;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class RSAPrivateCrtKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateCrtKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -4315189411360884318L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger primeP;
    private BigInteger primeQ;
    private BigInteger primeExponentP;
    private BigInteger primeExponentQ;
    private BigInteger crtCoefficient;
    private AlgorithmParameterSpec keyParams;
    private transient boolean destroyed = false;
    private transient RSAKey rsaKey = null;
    private static final String[] z;

    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.rsaPrivateCrtKey(this.algid, iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    public RSAPrivateCrtKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.rsaPrivateCrtKey(algorithmId, iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    public void rsaPrivateCrtKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        block21: {
            block20: {
                this.algid = algorithmId;
                this.provider = iBMJCEPlusProvider;
                this.modulus = bigInteger;
                this.publicExponent = bigInteger2;
                this.privateExponent = bigInteger3;
                this.primeP = bigInteger4;
                this.primeQ = bigInteger5;
                this.primeExponentP = bigInteger6;
                this.primeExponentQ = bigInteger7;
                this.crtCoefficient = bigInteger8;
                this.keyParams = RSAUtil.getParamSpec((AlgorithmId)this.algid);
                if (this.modulus == null || this.publicExponent == null) break block20;
                if (this.privateExponent == null) break block20;
                if (this.primeP == null) break block20;
                if (this.primeQ == null) break block20;
                if (this.primeExponentP == null) break block20;
                if (this.primeExponentQ == null) break block20;
                if (this.crtCoefficient != null) break block21;
            }
            throw new InvalidKeyException(z[0]);
        }
        v.a(this.provider, this.modulus.bitLength(), this.publicExponent);
        try {
            this.key = RSAPrivateCrtKey.a(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[2] + iOException.getMessage());
        }
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[1]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[9] + iOException.getMessage());
        }
        v.a(iBMJCEPlusProvider, this.modulus.bitLength(), this.publicExponent);
        try {
            this.rsaKey = RSAKey.createPrivateKey(iBMJCEPlusProvider.a(), this.key);
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[10]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    public RSAPrivateCrtKey(IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.algid = new AlgIdRSA();
        this.rsaPrivateCrtKey(this.algid, iBMJCEPlusProvider, rSAKey);
    }

    public void rsaPrivateCrtKey(AlgorithmId algorithmId, IBMJCEPlusProvider iBMJCEPlusProvider, RSAKey rSAKey) throws Exception {
        this.provider = iBMJCEPlusProvider;
        try {
            this.algid = algorithmId;
            this.key = rSAKey.getPrivateKeyBytes();
            this.rsaKey = rSAKey;
            this.keyParams = RSAUtil.getParamSpec((AlgorithmId)this.algid);
            this.parseKeyBits();
        }
        catch (Exception exception) {
            InvalidKeyException invalidKeyException = new InvalidKeyException(z[8]);
            iBMJCEPlusProvider.a(invalidKeyException, (Throwable)exception);
            throw invalidKeyException;
        }
    }

    @Override
    public String getAlgorithm() {
        this.b();
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        this.b();
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        this.b();
        return super.getEncoded();
    }

    RSAKey a() {
        return this.rsaKey;
    }

    protected void parseKeyBits() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            int n2 = derValue.getData().getInteger().intValue();
            if (n2 != 0) {
                throw new IOException(z[6]);
            }
            this.modulus = derValue.getData().getPositiveBigInteger();
            this.publicExponent = derValue.getData().getPositiveBigInteger();
            this.privateExponent = derValue.getData().getPositiveBigInteger();
            this.primeP = derValue.getData().getPositiveBigInteger();
            this.primeQ = derValue.getData().getPositiveBigInteger();
            this.primeExponentP = derValue.getData().getPositiveBigInteger();
            this.primeExponentQ = derValue.getData().getPositiveBigInteger();
            this.crtCoefficient = derValue.getData().getPositiveBigInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[5]);
            }
        }
        catch (IOException iOException) {
            throw new IOException(z[4], iOException);
        }
    }

    private static byte[] a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray()), new DerValue(2, bigInteger3.toByteArray()), new DerValue(2, bigInteger4.toByteArray()), new DerValue(2, bigInteger5.toByteArray()), new DerValue(2, bigInteger6.toByteArray()), new DerValue(2, bigInteger7.toByteArray()), new DerValue(2, bigInteger8.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    @Override
    public BigInteger getPrivateExponent() {
        this.b();
        return this.privateExponent;
    }

    @Override
    public BigInteger getModulus() {
        this.b();
        return this.modulus;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        this.b();
        return this.crtCoefficient;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        this.b();
        return this.primeExponentP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        this.b();
        return this.primeExponentQ;
    }

    @Override
    public BigInteger getPrimeP() {
        this.b();
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        this.b();
        return this.primeQ;
    }

    @Override
    public BigInteger getPublicExponent() {
        this.b();
        return this.publicExponent;
    }

    private Object writeReplace() throws ObjectStreamException {
        this.b();
        return new JCEPlusKeyRep(JCEPlusKeyRep$Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded(), this.provider.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.rsaKey = null;
            this.modulus = null;
            this.publicExponent = null;
            this.privateExponent = null;
            this.primeP = null;
            this.primeQ = null;
            this.primeExponentP = null;
            this.primeExponentQ = null;
            this.crtCoefficient = null;
            this.keyParams = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void b() {
        if (this.destroyed) {
            throw new IllegalStateException(z[7]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException(z[3]);
    }

    protected RSAKey c() {
        return this.rsaKey;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[11];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "b`t|=UJ\u0015,\u0017BRX9\u0002UAF|\u0015Q][3\u0002\u0010QP|\u0018E_Y";
        int n3 = -1;
        block18: while (true) {
            char[] cArray;
            block22: {
                int n4;
                int n5;
                block21: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block21;
                    n5 = n5;
                    if (n5 <= n4) break block22;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 48;
                            break;
                        }
                        case 1: {
                            n6 = 51;
                            break;
                        }
                        case 2: {
                            n6 = 53;
                            break;
                        }
                        case 3: {
                            n6 = 92;
                            break;
                        }
                        default: {
                            n6 = 118;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "vR\\0\u0013T\u0013A3VSAP=\u0002U\u0013g\u000f7\u0010CG5\u0000QGP|\u001dUJ";
                    n3 = 0;
                    continue block18;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "S\\@0\u0012\u0010]Z(Vtvg|\u0013^PZ8\u0013\n\u0013";
                    n3 = 1;
                    continue block18;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "b`t\f\u0004YET(\u0013sAA\u0017\u0013I\u0013^9\u000fC\u0013T.\u0013\u0010]Z(VTZG9\u0015D_L|\u0012U@P.\u001fQ_\\&\u0017R_P";
                    n3 = 2;
                    continue block18;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "y]C=\u001aYW\u0015\u000e%q\u0013E.\u001fFRA9V[VL";
                    n3 = 3;
                    continue block18;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "y]C=\u001aYW\u0015\u000e%qcG5\u0000QGP\u001f\u0004DxP%VU]V3\u0012Y]RpVTRA=V_EP.\u0004E]";
                    n3 = 4;
                    continue block18;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "fVG/\u001f_]\u00151\u0003CG\u0015>\u0013\u0010\u0003";
                    n3 = 5;
                    continue block18;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "d[\\/V[VL|\u001fC\u0013[3V\\\\[;\u0013B\u0013C=\u001aYW";
                    n3 = 6;
                    continue block18;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "vR\\0\u0013T\u0013A3VSAP=\u0002U\u0013g\u000f7\u0010CG5\u0000QGP|\u001dUJ";
                    n3 = 7;
                    continue block18;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "S\\@0\u0012\u0010]Z(Vtvg|\u0013^PZ8\u0013\n\u0013";
                    n3 = 8;
                    continue block18;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "vR\\0\u0013T\u0013A3VSAP=\u0002U\u0013g\u000f7\u0010CG5\u0000QGP|\u001dUJ";
                    n3 = 9;
                    continue block18;
                }
                case 9: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

