/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.util.Locale;

public final class DNSName
implements GeneralNameInterface {
    private String name;
    private static final String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String digits = "0123456789";
    private static final String alphaDigits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.DNSName";

    public DNSName(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DNSName", derValue);
        }
        this.name = derValue.getIA5String();
        if (debug != null) {
            debug.exit(16384L, className, "DNSName");
        }
    }

    public DNSName(String name) throws IOException {
        this(name, false);
    }

    public DNSName(String name, boolean allowDigit) throws IOException {
        this(name, allowDigit, false);
    }

    public DNSName(String name, boolean allowDigit, boolean allowWildcard) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DNSName", name);
        }
        if (name == null || name.length() == 0) {
            throw new IOException("DNSName must not be null");
        }
        if (name.contains(" ")) {
            throw new IOException("DNSNames or NameConstraints with blank components are not permitted");
        }
        if (name.startsWith(".") || name.endsWith(".")) {
            throw new IOException("DNSNames or NameConstraints may not begin or end with a .");
        }
        int startIndex = 0;
        while (startIndex < name.length()) {
            int endIndex = name.indexOf(46, startIndex);
            if (endIndex < 0) {
                endIndex = name.length();
            }
            if (endIndex - startIndex < 1) {
                throw new IOException("DNSName SubjectAltNames with empty components are not permitted");
            }
            if (allowWildcard) {
                if (alphaDigits.indexOf(name.charAt(startIndex)) < 0 && (name.length() < 3 || name.indexOf(42, 0) != 0 || name.charAt(startIndex + 1) != '.' || alphaDigits.indexOf(name.charAt(startIndex + 2)) < 0)) {
                    throw new IOException("DNSName components must begin with a letter, digit, or the first component can have only a wildcard character *");
                }
            } else if (alphaDigits.indexOf(name.charAt(startIndex)) < 0) {
                throw new IOException("DNSName components must begin with a letter or digit");
            }
            if (!allowDigit && alpha.indexOf(name.charAt(startIndex)) < 0) {
                throw new IOException("DNSName components must begin with a letter");
            }
            for (int nonStartIndex = startIndex + 1; nonStartIndex < endIndex; ++nonStartIndex) {
                char x = name.charAt(nonStartIndex);
                if (alphaDigits.indexOf(x) >= 0 || x == '-') continue;
                throw new IOException("DNSName components must consist of letters, digits, and hyphens");
            }
            startIndex = endIndex + 1;
        }
        this.name = name;
        if (debug != null) {
            debug.exit(16384L, className, "DNSName");
        }
    }

    @Override
    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 2);
        }
        return 2;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        out.putIA5String(this.name);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "DNSName: " + this.name);
        }
        return "DNSName: " + this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DNSName)) {
            return false;
        }
        DNSName other = (DNSName)obj;
        return this.name.equalsIgnoreCase(other.name);
    }

    public int hashCode() {
        return this.name.toUpperCase(Locale.ENGLISH).hashCode();
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int ndx;
        int inNdx;
        String inName;
        if (inputName == null) {
            return -1;
        }
        switch (inputName.getType()) {
            case 2: {
                inName = ((DNSName)inputName).getName();
                break;
            }
            case 4: {
                try {
                    inName = ((X500Name)inputName).getCommonName();
                    if (inName == null) {
                        return -1;
                    }
                    break;
                }
                catch (IOException ioe) {
                    return -1;
                }
            }
            default: {
                return -1;
            }
        }
        inName = inName.toLowerCase(Locale.ENGLISH);
        String thisName = this.name.toLowerCase(Locale.ENGLISH);
        int constraintType = inName.equals(thisName) ? 0 : (thisName.endsWith(inName) ? (thisName.charAt((inNdx = thisName.lastIndexOf(inName)) - 1) == '.' ? 2 : 3) : (inName.endsWith(thisName) ? (inName.charAt((ndx = inName.lastIndexOf(thisName)) - 1) == '.' ? 1 : 3) : 3));
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        int sum = 1;
        int i = this.name.indexOf(46);
        while (i >= 0) {
            ++sum;
            i = this.name.indexOf(46, i + 1);
        }
        return sum;
    }
}

