/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;

public final class CertificateVersion
implements CertAttrSet<String> {
    public static final int V1 = 0;
    public static final int V2 = 1;
    public static final int V3 = 2;
    public static final String IDENT = "x509.info.version";
    public static final String NAME = "version";
    public static final String VERSION = "number";
    private int version = 0;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateVersion";

    private int getVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "getVersion");
            debug.exit(8192L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    private void construct(DerValue derVal) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "construct", derVal);
        }
        if (derVal.isConstructed() && derVal.isContextSpecific()) {
            derVal = derVal.getData().getDerValue();
            this.version = derVal.getInteger().intValue();
            if (derVal.getData().available() != 0) {
                if (debug != null) {
                    debug.text(8192L, className, "construct", "X.509 version, bad format");
                }
                throw new IOException("X.509 version, bad format");
            }
        }
        if (debug != null) {
            debug.exit(8192L, className, "construct");
        }
    }

    public CertificateVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateVersion");
            debug.exit(16384L, className, "CertificateVersion");
        }
        this.version = 0;
    }

    public CertificateVersion(int version) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateVersion", new Integer(version));
        }
        if (version != 0 && version != 1 && version != 2) {
            if (debug != null) {
                debug.text(16384L, className, "CertificateVersion", "X.509 Certificate version " + version + " not supported.\n");
            }
            throw new IOException("X.509 Certificate version " + version + " not supported.\n");
        }
        this.version = version;
        if (debug != null) {
            debug.exit(16384L, className, "CertificateVersion");
        }
    }

    public CertificateVersion(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateVersion", in);
        }
        this.version = 0;
        DerValue derVal = in.getDerValue();
        this.construct(derVal);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateVersion");
        }
    }

    public CertificateVersion(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateVersion", in);
        }
        this.version = 0;
        DerValue derVal = new DerValue(in);
        this.construct(derVal);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateVersion");
        }
    }

    public CertificateVersion(DerValue val) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateVersion", val);
        }
        this.version = 0;
        this.construct(val);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateVersion");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "Version: V" + (this.version + 1));
        }
        return "Version: V" + (this.version + 1);
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.version == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "encode_1");
            }
            return;
        }
        DerOutputStream tmp = new DerOutputStream();
        tmp.putInteger(BigInteger.valueOf(this.version));
        DerOutputStream seq = new DerOutputStream();
        seq.write(DerValue.createTag((byte)-128, true, (byte)0), tmp);
        out.write(seq.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode_2");
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!(obj instanceof Integer)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Integer.");
            }
            throw new IOException("Attribute must be of type Integer.");
        }
        if (!name.equalsIgnoreCase(VERSION)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet: CertificateVersion.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
        }
        this.version = (Integer)obj;
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Integer get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(VERSION)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get", new Integer(this.getVersion()));
            }
            return new Integer(this.getVersion());
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet: CertificateVersion.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(VERSION)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet: CertificateVersion.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
        }
        this.version = 0;
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(VERSION);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public int compare(int vers) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "compare", new Integer(vers));
            debug.exit(16384L, (Object)className, "compare", this.version - vers);
        }
        return this.version - vers;
    }
}

