/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.Debug;
import com.ibm.security.x509.X509CertImpl;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class AnchorCertificates {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static final String HASH = "SHA-256";
    private static Set<String> certs = Collections.emptySet();
    private static Set<X500Principal> certIssuers = Collections.emptySet();

    public static boolean contains(X509Certificate cert) {
        String key = X509CertImpl.getFingerprint(HASH, cert);
        boolean result = certs.contains(key);
        if (result && debug != null) {
            debug.println("AnchorCertificate.contains: matched " + cert.getSubjectDN());
        }
        return result;
    }

    public static boolean issuerOf(X509Certificate cert) {
        return certIssuers.contains(cert.getIssuerX500Principal());
    }

    private AnchorCertificates() {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                block15: {
                    File f = new File(System.getProperty("java.home"), "lib/security/cacerts");
                    try {
                        KeyStore cacerts = KeyStore.getInstance("JKS");
                        try (FileInputStream fis = new FileInputStream(f);){
                            cacerts.load(fis, null);
                            certs = new HashSet();
                            certIssuers = new HashSet();
                            Enumeration<String> list = cacerts.aliases();
                            while (list.hasMoreElements()) {
                                String alias = list.nextElement();
                                if (!alias.contains(" [jdk")) continue;
                                X509Certificate cert = (X509Certificate)cacerts.getCertificate(alias);
                                certs.add(X509CertImpl.getFingerprint(AnchorCertificates.HASH, cert));
                                certIssuers.add(cert.getSubjectX500Principal());
                            }
                        }
                    }
                    catch (Exception e) {
                        if (debug == null) break block15;
                        debug.println("Error parsing cacerts");
                        e.printStackTrace();
                    }
                }
                return null;
            }
        });
    }
}

