/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassAbstractHelper;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassURLHelper;
import com.ibm.oti.util.Msg;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class SharedClassURLHelperImpl
extends SharedClassAbstractHelper
implements SharedClassURLHelper {
    private boolean minimizeUpdateChecks;
    private Set<String> jarFileNameCache = null;
    public static final boolean MINIMIZE_ENABLED = true;

    SharedClassURLHelperImpl(ClassLoader loader, int id, boolean canFind, boolean canStore) {
        this.initialize(loader, id, canFind, canStore);
        this.initializeShareableClassloader(loader);
    }

    private static native void init();

    private boolean newJarFileCheck(URL convertedJarPath) {
        String protocol = convertedJarPath.getProtocol();
        String jarFile = convertedJarPath.getFile();
        boolean isJarType = false;
        if (protocol.equalsIgnoreCase("jar")) {
            isJarType = true;
        } else if (protocol.equalsIgnoreCase("file") && (jarFile.endsWith(".jar") || jarFile.endsWith(".zip") || jarFile.contains("!/") || jarFile.contains("!\\"))) {
            isJarType = true;
        }
        if (null == this.jarFileNameCache) {
            this.jarFileNameCache = ConcurrentHashMap.newKeySet();
        }
        if (isJarType) {
            return this.jarFileNameCache.add(jarFile);
        }
        return false;
    }

    private native boolean findSharedClassImpl3(int var1, String var2, String var3, ClassLoader var4, URL var5, boolean var6, boolean var7, byte[] var8, boolean var9, boolean var10);

    private native boolean storeSharedClassImpl3(int var1, String var2, ClassLoader var3, URL var4, Class<?> var5, boolean var6, boolean var7, byte[] var8);

    @Override
    public boolean setMinimizeUpdateChecks() {
        this.minimizeUpdateChecks = true;
        return true;
    }

    @Override
    public byte[] findSharedClass(URL path, String className) {
        return this.findSharedClass(null, path, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] findSharedClass(String partition, URL path, String className) {
        URL convertedPath;
        boolean doStore;
        boolean doFind;
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            this.printVerboseInfo(Msg.getString("K059f"));
            return null;
        }
        if (!this.canFind) {
            return null;
        }
        if (path == null) {
            this.printVerboseError(Msg.getString("K05b3"));
            return null;
        }
        if (className == null) {
            this.printVerboseError(Msg.getString("K05a1"));
            return null;
        }
        SharedClassFilter theFilter = this.getSharingFilter();
        if (theFilter != null) {
            SharedClassURLHelperImpl sharedClassURLHelperImpl = this;
            synchronized (sharedClassURLHelperImpl) {
                doFind = theFilter.acceptFind(className);
                doStore = nativeFlags[0] == 0 ? theFilter.acceptStore(className) : true;
            }
        } else {
            doFind = true;
            doStore = true;
        }
        if (!this.validateURL(convertedPath = this.convertJarURL(path), false)) {
            return null;
        }
        byte[] romClassCookie = new byte[this.ROMCLASS_COOKIE_SIZE];
        boolean newJarFile = this.minimizeUpdateChecks ? false : this.newJarFileCheck(convertedPath);
        boolean found = this.findSharedClassImpl3(this.id, partition, className, loader, convertedPath, doFind, doStore, romClassCookie, newJarFile, this.minimizeUpdateChecks);
        if (!found) {
            return null;
        }
        return romClassCookie;
    }

    @Override
    public boolean storeSharedClass(URL path, Class<?> clazz) {
        return this.storeSharedClass(null, path, clazz);
    }

    @Override
    public boolean storeSharedClass(String partition, URL path, Class<?> clazz) {
        if (!this.canStore) {
            return false;
        }
        if (path == null) {
            this.printVerboseError(Msg.getString("K05b4"));
            return false;
        }
        if (clazz == null) {
            this.printVerboseError(Msg.getString("K05a3"));
            return false;
        }
        URL convertedPath = this.convertJarURL(path);
        if (!this.validateURL(convertedPath, false)) {
            return false;
        }
        ClassLoader actualLoader = this.getClassLoader();
        if (!this.validateClassLoader(actualLoader, clazz)) {
            return false;
        }
        boolean newJarFile = this.minimizeUpdateChecks ? false : this.newJarFileCheck(convertedPath);
        return this.storeSharedClassImpl3(this.id, partition, actualLoader, convertedPath, clazz, newJarFile, this.minimizeUpdateChecks, nativeFlags);
    }

    @Override
    String getHelperType() {
        return "SharedClassURLHelper";
    }

    static {
        SharedClassURLHelperImpl.init();
    }
}

