/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.types.IntType;
import java.io.IOException;
import java.util.LinkedList;

public class ArithmeticInstruction
extends BinaryPrimopInstruction {
    protected int m_operation;

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_operation = readObjectFileHelper.readInt();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInt(this.m_operation);
    }

    public ArithmeticInstruction() {
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        this.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type = this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (IntType.s_intType.equals(this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList).resolveType(typeEnvironment)) && IntType.s_intType.equals(type.resolveType(typeEnvironment))) {
            return this.setCachedType(IntType.s_intType);
        }
        return this.setCachedType(DoubleType.s_doubleType);
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (IntType.s_intType.equals(this.m_operand1.getType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment)) && IntType.s_intType.equals(this.m_operand2.getType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment))) {
            return IntType.s_intType;
        }
        return DoubleType.s_doubleType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new ArithmeticInstruction(this.m_operation, this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
    }

    public ArithmeticInstruction(int n, Instruction instruction, Instruction instruction2) {
        super(instruction, instruction2);
        this.m_operation = n;
    }

    public int getOperation() {
        return this.m_operation;
    }

    public String getOperationAsString() {
        String string;
        switch (this.m_operation) {
            case 4: {
                string = "+";
                break;
            }
            case 5: {
                string = "-";
                break;
            }
            case 30: {
                string = "*";
                break;
            }
            case 31: {
                string = "/";
                break;
            }
            case 33: {
                string = "%";
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return string;
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        String string2;
        String string3;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string4 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        Type type = codeGenerationTracker.resolveType(this.m_operand1);
        Type type2 = codeGenerationTracker.resolveType(this.m_operand2);
        if (!(type instanceof INumericalType) || !(type2 instanceof INumericalType)) {
            string3 = CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker);
            string2 = CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker);
        } else {
            string3 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
            string2 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
        }
        String string5 = this.getOperationAsString();
        dataFlowCodeGenerationHelper.appendAssignment(string4, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string3 + " " + string5 + " " + string2, codeGenerationTracker);
        return string4;
    }

    public int getOperationAsXylemOpcode() {
        int n;
        switch (this.m_operation) {
            case 4: {
                n = 0;
                break;
            }
            case 5: {
                n = 1;
                break;
            }
            case 30: {
                n = 2;
                break;
            }
            case 31: {
                n = 3;
                break;
            }
            case 33: {
                n = 4;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return n;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        Type type = codeGenerationTracker.resolveType(this.m_operand1);
        Type type2 = codeGenerationTracker.resolveType(this.m_operand2);
        int n = this.getOperationAsXylemOpcode();
        if (IntType.s_intType.equals(type) && IntType.s_intType.equals(type2)) {
            codeGenerationTracker.generateConventionally(this.m_operand1, bCELCodeGenerationHelper, null, instructionListBuilder);
            codeGenerationTracker.generateConventionally(this.m_operand2, bCELCodeGenerationHelper, null, instructionListBuilder);
            IntType.s_intType.generateCodeForOperation(instructionListBuilder, n);
        } else {
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            DoubleType.s_doubleType.generateCodeForOperation(instructionListBuilder, n);
        }
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        BindingEnvironment bindingEnvironment = this.evaluateBindingEnvironment(function);
        Type type = this.m_operand1.evaluateType(function);
        Type type2 = this.m_operand2.evaluateType(function);
        Object object = this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false);
        Object object2 = this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false);
        if (!(type instanceof INumericalType && type2 instanceof INumericalType && type.equals(type2, function.getTypeEnvironment()))) {
            object = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, DoubleType.s_doubleType, function, bindingEnvironment, iDebuggerInterceptor);
            object2 = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, DoubleType.s_doubleType, function, bindingEnvironment, iDebuggerInterceptor);
            type = DoubleType.s_doubleType;
        }
        int n = this.getOperationAsXylemOpcode();
        Object object3 = ((INumericalType)((Object)type)).evaluateOperation(object, object2, n);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object3);
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("arithmetic", n);
        prettyPrinter.printToken(this.getOperationAsString(), n + 1);
        this.m_operand1.toString(prettyPrinter, n + 1);
        this.m_operand2.toString(prettyPrinter, n + 1);
        prettyPrinter.printFormClose(n);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ArithmeticInstruction arithmeticInstruction = (ArithmeticInstruction)object;
        return arithmeticInstruction.m_operation == this.m_operation;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction, Instruction instruction2) {
        return new ArithmeticInstruction(this.m_operation, instruction, instruction2);
    }
}

