/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator;

import com.ibm.xtq.ast.XPath20Exception;
import com.ibm.xtq.ast.nodes.ContextItemExprImpl;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionCall;
import com.ibm.xtq.ast.nodes.FunctionDecl;
import com.ibm.xtq.ast.nodes.KindTest;
import com.ibm.xtq.ast.nodes.Literal;
import com.ibm.xtq.ast.nodes.NameTest;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.NodeTest;
import com.ibm.xtq.ast.nodes.Number;
import com.ibm.xtq.ast.nodes.OperatorExpr;
import com.ibm.xtq.ast.nodes.PathExpr;
import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.nodes.Sort;
import com.ibm.xtq.ast.nodes.StepExpr;
import com.ibm.xtq.ast.nodes.Template;
import com.ibm.xtq.ast.nodes.TopLevelDecl;
import com.ibm.xtq.ast.nodes.TypeExpr;
import com.ibm.xtq.ast.nodes.VarDecl;
import com.ibm.xtq.ast.nodes.VariableBase;
import com.ibm.xtq.ast.nodes.VariableRef;
import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xtq.ast.parsers.xpath.factories.ExpressionFactoryImpl;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.common.utils.Assert;
import com.ibm.xtq.scontext.XStaticContext;
import com.ibm.xtq.xslt.drivers.XPathCompiler;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ObjectFactory;
import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.typechecker.v1.types.MethodType;
import com.ibm.xtq.xslt.typechecker.v1.types.NumberType;
import com.ibm.xtq.xslt.typechecker.v1.types.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;

public class XSLTCHelper
implements XPathTreeConstants {
    public static final int STEP_PATTERN_NO_CONTEXT = 0;
    public static final int STEP_PATTERN_SIMPLE_CONTEXT = 1;
    public static final int STEP_PATTERN_GENERAL_CONTEXT = 2;
    private static final String TRANSLET_URI = "http://xml.apache.org/xalan/xsltc";
    private static final short AXIS_MISMATCH = -1;
    private static final char DASH = '-';

    public static String getNormalizedFunctionName(String string) {
        if (string.indexOf(45) > 0) {
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = 0; i < string.length(); ++i) {
                if (i > 0 && string.charAt(i - 1) == '-') {
                    stringBuffer.append(Character.toUpperCase(string.charAt(i)));
                    continue;
                }
                if (string.charAt(i) == '-') continue;
                stringBuffer.append(string.charAt(i));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String getMethodSignature(String string, String string2, List list) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('.').append(string2).append('(');
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Type type = (Type)list.get(i);
            stringBuffer.append(type.toString());
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static List findMethods(Class clazz, String string, int n) {
        ArrayList<Method> arrayList = null;
        if (clazz != null) {
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                int n2 = methodArray[i].getModifiers();
                if (!Modifier.isPublic(n2) || !methodArray[i].getName().equals(string) || methodArray[i].getParameterTypes().length != n) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Method>();
                }
                arrayList.add(methodArray[i]);
            }
        }
        return arrayList;
    }

    public static XTQProgram getStylesheet(SimpleNode simpleNode) {
        for (Node node = simpleNode; node != null; node = node.jjtGetParent()) {
            if (!(node instanceof XTQProgram)) continue;
            return (XTQProgram)node;
        }
        return null;
    }

    public static VariableBase findAncestorVariable(Expr expr) {
        Node node = expr.jjtGetParent();
        return XSLTCHelper.findAncestorVariable(node);
    }

    private static VariableBase findAncestorVariable(Node node) {
        Node node2 = null;
        while (node != null) {
            if (node instanceof VariableBase) {
                node2 = node;
            }
            node = node.jjtGetParent();
        }
        if (node2 != null) {
            return (VariableBase)node2;
        }
        return null;
    }

    public static boolean isPredicate(Expr expr) {
        Node node = expr.jjtGetParent();
        return node instanceof StepExpr && node.jjtGetChild(0) != expr;
    }

    public static boolean isClosure(Node node) {
        return node instanceof Number || node instanceof Sort || node instanceof Expr && XSLTCHelper.isPredicate((Expr)node);
    }

    public static void addVariableToClosure(SimpleNode simpleNode, VariableRef variableRef) {
        if (simpleNode instanceof Number) {
            Number number = (Number)simpleNode;
            ArrayList<VariableRef> arrayList = ASTDecorator.getClosureVars(number);
            if (arrayList == null) {
                arrayList = new ArrayList<VariableRef>();
                ASTDecorator.setClosureVars(number, arrayList);
            }
            if (!arrayList.contains(variableRef)) {
                arrayList.add(variableRef);
            }
        } else if (simpleNode instanceof Sort) {
            Sort sort = (Sort)simpleNode;
            ArrayList<VariableRef> arrayList = ASTDecorator.getClosureVars(sort);
            if (arrayList == null) {
                arrayList = new ArrayList<VariableRef>();
                ASTDecorator.setClosureVars(sort, arrayList);
            }
            if (!arrayList.contains(variableRef)) {
                arrayList.add(variableRef);
                sort.setSortRecordFactoryNeeded(true);
            }
        } else if (simpleNode instanceof Expr && XSLTCHelper.isPredicate((Expr)simpleNode)) {
            Expr expr = (Expr)simpleNode;
            ArrayList<VariableRef> arrayList = ASTDecorator.getClosureVars(expr);
            if (arrayList == null) {
                arrayList = new ArrayList<VariableRef>();
                ASTDecorator.setClosureVars(expr, arrayList);
            }
            if (!arrayList.contains(variableRef)) {
                arrayList.add(variableRef);
                SimpleNode simpleNode2 = XSLTCHelper.getParentClosure(simpleNode);
                if (simpleNode2 != null) {
                    XSLTCHelper.addVariableToClosure(simpleNode2, variableRef);
                }
            }
        }
    }

    public static String getClosureInnerClassName(SimpleNode simpleNode) {
        if (simpleNode instanceof Number) {
            return ASTDecorator.getInnerClassName((Number)simpleNode);
        }
        if (simpleNode instanceof Sort) {
            return ASTDecorator.getInnerClassName((Sort)simpleNode);
        }
        if (simpleNode instanceof Expr) {
            return ASTDecorator.getInnerClassName((Expr)simpleNode);
        }
        return null;
    }

    public static SimpleNode getParentClosure(SimpleNode simpleNode) {
        if (simpleNode instanceof Expr && XSLTCHelper.isPredicate((Expr)simpleNode)) {
            Node node = simpleNode.jjtGetParent();
            do {
                if (XSLTCHelper.isClosure(node)) {
                    return (SimpleNode)node;
                }
                if (!(node instanceof TopLevelDecl)) continue;
                return null;
            } while ((node = node.jjtGetParent()) != null);
            return null;
        }
        return null;
    }

    public static Boolean evaluateElementAvailableAtCompileTime(FunctionCall functionCall, XPathCompiler xPathCompiler) {
        Literal literal = (Literal)functionCall.getOperand(0);
        String string = literal.getStringLiteral();
        int n = string.indexOf(58);
        String string2 = n > 0 ? string.substring(n + 1) : string;
        String string3 = n > 0 ? string.substring(0, n) : "";
        XSLTParser xSLTParser = xPathCompiler.getParser();
        XStaticContext xStaticContext = xSLTParser.getStaticContext();
        xStaticContext.setCurrentNode(functionCall);
        String string4 = xStaticContext.lookupNamespace(string3);
        return xSLTParser.elementSupported(string4, string2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Boolean evaluateFunctionAvailableAtCompileTime(FunctionCall functionCall, XPathCompiler xPathCompiler, Hashtable hashtable) {
        Expr expr = functionCall.getOperand(0);
        if (expr.getId() == 5) {
            Literal literal = (Literal)expr;
            String string = null;
            string = literal.getStringLiteral();
            int n = string.indexOf(58);
            String string2 = n > 0 ? string.substring(n + 1) : string;
            String string3 = n > 0 ? string.substring(0, n) : "";
            String string4 = xPathCompiler.getParser().getStaticContext().lookupNamespace(string3);
            if (XSLTCHelper.isStylesheetFunctionCallWithoutArity(string2, string4, string3, xPathCompiler)) {
                return Boolean.TRUE;
            }
            if (string4 == null || string4.length() == 0 || string4.equals(TRANSLET_URI)) {
                return Boolean.FALSE;
            }
            return XSLTCHelper.hasExternalMethods(string4, string2, hashtable) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    private static boolean hasExternalMethods(String string, String string2, Hashtable hashtable) {
        String string3 = XSLTCHelper.getClassNameFromUri(string, hashtable);
        String string4 = null;
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string4 = string2.substring(n + 1);
            string3 = string3 != null && string3.length() > 0 ? string3 + "." + string2.substring(0, n) : string2.substring(0, n);
        } else {
            string4 = string2;
        }
        if (string3 == null || string4 == null) {
            return false;
        }
        if (string4.indexOf(45) > 0) {
            string4 = XSLTCHelper.getNormalizedFunctionName(string4);
        }
        try {
            Class clazz = ObjectFactory.findProviderClass(string3, ObjectFactory.findClassLoader(), true);
            if (clazz == null) {
                return false;
            }
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                int n2 = methodArray[i].getModifiers();
                if (!Modifier.isPublic(n2) || !Modifier.isStatic(n2) || !methodArray[i].getName().equals(string4)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return false;
    }

    public static int xpathAxis2DTMAxis(int n) {
        switch (n) {
            case 7: {
                return 0;
            }
            case 13: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 10: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 12: {
                return 9;
            }
            case 3: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 9: {
                return 12;
            }
            case 5: {
                return 13;
            }
        }
        return -1;
    }

    public static int xpathOpType2XSLTCOpType(int n) {
        switch (n) {
            case 13: {
                return 0;
            }
            case 14: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 18: {
                return 4;
            }
            case 15: {
                return 3;
            }
            case 16: {
                return 5;
            }
        }
        throw new StaticError("ERR_SYSTEM", "Invalid xpath operator type: " + String.valueOf(n));
    }

    public static StepExpr getStepForPredicate(Expr expr) {
        if (expr == null) {
            return null;
        }
        if (expr.getId() == 59) {
            PathExpr pathExpr;
            OperatorExpr operatorExpr = (OperatorExpr)expr;
            if (operatorExpr.getOperatorType() != 13 && operatorExpr.getOperatorType() != 14) {
                return null;
            }
            Expr expr2 = operatorExpr.getOperand(0);
            Expr expr3 = operatorExpr.getOperand(1);
            if (expr2.getId() == 85) {
                return (StepExpr)expr2;
            }
            if (expr2.getId() == 82 && (pathExpr = (PathExpr)expr2).getOperandCount() == 1 && pathExpr.getOperand(0) instanceof StepExpr) {
                return (StepExpr)pathExpr.getOperand(0);
            }
            if (expr3.getId() == 85) {
                return (StepExpr)expr3;
            }
            if (expr3.getId() == 82 && (pathExpr = (PathExpr)expr3).getOperandCount() == 1 && pathExpr.getOperand(0) instanceof StepExpr) {
                return (StepExpr)pathExpr.getOperand(0);
            }
        }
        return null;
    }

    protected static boolean isLastCall(Expr expr) {
        if (expr instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)expr;
            QName qName = functionCall.getFunctionQName();
            return qName.getNamespaceURI().equals(functionCall.getBuiltInNamespaceFunc()) && qName.getLocalPart().equals("last");
        }
        return false;
    }

    public static boolean isKeyCall(Expr expr) {
        if (expr instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)expr;
            QName qName = functionCall.getFunctionQName();
            return qName.getNamespaceURI().equals(functionCall.getBuiltInNamespaceFunc()) && qName.getLocalPart().equals("key");
        }
        return false;
    }

    public static boolean isPattern(Expr expr) {
        int n = expr.getId();
        return n == 186 || n == 187 || n == 188;
    }

    public static boolean isProcessingInstructionPattern(StepExpr stepExpr) {
        try {
            NodeTest nodeTest = stepExpr.getNodeTest();
            return nodeTest.isKindTest() && ((KindTest)nodeTest).getPITarget() != null;
        }
        catch (XPath20Exception xPath20Exception) {
            return false;
        }
    }

    public static boolean hasArgumentPattern(StepExpr stepExpr) {
        try {
            NodeTest nodeTest = stepExpr.getNodeTest();
            if (nodeTest.isKindTest()) {
                KindTest kindTest = (KindTest)nodeTest;
                return kindTest.getNodeName() != null || kindTest.getElementTest() != null || kindTest.getTypeName() != null;
            }
            return false;
        }
        catch (XPath20Exception xPath20Exception) {
            return false;
        }
    }

    public static boolean isFilterStep(Expr expr) {
        return expr instanceof StepExpr && ((StepExpr)expr).isFilterStep();
    }

    public static void dontOptimize(Expr expr) {
        ASTDecorator.setCanOptimize(expr, false);
    }

    public static boolean hasPositionCall(Expr expr) {
        switch (expr.getId()) {
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                OperatorExpr operatorExpr = (OperatorExpr)expr;
                return XSLTCHelper.hasPositionCall(operatorExpr.getOperand(0)) || XSLTCHelper.hasPositionCall(operatorExpr.getOperand(1));
            }
            case 69: {
                OperatorExpr operatorExpr = (OperatorExpr)expr;
                return XSLTCHelper.hasPositionCall(operatorExpr.getOperand(0));
            }
            case 105: {
                FunctionCall functionCall = (FunctionCall)expr;
                QName qName = functionCall.getFunctionQName();
                String string = qName.getNamespaceURI();
                String string2 = qName.getLocalPart();
                if (string != null && string.equals(functionCall.getBuiltInNamespaceFunc())) {
                    return string2.equals("last") || string2.equals("position");
                }
                return false;
            }
        }
        return false;
    }

    public static boolean hasLastCall(Expr expr) {
        switch (expr.getId()) {
            case 59: 
            case 61: 
            case 62: {
                OperatorExpr operatorExpr = (OperatorExpr)expr;
                return XSLTCHelper.hasLastCall(operatorExpr.getOperand(0)) || XSLTCHelper.hasLastCall(operatorExpr.getOperand(1));
            }
            case 105: {
                return XSLTCHelper.isLastCall(expr);
            }
        }
        return false;
    }

    public static boolean hasParentPattern(Expr expr) {
        Node node = expr.jjtGetParent();
        if (node instanceof PathExpr) {
            int n;
            PathExpr pathExpr = (PathExpr)node;
            int n2 = n = pathExpr.isAbsolute() ? 1 : 0;
            if (pathExpr.getOperandCount() - n > 1) {
                return true;
            }
        } else if (node instanceof OperatorExpr && ((OperatorExpr)node).getOperatorType() == 1) {
            return true;
        }
        return false;
    }

    public static boolean isWildcardNodeTest(StepExpr stepExpr) {
        try {
            NameTest nameTest;
            NodeTest nodeTest = stepExpr.getNodeTest();
            if (nodeTest instanceof NameTest && (nameTest = (NameTest)nodeTest).getNameTestType() == 0 && nameTest.getQName() == null) {
                return true;
            }
        }
        catch (XPath20Exception xPath20Exception) {
            return false;
        }
        return false;
    }

    public static boolean isAbbreviatedDot(StepExpr stepExpr) {
        try {
            if (stepExpr.isFilterStep()) {
                return stepExpr.getPrimaryExpr() instanceof ContextItemExprImpl;
            }
            return stepExpr.getAxisType() == 5 && stepExpr.getStepNodeType() == -1;
        }
        catch (XPath20Exception xPath20Exception) {
            return false;
        }
    }

    public static boolean isNamedFunction(FunctionCall functionCall, String string, String string2) {
        QName qName = functionCall.getFunctionQName();
        String string3 = qName.getNamespaceURI();
        String string4 = qName.getLocalPart();
        if (string != null) {
            return string.equals(string3) && string4.equals(string2);
        }
        return (string3 == null || string3.length() == 0) && string4.equals(string2);
    }

    public static boolean isWildcardPattern(Expr expr) {
        if (expr.getId() == 188) {
            StepExpr stepExpr = (StepExpr)expr;
            if (XSLTCHelper.isProcessingInstructionPattern(stepExpr)) {
                return false;
            }
            if (XSLTCHelper.hasArgumentPattern(stepExpr)) {
                return false;
            }
            return ASTDecorator.isPatternReduced(expr) && stepExpr.getPredicateCount() == 0;
        }
        return false;
    }

    public static boolean isSimpleStep(Expr expr) {
        Expr expr2;
        PathExpr pathExpr;
        StepExpr stepExpr = null;
        if (expr instanceof StepExpr) {
            stepExpr = (StepExpr)expr;
        } else if (expr instanceof PathExpr && !(pathExpr = (PathExpr)expr).isAbsolute() && pathExpr.getOperandCount() == 1 && (expr2 = pathExpr.getOperand(0)) instanceof StepExpr) {
            stepExpr = (StepExpr)expr2;
        }
        return stepExpr != null ? !stepExpr.isFilterStep() || XSLTCHelper.isAbbreviatedDot(stepExpr) : false;
    }

    protected static String getNextFieldNameForStepPattern(XPathCompiler xPathCompiler) {
        return "__step_pattern_iter_" + xPathCompiler.nextStepPatternSerial();
    }

    public static int analyzeContextCasesForStepPattern(StepExpr stepExpr) {
        boolean bl = true;
        int n = stepExpr.getPredicateCount();
        for (int i = 0; i < n && bl; ++i) {
            Expr expr = stepExpr.getPredicateAt(i);
            if (!XSLTCHelper.hasPositionCall(expr) && !ASTDecorator.isNthPositionFilter(expr)) continue;
            bl = false;
            Object object = expr.getProperty("type");
            if (!(object instanceof NumberType)) continue;
            return 2;
        }
        if (bl) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        return 2;
    }

    public static boolean isUnionPattern(Expr expr) {
        return expr.getId() == 186 && expr instanceof OperatorExpr && ((OperatorExpr)expr).getOperatorType() == 1;
    }

    public static StepExpr getKernelPattern(Expr expr) {
        Expr expr2;
        OperatorExpr operatorExpr;
        int n;
        int n2 = expr.getId();
        if (n2 == 188) {
            StepExpr stepExpr = (StepExpr)expr;
            return stepExpr;
        }
        if (n2 == 187) {
            PathExpr pathExpr = (PathExpr)expr;
            int n3 = pathExpr.getOperandCount();
            if (n3 > 0) {
                Expr expr3 = pathExpr.getOperand(n3 - 1);
                if (expr3.getId() == 188) {
                    return (StepExpr)expr3;
                }
                return XSLTCHelper.getKernelPattern(expr3);
            }
        } else if (n2 == 84 && (n = (operatorExpr = (OperatorExpr)expr).getOperandCount()) > 0 && (expr2 = operatorExpr.getOperand(n - 1)).getId() == 188) {
            return (StepExpr)expr2;
        }
        return null;
    }

    public static int getAxisForPattern(Expr expr) {
        StepExpr stepExpr = XSLTCHelper.getKernelPattern(expr);
        try {
            if (stepExpr != null) {
                return stepExpr.getAxisType();
            }
            return 1;
        }
        catch (XPath20Exception xPath20Exception) {
            return 1;
        }
    }

    public static Template getTemplateForPattern(Expr expr) {
        for (Node node = expr.jjtGetParent(); node != null; node = node.jjtGetParent()) {
            if (!(node instanceof Template)) continue;
            return (Template)node;
        }
        return null;
    }

    public static boolean noSmallerThan(Expr expr, Expr expr2) {
        int n;
        Template template = XSLTCHelper.getTemplateForPattern(expr);
        Template template2 = XSLTCHelper.getTemplateForPattern(expr2);
        int n2 = template.getImportPrecedence();
        if (n2 > (n = template2.getImportPrecedence())) {
            return true;
        }
        if (n2 == n) {
            double d;
            double d2 = ASTDecorator.getPatternPriority(expr);
            if (d2 > (d = ASTDecorator.getPatternPriority(expr2))) {
                return true;
            }
            if (d2 == d && template.getPosition() > template2.getPosition()) {
                return true;
            }
        }
        return false;
    }

    public static double getPatternDefaultPriority(Expr expr) {
        Expr expr2;
        if (expr.getId() == 187 && !((PathExpr)(expr2 = (PathExpr)expr)).isAbsolute() && ((OperatorExpr)expr2).getOperandCount() == 1) {
            expr = ((OperatorExpr)expr2).getOperand(0);
        }
        if (expr.getId() == 188) {
            expr2 = (StepExpr)expr;
            double d = ASTDecorator.getPatternPriority(expr);
            if (!Double.isNaN(d)) {
                return d;
            }
            if (((StepExpr)expr2).getPredicateCount() > 0) {
                return 0.5;
            }
            if (XSLTCHelper.isProcessingInstructionPattern((StepExpr)expr2)) {
                return 0.0;
            }
            int n = ((StepExpr)expr2).getStepNodeType();
            switch (n) {
                case -1: {
                    return -0.5;
                }
                case 0: {
                    return 0.0;
                }
            }
            return n >= 14 ? 0.0 : -0.5;
        }
        return 0.5;
    }

    public static double getPatternPriority(Expr expr) {
        if (XSLTCHelper.isUnionPattern(expr)) {
            throw new StaticError("ERR_SYSTEM", "Union pattern priority is undefined.");
        }
        Template template = XSLTCHelper.getTemplateForPattern(expr);
        double d = template.getPriority();
        if (!Double.isNaN(d)) {
            return d;
        }
        return XSLTCHelper.getPatternDefaultPriority(expr);
    }

    public static void reduceKernelPattern(Expr expr) {
        PathExpr pathExpr;
        int n;
        if (expr.getId() == 188) {
            ASTDecorator.setPatternReduced(expr, true);
        } else if (expr.getId() == 187 && (n = (pathExpr = (PathExpr)expr).getOperandCount()) > 0) {
            Expr expr2 = pathExpr.getOperand(n - 1);
            ASTDecorator.setPatternReduced(expr2, true);
        }
    }

    public static int findNodeTypeForStep(StepExpr stepExpr, XPathCompiler xPathCompiler) {
        NodeTest nodeTest = null;
        short s = 0;
        try {
            nodeTest = stepExpr.getNodeTest();
            s = stepExpr.getAxisType();
        }
        catch (XPath20Exception xPath20Exception) {
            // empty catch block
        }
        XSLTParser xSLTParser = xPathCompiler.getParser();
        XStaticContext xStaticContext = xSLTParser.getStaticContext();
        if (nodeTest.isNameTest()) {
            NameTest nameTest = (NameTest)nodeTest;
            QName qName = nameTest.getQName();
            String string = null;
            String string2 = null;
            String string3 = null;
            if (qName != null) {
                string2 = qName.getLocalPart();
                string3 = qName.getPrefix();
                string = qName.getNamespaceURI();
            } else {
                short s2 = nameTest.getNameTestType();
                if (s2 == 0) {
                    if (s == 12) {
                        return -1;
                    }
                    if (s == 4) {
                        return 2;
                    }
                    return 1;
                }
                if (s2 == 1) {
                    string3 = nameTest.getNCName();
                    string = xStaticContext.lookupNamespace(string3);
                    string2 = "*";
                    if (s != 12) {
                        int n = stepExpr.getId();
                        if (n == 188 && stepExpr.getPredicateCount() == 0) {
                            ASTDecorator.setPatternPriority(stepExpr, -0.25);
                        } else if (n == 85) {
                            XSLTCHelper.nameTestRewrite(stepExpr, xPathCompiler.getParser(), false);
                            if (s == 4) {
                                return 2;
                            }
                            return 1;
                        }
                    }
                } else if (s2 == 2) {
                    string2 = nameTest.getNCName();
                }
            }
            if (s == 12) {
                if (qName != null) {
                    QName qName2 = new QName("", string2, "xmlns");
                    return xPathCompiler.registerNamespaceDecl(qName2);
                }
                return -1;
            }
            QName qName3 = xSLTParser.getQName(string, string3, string2);
            if (s == 4) {
                return xPathCompiler.registerAttribute(qName3);
            }
            return xPathCompiler.registerElement(qName3);
        }
        KindTest kindTest = (KindTest)nodeTest;
        short s3 = kindTest.getKindTestType();
        switch (s3) {
            case 0: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return -1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 9;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
        }
        return -1;
    }

    public static boolean hasVariableReferences(Expr expr) {
        if (expr instanceof VariableRef) {
            return true;
        }
        if (expr instanceof OperatorExpr) {
            return XSLTCHelper.hasVariableReferencesForOperator((OperatorExpr)expr);
        }
        if (expr instanceof StepExpr) {
            return XSLTCHelper.hasVariableReferencesForStep((StepExpr)expr);
        }
        return false;
    }

    private static boolean hasVariableReferencesForStep(StepExpr stepExpr) {
        if (stepExpr.isFilterStep()) {
            Expr expr = null;
            try {
                expr = stepExpr.getPrimaryExpr();
            }
            catch (XPath20Exception xPath20Exception) {
                return false;
            }
            if (XSLTCHelper.hasVariableReferences(expr)) {
                return true;
            }
        }
        int n = stepExpr.getPredicateCount();
        for (int i = 0; i < n; ++i) {
            Expr expr = stepExpr.getPredicateAt(i);
            if (!XSLTCHelper.hasVariableReferences(expr)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasVariableReferencesForOperator(OperatorExpr operatorExpr) {
        int n = operatorExpr.getOperandCount();
        for (int i = 0; i < n; ++i) {
            Expr expr = operatorExpr.getOperand(i);
            if (!XSLTCHelper.hasVariableReferences(expr)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkOrderNodes(PathExpr pathExpr) {
        int n;
        int n2 = pathExpr.getOperandCount();
        int n3 = n = pathExpr.isAbsolute() ? 1 : 0;
        if (n2 > n + 1) {
            return XSLTCHelper.getCombinedAxis(pathExpr) == -1;
        }
        return false;
    }

    public static short getCombinedAxis(Expr expr) {
        if (expr instanceof StepExpr) {
            return XSLTCHelper.getAxisForStep((StepExpr)expr);
        }
        if (expr instanceof ContextItemExprImpl) {
            return 5;
        }
        if (expr instanceof VariableRef) {
            return XSLTCHelper.getAxisForVariable((VariableRef)expr);
        }
        if (expr instanceof FunctionCall) {
            return XSLTCHelper.getAxisForFunction((FunctionCall)expr);
        }
        if (expr instanceof PathExpr) {
            int n;
            PathExpr pathExpr = (PathExpr)expr;
            int n2 = pathExpr.getOperandCount();
            int n3 = n = pathExpr.isAbsolute() ? 1 : 0;
            if (n2 == n) {
                return 5;
            }
            if (n2 == n + 1) {
                return XSLTCHelper.getCombinedAxis(pathExpr.getOperand(n));
            }
            short s = XSLTCHelper.getCombinedAxis(pathExpr.getOperand(n));
            short s2 = XSLTCHelper.getCombinedAxis(pathExpr.getOperand(n + 1));
            short s3 = XSLTCHelper.getCombinedAxis(s, s2);
            for (int i = n + 2; i < n2; ++i) {
                if (s3 == -1) {
                    return -1;
                }
                s2 = XSLTCHelper.getCombinedAxis(pathExpr.getOperand(i));
                s3 = XSLTCHelper.getCombinedAxis(s3, s2);
            }
            return s3;
        }
        return -1;
    }

    public static short getAxisForVariable(VariableRef variableRef) {
        VariableBase variableBase = ASTDecorator.getVariable(variableRef);
        if (variableBase instanceof VarDecl) {
            Expr expr = variableBase.getExpression();
            if (expr != null) {
                return XSLTCHelper.getCombinedAxis(expr);
            }
            return -1;
        }
        return -1;
    }

    public static short getAxisForFunction(FunctionCall functionCall) {
        QName qName = functionCall.getFunctionQName();
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        if (string2 != null && string2.equals(functionCall.getBuiltInNamespaceFunc()) && (string.equals("document") || string.equals("current"))) {
            return 5;
        }
        return -1;
    }

    public static short getAxisForStep(StepExpr stepExpr) {
        try {
            if (stepExpr.isFilterStep()) {
                Expr expr = stepExpr.getPrimaryExpr();
                if (expr instanceof VariableRef) {
                    return XSLTCHelper.getAxisForVariable((VariableRef)expr);
                }
                if (expr instanceof FunctionCall) {
                    return XSLTCHelper.getAxisForFunction((FunctionCall)expr);
                }
                if (expr instanceof ContextItemExprImpl) {
                    return 5;
                }
                return -1;
            }
            return stepExpr.getAxisType();
        }
        catch (XPath20Exception xPath20Exception) {
            return -1;
        }
    }

    public static short getCombinedAxis(short s, short s2) {
        if (s == -1 || s2 == -1) {
            return -1;
        }
        if (s2 == 4 || s2 == 12) {
            return s2;
        }
        if (s2 == 5) {
            return s;
        }
        if (s == 8 || s == 9) {
            if (s2 == 1) {
                return s;
            }
            if (s2 == 2 || s2 == 6) {
                return s2;
            }
            return -1;
        }
        if (s == 5 || s == 3) {
            return s2;
        }
        if (s == 1) {
            if (s2 == 1 || s2 == 2 || s2 == 6) {
                return s2;
            }
            return -1;
        }
        return -1;
    }

    public static void flattenUnionExpression(OperatorExpr operatorExpr, List list) {
        for (int i = 0; i < 2; ++i) {
            Expr expr = operatorExpr.getOperand(i);
            if (expr.getId() == 63) {
                XSLTCHelper.flattenUnionExpression((OperatorExpr)expr, list);
                continue;
            }
            list.add(expr);
        }
    }

    public static FunctionDecl getStylesheetFunctionCall(FunctionCall functionCall, XPathCompiler xPathCompiler) {
        XSLTParser xSLTParser = xPathCompiler.getParser();
        String string = functionCall.getFunctionQName().getLocalPart();
        String string2 = functionCall.getFunctionQName().getNamespaceURI();
        String string3 = functionCall.getFunctionQName().getPrefix();
        int n = functionCall.getOperandCount();
        QName qName = xSLTParser.getQName(string2, string3, string);
        return xSLTParser.getStaticContext().lookupStylesheetFunction(qName, n);
    }

    public static boolean isStylesheetFunctionCall(FunctionCall functionCall, XPathCompiler xPathCompiler) {
        FunctionDecl functionDecl = XSLTCHelper.getStylesheetFunctionCall(functionCall, xPathCompiler);
        return null != functionDecl;
    }

    public static boolean isStylesheetFunctionCallWithoutArity(String string, String string2, String string3, XPathCompiler xPathCompiler) {
        XSLTParser xSLTParser = xPathCompiler.getParser();
        QName qName = xSLTParser.getQName(string2, string3, string);
        return xSLTParser.getExpressionFactory().getStaticContext().stylesheetFunctionAvailable(qName);
    }

    public static MethodType generateTypeForFunction(FunctionCall functionCall, XPathCompiler xPathCompiler) {
        Type type = Type.Reference;
        Type type2 = Type.NodeSet;
        try {
            int n;
            FunctionDecl functionDecl = XSLTCHelper.getStylesheetFunctionCall(functionCall, xPathCompiler);
            if (null == functionDecl) {
                return null;
            }
            int n2 = functionDecl.getArity();
            Class[] classArray = new Class[n2 + 1];
            Object[] objectArray = new Object[n2 + 1];
            classArray[0] = Type.class;
            TypeExpr typeExpr = functionDecl.getResultType();
            objectArray[0] = null == typeExpr ? type2 : type2;
            List list = functionDecl.getParamTypes();
            if (null == list) {
                for (n = 1; n <= n2; ++n) {
                    classArray[n] = Type.class;
                    objectArray[n] = type;
                }
            } else {
                n = 1;
                for (Object e : list) {
                    classArray[n] = Type.class;
                    objectArray[n] = null == e ? type : type;
                    ++n;
                }
            }
            Class<MethodType> clazz = MethodType.class;
            Constructor constructor = clazz.getConstructor(classArray);
            return (MethodType)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static XPathFunction getJAXPFunctionCall(FunctionCall functionCall, XPathCompiler xPathCompiler) {
        XSLTParser xSLTParser = xPathCompiler.getParser();
        String string = functionCall.getFunctionQName().getLocalPart();
        String string2 = functionCall.getFunctionQName().getNamespaceURI();
        String string3 = functionCall.getFunctionQName().getPrefix();
        int n = functionCall.getOperandCount();
        QName qName = xSLTParser.getQName(string2, string3, string);
        return xSLTParser.getStaticContext().lookupJAXPFunction(qName, n);
    }

    public static boolean isJAXPFunctionCall(FunctionCall functionCall, XPathCompiler xPathCompiler) {
        XPathFunction xPathFunction = XSLTCHelper.getJAXPFunctionCall(functionCall, xPathCompiler);
        return xPathFunction != null;
    }

    public static Object getJAXPVariable(VariableRef variableRef, XPathCompiler xPathCompiler) {
        XSLTParser xSLTParser = xPathCompiler.getParser();
        QName qName = variableRef.getVariableName();
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        String string3 = qName.getPrefix();
        QName qName2 = xSLTParser.getQName(string2, string3, string);
        return xSLTParser.getStaticContext().lookupJAXPVariable(qName2);
    }

    public static boolean isJAXPVariable(VariableRef variableRef, XPathCompiler xPathCompiler) {
        Object object = XSLTCHelper.getJAXPVariable(variableRef, xPathCompiler);
        return object != null;
    }

    public static boolean isExtFunction(FunctionDecl functionDecl, XPathCompiler xPathCompiler, Hashtable hashtable) {
        QName qName = functionDecl.getQName();
        String string = qName.getNamespaceURI();
        if (string != null && string.length() > 0 && !string.equals(TRANSLET_URI)) {
            int n;
            List list;
            String string2 = qName.getLocalPart();
            String string3 = XSLTCHelper.getClassNameFromUri(string, hashtable);
            Class clazz = null;
            int n2 = string2.lastIndexOf(46);
            if (n2 > 0) {
                string3 = string3 != null && string3.length() > 0 ? string3 + "." + string2.substring(0, n2) : string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
            } else {
                String string4;
                if (string3 != null && string3.length() > 0) {
                    try {
                        clazz = ObjectFactory.findProviderClass(string3, ObjectFactory.findClassLoader(), true);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (string2.indexOf(45) > 0) {
                    string2 = XSLTCHelper.getNormalizedFunctionName(string2);
                }
                if ((string4 = (String)hashtable.get(string + ":" + string2)) != null) {
                    Assert.assertNotImplemented();
                }
            }
            if (clazz == null) {
                try {
                    clazz = ObjectFactory.findProviderClass(string3, ObjectFactory.findClassLoader(), true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
            }
            return (list = XSLTCHelper.findMethods(clazz, string2, n = functionDecl.getArity())) != null;
        }
        return false;
    }

    public static String getClassNameFromUri(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string.startsWith("http://xml.apache.org/xalan/xsltc/java")) {
            int n = "http://xml.apache.org/xalan/xsltc/java".length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        if (string.startsWith("http://xml.apache.org/xalan/java")) {
            int n = "http://xml.apache.org/xalan/java".length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        if (string.startsWith("http://xml.apache.org/xslt/java")) {
            int n = "http://xml.apache.org/xslt/java".length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        int n = string.lastIndexOf(47);
        return n > 0 ? string.substring(n + 1) : string;
    }

    public static void processingInstructionTestRewrite(StepExpr stepExpr, XSLTParser xSLTParser) {
        try {
            KindTest kindTest = (KindTest)stepExpr.getNodeTest();
            String string = kindTest.getPITarget();
            if (string != null && string.length() > 0) {
                ExpressionFactoryImpl expressionFactoryImpl = xSLTParser.getExpressionFactory();
                Expr expr = expressionFactoryImpl.createExpr(xSLTParser, "name(.)='" + string + "'");
                stepExpr.jjtInsertChild(expr, 1);
            }
        }
        catch (XPath20Exception xPath20Exception) {
            // empty catch block
        }
    }

    protected static void nameTestRewrite(StepExpr stepExpr, XSLTParser xSLTParser, boolean bl) {
        try {
            NameTest nameTest = (NameTest)stepExpr.jjtGetChild(0);
            NameTest nameTest2 = new NameTest(91);
            nameTest2.setNameTestType((short)0);
            stepExpr.jjtReplaceChild(nameTest2, 0);
            ExpressionFactoryImpl expressionFactoryImpl = xSLTParser.getExpressionFactory();
            XStaticContext xStaticContext = xSLTParser.getStaticContext();
            String string = xStaticContext.getNamespaceURI(nameTest.getNCName());
            OperatorExpr operatorExpr = (OperatorExpr)expressionFactoryImpl.createExpr(xSLTParser, "namespace-uri() = '" + string + "'");
            stepExpr.jjtInsertChild(operatorExpr, 1);
            if (bl) {
                stepExpr.setPatternStepRewrittenToPredicate(true);
            }
            stepExpr.setStepNodeType(1);
        }
        catch (XPath20Exception xPath20Exception) {
            // empty catch block
        }
    }
}

