/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.DataBufferHelper;
import com.ibm.xml.xlxp.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.DataSource;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.UTF8Support;
import com.ibm.xml.xlxp.scan.util.UntestedCode;
import java.io.IOException;
import java.io.Reader;

public final class CharacterStreamDataSource
implements DataSource {
    public CharacterStreamDataSource nextFreeDataSource;
    private static final boolean CLEAR_TO_END_OF_BUFFER = false;
    private DataSourceFactory fSourceFactory;
    private DataBufferFactory fBufferFactory;
    private int fBufferLength;
    private Reader fReader;
    private char[] fCharBuffer;
    private int fCharOffset;
    private int[] fResultsPointer;
    private int fLoadCount;
    private int fReclaimBufferLimit;

    public CharacterStreamDataSource(DataSourceFactory dataSourceFactory, DataBufferFactory dataBufferFactory, int n) {
        this.fSourceFactory = dataSourceFactory;
        this.fBufferFactory = dataBufferFactory;
        this.fBufferLength = n;
        this.fCharBuffer = new char[n];
        this.fResultsPointer = new int[2];
    }

    public void setCharacterStream(Reader reader) {
        this.fReader = reader;
        this.fCharOffset = 0;
        this.fLoadCount = 0;
        this.fReclaimBufferLimit = 524288 / this.fBufferLength;
    }

    @Override
    public CharConversionError load(ParsedEntity parsedEntity) {
        if (++this.fLoadCount % this.fReclaimBufferLimit == 0) {
            this.fBufferFactory.reclaimBuffers(this.fReclaimBufferLimit);
        }
        DataBuffer dataBuffer = this.fBufferFactory.createBuffer();
        if (dataBuffer.bytes == null) {
            dataBuffer.bytes = new byte[this.fBufferLength + 3];
        } else if (dataBuffer.bytes.length < this.fBufferLength + 3) {
            dataBuffer.bytes = new byte[this.fBufferLength + 3];
        }
        parsedEntity.error = this.load(dataBuffer);
        if (parsedEntity.buffer != null) {
            if (parsedEntity.buffer.next != null) {
                UntestedCode.needTest("unknown(4)");
            }
            parsedEntity.buffer.next = dataBuffer;
            if (parsedEntity.isCoordinatesAware) {
                if (parsedEntity.isXML10) {
                    DataBufferHelper.computeCoords10(parsedEntity.buffer, dataBuffer);
                } else {
                    DataBufferHelper.computeCoords11(parsedEntity.buffer, dataBuffer);
                }
            }
        }
        if (this.fReader == null && this.fCharOffset == 0) {
            parsedEntity.setValues(dataBuffer, dataBuffer.startOffset, dataBuffer.endOffset, null);
            this.release();
        } else {
            parsedEntity.setValues(dataBuffer, dataBuffer.startOffset, dataBuffer.endOffset, this);
        }
        return parsedEntity.error;
    }

    public CharConversionError load(DataBuffer dataBuffer) {
        int n;
        block10: {
            byte[] byArray = dataBuffer.bytes;
            n = 0;
            int n2 = this.fBufferLength - 1;
            try {
                CharConversionError charConversionError;
                block11: {
                    do {
                        int n3 = n2 - this.fCharOffset;
                        int n4 = 0;
                        if (this.fReader != null) {
                            int n5 = this.fReader.read(this.fCharBuffer, this.fCharOffset, n3);
                            if (n5 == -1) {
                                this.fReader.close();
                                this.fReader = null;
                                if (this.fCharOffset == 0) break block10;
                                n4 = 0;
                            } else {
                                n4 = n5;
                            }
                        } else {
                            UntestedCode.needTest("unknown(13)");
                        }
                        charConversionError = UTF8Support.convertCharsToBytes(this.fCharBuffer, 0, n4 += this.fCharOffset, byArray, n, n2, this.fResultsPointer);
                        if (charConversionError != null) break block11;
                        this.fCharOffset = this.fResultsPointer[0];
                        n = this.fResultsPointer[1];
                        if (this.fCharOffset < n4) {
                            System.arraycopy(this.fCharBuffer, this.fCharOffset, this.fCharBuffer, 0, n4 - this.fCharOffset);
                            this.fCharOffset = n4 - this.fCharOffset;
                        } else {
                            this.fCharOffset = 0;
                        }
                        if (n + 4 >= n2) break block10;
                    } while (this.fReader != null);
                    if (this.fCharOffset > 0) {
                        UntestedCode.needTest("unknown(21)");
                        return CharConversionError.partialMultiPartCharacterSequence();
                    }
                    break block10;
                }
                UntestedCode.needTest("unknown(14)");
                return charConversionError;
            }
            catch (IOException iOException) {
                UntestedCode.needTest("unknown(24)");
                return CharConversionError.runtimeIOError(iOException);
            }
        }
        byArray[n] = 0;
        dataBuffer.startOffset = 0;
        dataBuffer.endOffset = n;
        return null;
    }

    @Override
    public void release() {
        if (this.fReader != null) {
            UntestedCode.needTest("unknown(26)");
            try {
                this.fReader.close();
                this.fReader = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fSourceFactory.releaseCharacterStreamDataSource(this);
    }
}

