/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.serializer;

import com.ibm.xml.xlxp.api.stax.serializer.StAXWriter;
import com.ibm.xml.xlxp.api.util.Pool;
import java.io.IOException;

public final class SingleByteWriter
extends StAXWriter {
    private static final Pool fPool = new Pool();

    public static final SingleByteWriter getInstance() {
        SingleByteWriter singleByteWriter = (SingleByteWriter)fPool.get();
        if (singleByteWriter == null) {
            singleByteWriter = new SingleByteWriter();
            fPool.assignToPool(singleByteWriter);
        }
        return singleByteWriter;
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.fNumBytes + n2 < this.fBuffer.length) {
            this.encodeAndWrite(cArray, n, n2);
        } else {
            this.flushInternal();
            int n3 = n + n2;
            while (n + this.fBuffer.length < n3) {
                this.encodeAndWrite(cArray, n, this.fBuffer.length);
                n += this.fBuffer.length;
                this.flushInternal();
            }
            this.encodeAndWrite(cArray, n, n3 - n);
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.fNumBytes == this.fBuffer.length) {
            this.flushInternal();
        }
        this.fBuffer[this.fNumBytes++] = (byte)n;
    }

    private void encodeAndWrite(char[] cArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; ++i) {
            this.fBuffer[this.fNumBytes++] = (byte)cArray[i];
        }
    }
}

