/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.events;

import com.ibm.xml.xlxp.api.stax.XMLStreamWriterImpl;
import com.ibm.xml.xlxp.api.util.ImmutableArrayList;
import com.ibm.xml.xlxp.api.util.ImmutableEmptyList;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class XMLEventImpl
implements XMLEvent {
    private final int fEventType;
    private final Location fLocation;
    private static final Location EMPTY_LOCATION = new Location(){

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }
    };

    public XMLEventImpl(int n) {
        this(n, null);
    }

    public XMLEventImpl(int n, Location location) {
        this.fEventType = n;
        this.fLocation = location == null ? EMPTY_LOCATION : new LocationClone(location.getCharacterOffset(), location.getColumnNumber(), location.getLineNumber(), location.getPublicId(), location.getSystemId());
    }

    @Override
    public final int getEventType() {
        return this.fEventType;
    }

    @Override
    public final Location getLocation() {
        return this.fLocation;
    }

    @Override
    public final boolean isStartElement() {
        return this.fEventType == 1;
    }

    @Override
    public final boolean isAttribute() {
        return this.fEventType == 10;
    }

    @Override
    public final boolean isNamespace() {
        return this.fEventType == 13;
    }

    @Override
    public final boolean isEndElement() {
        return this.fEventType == 2;
    }

    @Override
    public final boolean isEntityReference() {
        return this.fEventType == 9;
    }

    @Override
    public final boolean isProcessingInstruction() {
        return this.fEventType == 3;
    }

    @Override
    public final boolean isCharacters() {
        return this.fEventType == 4 || this.fEventType == 12 || this.fEventType == 6;
    }

    public final boolean isCData() {
        return this.fEventType == 12;
    }

    public final boolean isIgnorableWhiteSpace() {
        return this.fEventType == 6;
    }

    @Override
    public final boolean isStartDocument() {
        return this.fEventType == 7;
    }

    @Override
    public final boolean isEndDocument() {
        return this.fEventType == 8;
    }

    @Override
    public final StartElement asStartElement() {
        return (StartElement)((Object)this);
    }

    @Override
    public final EndElement asEndElement() {
        return (EndElement)((Object)this);
    }

    @Override
    public final Characters asCharacters() {
        return (Characters)((Object)this);
    }

    @Override
    public final QName getSchemaType() {
        return null;
    }

    @Override
    public abstract void writeAsEncodedUnicode(Writer var1) throws XMLStreamException;

    public static String escape(String string, int n) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = null;
        block12: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    if (n == 15) {
                        if (i + 1 < n2 && string.charAt(i + 1) == '#') {
                            stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&#38;");
                            continue block12;
                        }
                        if (stringBuffer == null) continue block12;
                        stringBuffer.append(c);
                        continue block12;
                    }
                    stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&amp;");
                    continue block12;
                }
                case '<': {
                    if (n != 15) {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&lt;");
                        continue block12;
                    }
                    if (stringBuffer == null) continue block12;
                    stringBuffer.append(c);
                    continue block12;
                }
                case '>': {
                    if (n == 4 && i >= 2 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&gt;");
                        continue block12;
                    }
                    if (stringBuffer == null) continue block12;
                    stringBuffer.append(c);
                    continue block12;
                }
                case '\"': {
                    if (n == 10 || n == 15) {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&quot;");
                        continue block12;
                    }
                    if (stringBuffer == null) continue block12;
                    stringBuffer.append(c);
                    continue block12;
                }
                case '%': {
                    if (n == 15) {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&#37;");
                        continue block12;
                    }
                    if (stringBuffer == null) continue block12;
                    stringBuffer.append(c);
                    continue block12;
                }
                case '\t': {
                    if (n == 10) {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&#9;");
                        continue block12;
                    }
                    if (stringBuffer == null) continue block12;
                    stringBuffer.append(c);
                    continue block12;
                }
                case '\n': {
                    if (n == 10) {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&#10;");
                        continue block12;
                    }
                    if (stringBuffer == null) continue block12;
                    stringBuffer.append(c);
                    continue block12;
                }
                case '\r': {
                    stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&#13;");
                    continue block12;
                }
                case '\u0085': {
                    stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&#133;");
                    continue block12;
                }
                case '\u2028': {
                    stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&#8232;");
                    continue block12;
                }
                default: {
                    if (c >= '\u0001' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                        stringBuffer = XMLEventImpl.append(stringBuffer, string, i, "&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        continue block12;
                    }
                    if (stringBuffer == null) continue block12;
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    private static StringBuffer append(StringBuffer stringBuffer, String string, int n, String string2) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }

    public void writeAsEncodedUnicode(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        if (xMLStreamWriter instanceof XMLStreamWriterImpl) {
            ((XMLStreamWriterImpl)xMLStreamWriter).writeAsEncodedUnicode(this);
        }
    }

    static List iteratorToList(Iterator iterator) {
        if (iterator == null || !iterator.hasNext()) {
            return ImmutableEmptyList.INSTANCE;
        }
        Object[] objectArray = new Object[8];
        int n = 0;
        while (iterator.hasNext()) {
            if (objectArray.length <= n) {
                Object[] objectArray2 = new Object[objectArray.length * 2];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray = objectArray2;
            }
            objectArray[n++] = iterator.next();
        }
        return new ImmutableArrayList(objectArray, n);
    }

    private static final class LocationClone
    implements Location {
        private final int characterOffset;
        private final int columnNumber;
        private final int lineNumber;
        private final String publicId;
        private final String systemId;

        private LocationClone(int n, int n2, int n3, String string, String string2) {
            this.characterOffset = n;
            this.columnNumber = n2;
            this.lineNumber = n3;
            this.publicId = string;
            this.systemId = string2;
        }

        @Override
        public int getCharacterOffset() {
            return this.characterOffset;
        }

        @Override
        public int getColumnNumber() {
            return this.columnNumber;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }
    }
}

