/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.util.AliasRange$AliasEnumeration;
import com.ibm.gsk.ikeyman.util.AliasRange$ValidationMode;
import com.ibm.gsk.ikeyman.util.StateMachineFactory;
import com.ibm.gsk.ikeyman.util.StateMachineFactory$AliasRangeParser;
import java.math.BigInteger;
import java.util.Enumeration;

public class AliasRange {
    private static final int DEFAULT_HEX_STRING_LENGTH = 18;
    private String aliasRange;
    private String[] components = null;

    public AliasRange(String string) {
        this.aliasRange = string;
    }

    public void validate(AliasRange$ValidationMode aliasRange$ValidationMode) throws KeyManagerException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (this.getComponents().length > 2 && (bigInteger2 = new BigInteger(this.getComponents()[1], 16)).compareTo(bigInteger = new BigInteger(this.getComponents()[2], 16)) >= 0) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ALIAS_RANGE_FORMAT, new String[]{this.aliasRange});
        }
        if (aliasRange$ValidationMode == AliasRange$ValidationMode.EKM && (this.getComponents()[1].length() > 18 || this.getComponents().length > 2 && this.getComponents()[2].length() > 18)) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ALIAS_RANGE_FORMAT, new String[]{this.aliasRange});
        }
    }

    public Enumeration getAliasEnumerator() throws KeyManagerException {
        return new AliasRange$AliasEnumeration(this);
    }

    public boolean containsAlias(String string) throws KeyManagerException {
        AliasRange aliasRange = new AliasRange(string);
        if (!aliasRange.getComponents()[0].equals(this.getComponents()[0])) {
            return false;
        }
        if (aliasRange.getComponents().length > 2) {
            return false;
        }
        BigInteger bigInteger = new BigInteger(aliasRange.getComponents()[1], 16);
        if (this.getComponents().length > 2) {
            BigInteger bigInteger2 = new BigInteger(this.getComponents()[1], 16);
            BigInteger bigInteger3 = new BigInteger(this.getComponents()[2], 16);
            return bigInteger.compareTo(bigInteger2) >= 0 && bigInteger.compareTo(bigInteger3) <= 0;
        }
        BigInteger bigInteger4 = new BigInteger(this.getComponents()[1], 16);
        return bigInteger.equals(bigInteger4);
    }

    private String[] getComponents() throws KeyManagerException {
        if (this.components == null) {
            StateMachineFactory$AliasRangeParser stateMachineFactory$AliasRangeParser = StateMachineFactory.getAliasRangeParser();
            for (int i = 0; i < this.aliasRange.length(); ++i) {
                try {
                    stateMachineFactory$AliasRangeParser.handle(Character.valueOf(this.aliasRange.charAt(i)));
                    continue;
                }
                catch (Exception exception) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_ALIAS_RANGE_FORMAT, new String[]{this.aliasRange});
                }
            }
            this.components = stateMachineFactory$AliasRangeParser.getHex2().equals("") ? new String[]{stateMachineFactory$AliasRangeParser.getPrefix(), stateMachineFactory$AliasRangeParser.getHex1()} : new String[]{stateMachineFactory$AliasRangeParser.getPrefix(), stateMachineFactory$AliasRangeParser.getHex1(), stateMachineFactory$AliasRangeParser.getHex2()};
        }
        return this.components;
    }

    static String[] access$000(AliasRange aliasRange) throws KeyManagerException {
        return aliasRange.getComponents();
    }
}

