/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.EntryBagFactory$AbstractKeyStoreBag;
import com.ibm.gsk.ikeyman.keystore.EntryBagFactory$PKCS11ImplKeyStoreBag$KeyEntry;
import com.ibm.gsk.ikeyman.keystore.EntryFilterFactory$EntryFilter;
import com.ibm.gsk.ikeyman.keystore.EntryMakerFactory$ExtendedEntryMaker;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory$KeyStoreProxy;
import com.ibm.gsk.ikeyman.keystore.ProtectionParameterCreatorFactory$ProtectionParameterCreator;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.util.ComparatorFactory;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.TypeDisplayerFactory$TypeDisplayer;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

class EntryBagFactory$PKCS11ImplKeyStoreBag
extends EntryBagFactory$AbstractKeyStoreBag {
    private final TypeDisplayerFactory$TypeDisplayer typeDisplayer;
    private final EntryMakerFactory$ExtendedEntryMaker entryMaker;

    public EntryBagFactory$PKCS11ImplKeyStoreBag(KeyStoreProxyCreatorFactory$KeyStoreProxy keyStoreProxyCreatorFactory$KeyStoreProxy, EntryFilterFactory$EntryFilter entryFilterFactory$EntryFilter, ProtectionParameterCreatorFactory$ProtectionParameterCreator protectionParameterCreatorFactory$ProtectionParameterCreator, TypeDisplayerFactory$TypeDisplayer typeDisplayerFactory$TypeDisplayer, String string, EntryMakerFactory$ExtendedEntryMaker extendedEntryMaker) throws KeyManagerException {
        super(keyStoreProxyCreatorFactory$KeyStoreProxy, entryFilterFactory$EntryFilter, protectionParameterCreatorFactory$ProtectionParameterCreator, string);
        this.typeDisplayer = typeDisplayerFactory$TypeDisplayer;
        this.entryMaker = extendedEntryMaker;
    }

    protected Entry makeEntry(String string) throws KeyManagerException {
        KeyStore.Entry entry;
        try {
            entry = this.loadEntry(string);
        }
        catch (NullPointerException nullPointerException) {
            try {
                if (!this.keyStore.getKeyStore().isKeyEntry(string)) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.NULL_POINTER, nullPointerException, new String[]{nullPointerException.getMessage()});
                }
                Key key = this.keyStore.getKeyStore().getKey(string, null);
                entry = new EntryBagFactory$PKCS11ImplKeyStoreBag$KeyEntry(this, (PrivateKey)key);
            }
            catch (KeyStoreException keyStoreException) {
                String string2 = KeymanUtil.getStackTraceString(keyStoreException);
                if (string2.contains("Illegal key size")) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)keyStoreException);
                }
                throw new KeyManagerException(KeyManagerException$ExceptionReason.ENTRY_LOAD_ERROR, keyStoreException, new String[]{string});
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.UNRECOVERABLE_KEY, unrecoverableKeyException, new String[]{string});
            }
        }
        Entry entry2 = this.makeEntry(string, entry);
        if (entry2 == null) {
            return null;
        }
        entry2.setDisplayer(this.typeDisplayer);
        return entry2;
    }

    private Entry makeEntry(String string, KeyStore.Entry entry) throws KeyManagerException {
        String string2 = this.getCertForAlias(string);
        KeyStore.Entry entry2 = null;
        if (string2 != null) {
            entry2 = this.loadEntry(string2);
        }
        return this.entryMaker.makeEntry(string, entry, entry2);
    }

    private KeyStore.Entry loadEntry(String string) throws KeyManagerException {
        try {
            return this.keyStore.getKeyStore().getEntry(string, this.protectionCreater.getParameter(this.password));
        }
        catch (KeyStoreException keyStoreException) {
            String string2 = KeymanUtil.getStackTraceString(keyStoreException);
            if (string2.contains("Illegal key size")) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)keyStoreException);
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.ENTRY_LOAD_ERROR, keyStoreException, new String[]{string});
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.UNRECOVERABLE_ENTRY, unrecoverableEntryException, new String[]{string});
        }
    }

    private String getCertForAlias(String string) throws KeyManagerException {
        ArrayList<String> arrayList;
        try {
            arrayList = Collections.list(this.keyStore.getKeyStore().aliases());
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
        for (String string2 : arrayList) {
            if (!string2.matches(string.toLowerCase() + "cert[\\d]+")) continue;
            return string2;
        }
        return null;
    }

    protected void refreshAliases() throws KeyManagerException {
        try {
            ArrayList<String> arrayList = Collections.list(this.keyStore.getKeyStore().aliases());
            this.aliases = new TreeSet(ComparatorFactory.newCollatedStringComparator());
            for (String string : arrayList) {
                String string2;
                if (string.matches(".+?cert[\\d]+") && arrayList.contains(string2 = string.substring(0, string.lastIndexOf("cert"))) || !this.entryFilter.isEntry(this.keyStore.getKeyStore(), string, this.password)) continue;
                this.aliases.add(string);
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)keyStoreException);
        }
    }

    protected void deleteAliaseswithLabel(String string) throws KeyManagerException {
        try {
            ArrayList<String> arrayList = Collections.list(this.keyStore.getKeyStore().aliases());
            for (String string2 : arrayList) {
                if (!string2.matches(string.toLowerCase() + "cert[\\d]+")) continue;
                this.keyStore.getKeyStore().deleteEntry(string2);
                this.keyStore.setHasChanged(true);
            }
            this.refreshAliases();
        }
        catch (KeyStoreException keyStoreException) {
            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)keyStoreException);
        }
    }

    public List getSupportedTypes() {
        return this.entryMaker.getSupportedTypes();
    }
}

