/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants$Actions;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogMode;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogResult;
import com.ibm.gsk.ikeyman.gui.panels.FileNamePanel;
import com.ibm.gsk.ikeyman.gui.panels.FileNamePanelFactory;
import com.ibm.gsk.ikeyman.gui.panels.FileNamePanelFactory$PanelType;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.FileName;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class FileNameDialog
extends CenteredDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private OKResetCancelButtonPanel buttonPanel = null;
    private FileNamePanel fileNamePanel = null;
    private GUIConstants$DialogMode mode;
    private FileNamePanelFactory$PanelType panelType;
    private FileName databaseName;

    public FileNameDialog(Frame frame, GUIConstants$DialogMode gUIConstants$DialogMode, FileNamePanelFactory$PanelType fileNamePanelFactory$PanelType, FileName fileName) {
        super(frame);
        this.mode = gUIConstants$DialogMode;
        this.setModal(true);
        this.panelType = fileNamePanelFactory$PanelType;
        this.databaseName = fileName;
        this.initialize();
        this.setTitle(FileNameDialog.getTitleString(gUIConstants$DialogMode));
    }

    private static String getTitleString(GUIConstants$DialogMode gUIConstants$DialogMode) {
        switch (gUIConstants$DialogMode) {
            case New: {
                return Messages.getString("GUI.Title.New");
            }
            case Open: {
                return Messages.getString("GUI.Title.Open");
            }
        }
        return "";
    }

    private void initialize() {
        this.setSize(667, 173);
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.getRootPane().setDefaultButton(this.buttonPanel.getOkBtn());
        this.centerToParent();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
            this.jContentPane.add((Component)this.getDatabaseNamePanel(), gridBagConstraints);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints2);
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(new GUIConstants$Actions[]{GUIConstants$Actions.OK, GUIConstants$Actions.Cancel});
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    protected void okHandler() {
        if (this.fileNamePanel.isValidInput()) {
            this.fileNamePanel.updateDefaultLocation();
            this.setDialogResult(GUIConstants$DialogResult.OK);
            this.setVisible(false);
        }
    }

    private FileNamePanel getDatabaseNamePanel() {
        if (this.fileNamePanel == null) {
            this.fileNamePanel = FileNamePanelFactory.newPanel(this.panelType, this.mode, this.databaseName);
        }
        return this.fileNamePanel;
    }

    public ParameterMap getParameters() throws KeyManagerException {
        return this.fileNamePanel.getParameters();
    }

    public static ParameterMap getFileData(Frame frame, GUIConstants$DialogMode gUIConstants$DialogMode, FileNamePanelFactory$PanelType fileNamePanelFactory$PanelType, FileName fileName) throws KeyManagerException, CancelledException {
        FileNameDialog fileNameDialog = new FileNameDialog(frame, gUIConstants$DialogMode, fileNamePanelFactory$PanelType, fileName);
        fileNameDialog.setVisible(true);
        try {
            if (fileNameDialog.getDialogResult() == GUIConstants$DialogResult.OK) {
                ParameterMap parameterMap = fileNameDialog.getParameters();
                return parameterMap;
            }
            throw new CancelledException();
        }
        finally {
            fileNameDialog.dispose();
        }
    }

    protected void resetHandler() {
    }
}

