/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.error;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason$Solution;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason$UserMessage;
import com.ibm.gsk.ikeyman.messages.ErrorMessages;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.text.MessageFormat;

public class ExceptionInfo {
    private String userMessage;
    private String solutionMessage;
    private String details;

    public ExceptionInfo(KeyManagerException keyManagerException) {
        this.userMessage = ExceptionInfo.getUserMessage(keyManagerException);
        this.solutionMessage = ExceptionInfo.getSolutionMessage(keyManagerException);
        this.details = Messages.getString("ExceptionInfo.ErrorCode") + keyManagerException.getReason().getErrorCode() + "\n" + ExceptionInfo.getDetails(keyManagerException);
    }

    public ExceptionInfo(Exception exception) {
        this.userMessage = Messages.getString("ExceptionInfo.UnexpectedException");
        this.solutionMessage = ErrorMessages.getString(KeyManagerException$ExceptionReason$Solution.ClearSolution.toString());
        this.details = ExceptionInfo.getDetails(exception);
    }

    public ExceptionInfo(Error error) {
        this.userMessage = Messages.getString("ExceptionInfo.UnexpectedException");
        this.solutionMessage = ErrorMessages.getString(KeyManagerException$ExceptionReason$Solution.ClearSolution.toString());
        this.details = ExceptionInfo.getDetails(error);
    }

    private static String getDetails(Throwable throwable) {
        return Messages.getString("ExceptionInfo.StackTrace") + KeymanUtil.getStackTraceString(throwable);
    }

    private static String getSolutionMessage(KeyManagerException keyManagerException) {
        KeyManagerException$ExceptionReason$Solution keyManagerException$ExceptionReason$Solution = keyManagerException.getReason().getSolution();
        if (keyManagerException$ExceptionReason$Solution == null) {
            keyManagerException$ExceptionReason$Solution = KeyManagerException$ExceptionReason$Solution.ClearSolution;
        }
        return MessageFormat.format(ErrorMessages.getString(keyManagerException$ExceptionReason$Solution.toString()), keyManagerException.getDetails());
    }

    private static String getUserMessage(KeyManagerException keyManagerException) {
        KeyManagerException$ExceptionReason$UserMessage keyManagerException$ExceptionReason$UserMessage = keyManagerException.getReason().getUserMessage();
        if (keyManagerException$ExceptionReason$UserMessage == null) {
            return keyManagerException.getReason().toString();
        }
        return MessageFormat.format(ErrorMessages.getString(keyManagerException$ExceptionReason$UserMessage.toString()), keyManagerException.getDetails());
    }

    public String getDetails() {
        return this.details;
    }

    public String getSolutionMessage() {
        return this.solutionMessage;
    }

    public String getUserMessage() {
        return this.userMessage;
    }
}

