/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command.gui;

import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.gui.KeymanController$Invoker;
import com.ibm.gsk.ikeyman.command.gui.KeymanView;
import com.ibm.gsk.ikeyman.command.gui.KeymanView$UpdateType;
import com.ibm.gsk.ikeyman.command.gui.RetrieverFactory;
import com.ibm.gsk.ikeyman.command.password.PasswordCallbackHandlerFactory;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.ExceptionInfo;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.error.NotImplementedException;
import com.ibm.gsk.ikeyman.event.CertificateChangeEvent;
import com.ibm.gsk.ikeyman.event.CertificateChangeListener;
import com.ibm.gsk.ikeyman.event.KeyManagerEvent;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.event.ProviderEvent;
import com.ibm.gsk.ikeyman.io.Logger;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.util.Debug;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class KeymanController
implements ActionListener,
CertificateChangeListener,
KeyManagerEventListener {
    private KeymanView view;
    private Frame parentFrame;

    public KeymanController(KeymanView keymanView, Frame frame) {
        this.view = keymanView;
        this.parentFrame = frame;
        CommandFactory.setCallbackHandler(PasswordCallbackHandlerFactory.getGUIHandler(frame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Debug.entering(new Object[]{actionEvent});
        this.view.setWaitStatus(true);
        try {
            Constants$CommandType constants$CommandType;
            try {
                constants$CommandType = Constants$CommandType.valueOf(actionEvent.getActionCommand());
                Debug.log("command type: {0}", new Object[]{constants$CommandType});
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            ParameterMap parameterMap = new ParameterMap();
            KeyManagerException keyManagerException = null;
            while (true) {
                try {
                    if (keyManagerException != null && !keyManagerException.isHandled()) {
                        Logger.showError(keyManagerException);
                        keyManagerException.setHandled(true);
                    }
                    this.view.setWaitStatus(false);
                    this.getParameters(constants$CommandType, parameterMap, keyManagerException);
                    Debug.log("map: {0}", new Object[]{parameterMap});
                    KeymanController$Invoker.invoke(parameterMap, this, this.view);
                    Debug.log("after invoke", new Object[0]);
                }
                catch (InternalKeyManagerException internalKeyManagerException) {
                    Debug.log("InternalKeyManagerException: {0}", new Object[]{internalKeyManagerException});
                }
                catch (NotImplementedException notImplementedException) {
                    Debug.log("NotImplementedException: {0}", new Object[]{notImplementedException});
                }
                catch (CancelledException cancelledException) {
                    Debug.log("CancelledException: {0}", new Object[]{cancelledException});
                }
                catch (KeyManagerException keyManagerException2) {
                    Debug.log("KeyManagerException: {0}", new Object[]{keyManagerException2});
                    keyManagerException = keyManagerException2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Logger.showError(exception);
        }
        catch (Error error) {
            Logger.showError(error);
        }
        finally {
            this.view.setWaitStatus(false);
        }
        Debug.exiting();
    }

    private void getParameters(Constants$CommandType constants$CommandType, ParameterMap parameterMap, KeyManagerException keyManagerException) throws CancelledException, KeyManagerException {
        if (keyManagerException == null) {
            this.getParameters(constants$CommandType, parameterMap);
        } else {
            this.getParametersAfterError(constants$CommandType, parameterMap, keyManagerException);
        }
    }

    private void getParameters(Constants$CommandType constants$CommandType, ParameterMap parameterMap) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{constants$CommandType, parameterMap});
        RetrieverFactory.get(constants$CommandType).getParameters(this.view, this.parentFrame, parameterMap);
        if (parameterMap.getCommandType() == null) {
            Debug.log("adding type: {0}", new Object[]{constants$CommandType});
            parameterMap.put(constants$CommandType);
        }
        Debug.exiting();
    }

    private void getParametersAfterError(Constants$CommandType constants$CommandType, ParameterMap parameterMap, KeyManagerException keyManagerException) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{constants$CommandType, parameterMap, keyManagerException});
        RetrieverFactory.get(constants$CommandType).getParametersAfterError(this.view, this.parentFrame, parameterMap, keyManagerException);
        if (parameterMap.getCommandType() == null) {
            Debug.log("adding type: {0}", new Object[]{constants$CommandType});
            parameterMap.put(constants$CommandType);
        }
        Debug.exiting();
    }

    public void certificateChanged(CertificateChangeEvent certificateChangeEvent) {
        block7: {
            Debug.entering(new Object[]{certificateChangeEvent});
            ParameterMap parameterMap = new ParameterMap();
            try {
                parameterMap.putAll(this.view.getSelectedDatabase().getDatabaseParameters(false));
                parameterMap.put(Constants$Parameter.Label, certificateChangeEvent.getLabel());
                switch (certificateChangeEvent.getType()) {
                    case DEFAULT_STATUS: {
                        if (!certificateChangeEvent.getValue()) {
                            throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.INVALID_DEFAULT_CHANGE, new String[]{certificateChangeEvent.getValue() + ""});
                        }
                        parameterMap.put(Constants$CommandType.SetDefaultCert);
                        break;
                    }
                    case TRUST_STATUS: {
                        parameterMap.put(Constants$Parameter.Trust, certificateChangeEvent.getValue());
                        parameterMap.put(Constants$CommandType.ModifyCert);
                    }
                }
                Debug.log("map: {0}", new Object[]{parameterMap});
                KeymanController$Invoker.invoke(parameterMap, this, this.view);
                Debug.log("after invoke", new Object[0]);
            }
            catch (KeyManagerException keyManagerException) {
                Debug.log("key manager exception: {0}", new Object[]{keyManagerException});
                if (keyManagerException.isHandled()) break block7;
                this.view.showStatusMessage(new ExceptionInfo(keyManagerException).getUserMessage());
                Logger.showError(keyManagerException);
            }
        }
        Debug.exiting();
    }

    public void databaseChanged(KeyManagerEvent keyManagerEvent) {
        Debug.entering(new Object[]{keyManagerEvent});
        this.updateView(keyManagerEvent.getKeyStoreInfo(), KeymanView$UpdateType.Changed);
        Debug.exiting();
    }

    public void databaseClosed(KeyManagerEvent keyManagerEvent) {
        Debug.entering(new Object[]{keyManagerEvent});
        this.updateView(keyManagerEvent.getKeyStoreInfo(), KeymanView$UpdateType.Closed);
        Debug.exiting();
    }

    public void databaseOpened(KeyManagerEvent keyManagerEvent) {
        Debug.entering(new Object[]{keyManagerEvent});
        this.updateView(keyManagerEvent.getKeyStoreInfo(), KeymanView$UpdateType.Opened);
        Debug.exiting();
    }

    public void providerAdded(ProviderEvent providerEvent) {
        Debug.entering(new Object[]{providerEvent});
        this.view.updateProviders(providerEvent.getProvider());
        Debug.exiting();
    }

    private void updateView(KeyStoreInfo keyStoreInfo, KeymanView$UpdateType keymanView$UpdateType) {
        Debug.entering(new Object[]{keyStoreInfo, keymanView$UpdateType});
        try {
            this.view.updateDatabase(keyStoreInfo, keymanView$UpdateType);
        }
        catch (KeyManagerException keyManagerException) {
            this.view.showStatusMessage(new ExceptionInfo(keyManagerException).getUserMessage());
            Logger.showError(keyManagerException);
            try {
                this.view.updateDatabase(keyStoreInfo, KeymanView$UpdateType.Closed);
            }
            catch (KeyManagerException keyManagerException2) {
                this.view.showStatusMessage(new ExceptionInfo(keyManagerException).getUserMessage());
                Logger.showError(keyManagerException);
            }
        }
        Debug.exiting();
    }
}

