/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory$ControlObject;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validatable;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validation;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceXorFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.io.IOException;

class CommandFactory$ChangeDbPasswordCommand
extends Command {
    public CommandFactory$ChangeDbPasswordCommand(ParameterMap parameterMap) {
        super(parameterMap, ValidatorFactory.newValidator(new ValidatorFactory$Validation[]{ValidatorFactory.required(Constants$Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.required(Constants$Parameter.NewPassword, ValidatorFactory.always()), ValidatorFactory.optional(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.Password, Constants$Parameter.Stashed}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Type, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Expire, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.StashPassword, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.StashV1Password, ValidatorFactory.always())}), null);
        Debug.entering();
        Debug.exiting();
    }

    public ControlObjectFactory$ControlObject run(CommandParameters commandParameters, KeyManagerEventListener keyManagerEventListener, Displayer displayer) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{commandParameters, keyManagerEventListener, displayer});
        CommandFactory.access$000(commandParameters.getDatabaseName());
        DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor = commandParameters.getSourceDescriptor(CommandFactory.access$200());
        KeyStoreItem keyStoreItem = this.getKeystoreItem(databaseDescriptorFactory$DatabaseDescriptor);
        keyStoreItem.changePassword(commandParameters);
        if ((databaseDescriptorFactory$DatabaseDescriptor.getType().equals(Constants$DatabaseType.PKCS12) || databaseDescriptorFactory$DatabaseDescriptor.getType().equals(Constants$DatabaseType.PKCS12S2)) && (commandParameters.isParameterPresent(Constants$Parameter.StashPassword) || KeymanSettings$Setting.DefaultPasswordStashingState.getBoolean().booleanValue())) {
            try {
                if (commandParameters.isParameterPresent(Constants$Parameter.StashV1Password) || KeymanSettings$Setting.DefaultPasswordV1StashingState.getBoolean().booleanValue()) {
                    ByteSequenceXorFactory.stashKeyDbPwd(commandParameters.getNewPassword(), CommandFactory.getStashFileName(commandParameters.getDatabaseName()), true, CommandFactory$ChangeDbPasswordCommand.isPasswordStashed());
                } else {
                    ByteSequenceXorFactory.stashKeyDbPwd(commandParameters.getNewPassword(), CommandFactory.getStashFileName(commandParameters.getDatabaseName()), false, CommandFactory$ChangeDbPasswordCommand.isPasswordStashed());
                }
            }
            catch (IOException iOException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR);
            }
        }
        CommandFactory.access$400(commandParameters.getDatabaseName());
        this.fireKeyManagerEventDatabaseChanged(keyManagerEventListener, keyStoreItem);
        Debug.exiting(null);
        return null;
    }
}

