/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom.transform;

import com.ibm.xml.crypto.dsig.Constants;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.Marshalling;
import com.ibm.xml.crypto.dsig.dom.NodeSetDataImpl;
import com.ibm.xml.crypto.dsig.dom.Unmarshalling;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import com.ibm.xml.crypto.dsig.dom.transform.XPathUtil;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathTransformer
extends TransformBase
implements Constants {
    private static FunctionTable m_functionTable = null;

    public XPathTransformer() {
        this.spec = null;
    }

    @Override
    public void init(TransformParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec == null || !(spec instanceof XPathFilterParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Need an XPathFilterParameterSpec instance");
        }
        this.spec = spec;
    }

    @Override
    public void marshalParams(XMLStructure parent, XMLCryptoContext xcontext) throws MarshalException {
        if (parent == null) {
            throw new NullPointerException();
        }
        if (!(parent instanceof DOMStructure)) {
            throw new ClassCastException("parent must be of type DOMStructure.");
        }
        Element el = (Element)((DOMStructure)parent).getNode();
        DOMCryptoContext dcontext = (DOMCryptoContext)xcontext;
        if (this.spec == null) {
            throw new MarshalException("Invalid state: no param");
        }
        XPathFilterParameterSpec xspec = (XPathFilterParameterSpec)this.spec;
        el.appendChild(this.marshalXPath(dcontext, el.getOwnerDocument(), xspec));
    }

    private Node marshalXPath(DOMCryptoContext dcontext, Document factory, XPathFilterParameterSpec spec) throws MarshalException {
        Element el;
        Map<String, String> map = spec.getNamespaceMap();
        if (map == null || map.size() == 0) {
            el = Marshalling.createElement(dcontext, factory, "http://www.w3.org/2000/09/xmldsig#", "XPath", false);
        } else {
            String prefix2 = TransformUtil.getAvailablePrefix(dcontext, "http://www.w3.org/2000/09/xmldsig#", "ds", map);
            String qname = prefix2.length() == 0 ? "XPath" : prefix2 + ":" + "XPath";
            el = factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", qname);
            qname = prefix2.length() == 0 ? "xmlns" : "xmlns:" + prefix2;
            el.setAttributeNS("http://www.w3.org/2000/xmlns/", qname, "http://www.w3.org/2000/09/xmldsig#");
            for (String prefix2 : map.keySet()) {
                qname = prefix2.length() == 0 ? "xmlns" : "xmlns:" + prefix2;
                el.setAttributeNS("http://www.w3.org/2000/xmlns/", qname, map.get(prefix2));
            }
        }
        el.appendChild(factory.createTextNode(spec.getXPath()));
        return el;
    }

    @Override
    public void init(XMLStructure parent, XMLCryptoContext xcontext) throws InvalidAlgorithmParameterException {
        XPathFilterParameterSpec spec;
        if (parent == null) {
            throw new NullPointerException("XMLStructure must not be null.");
        }
        Node xpathElement = null;
        Element node = ((DOMStructure)parent).getNode() instanceof Document ? ((Document)((DOMStructure)parent).getNode()).getDocumentElement() : (Element)((DOMStructure)parent).getNode();
        try {
            Node child = DOMUtil.getFirstChild2(node);
            while (child != null) {
                if (!Unmarshalling.isIgnorableNode(child)) {
                    if (child.getNodeType() != 1) {
                        throw new InvalidAlgorithmParameterException("XPath Filter does not support specified node: " + child.getNodeName());
                    }
                    if (!"http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI()) || !"XPath".equals(child.getLocalName())) {
                        throw new InvalidAlgorithmParameterException("XPath Filter does not support specified parameter element: " + child.getNodeName());
                    }
                    if (xpathElement != null) {
                        throw new InvalidAlgorithmParameterException("<ds:XPath> element is already processed.");
                    }
                    xpathElement = child;
                }
                child = DOMUtil.getNextSibling2(child);
            }
            spec = new XPathFilterParameterSpec(Unmarshalling.getStringValue(xpathElement), TransformUtil.makePrefixMap(xpathElement));
        }
        catch (MarshalException me) {
            throw new InvalidAlgorithmParameterException(me.getMessage());
        }
        this.init(spec);
    }

    @Override
    public Data transform(Data in, XMLCryptoContext xccontext) throws TransformException {
        NodeSetData nodeSet;
        if (in == null) {
            throw new NullPointerException("The Data parameter is null.");
        }
        try {
            nodeSet = this.toNodeSet(in, xccontext);
        }
        catch (Exception ex) {
            throw new TransformException(ex);
        }
        Iterator iter = nodeSet.iterator();
        if (!iter.hasNext()) {
            return new NodeSetDataImpl(iter);
        }
        Node input = (Node)iter.next();
        Document doc = input instanceof Document ? (Document)input : input.getOwnerDocument();
        Element hereNode = DOMUtil.getFirstChildElement(this.node);
        XPathContext xcontext = XPathUtil.createContext(hereNode, (DOMCryptoContext)xccontext);
        XPathFilterParameterSpec xspec = (XPathFilterParameterSpec)this.spec;
        Map<String, String> nscontext = xspec.getNamespaceMap();
        XPathUtil.MapPrefixResolver presolver = nscontext.size() > 0 ? new XPathUtil.MapPrefixResolver(nscontext) : new PrefixResolverDefault((Node)hereNode);
        LinkedList<Node> output = new LinkedList<Node>();
        try {
            XPath xpath = new XPath(xspec.getXPath(), null, (PrefixResolver)presolver, 0, null, m_functionTable);
            while (true) {
                XObject xobj;
                if ((xobj = xpath.execute(xcontext, input, (PrefixResolver)presolver)).bool()) {
                    output.add(input);
                }
                if (iter.hasNext()) {
                    input = (Node)iter.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
        return new NodeSetDataImpl(new TransformUtil.ListIterator(output));
    }

    private static void fixupFunctionTable() {
        Method installFunction;
        Class[] args2;
        boolean installed = false;
        try {
            args2 = new Class[]{String.class, Expression.class};
            installFunction = FunctionTable.class.getMethod("installFunction", args2);
            int modifier = installFunction.getModifiers();
            if ((modifier & 8) != 0) {
                Object[] params = new Object[]{"here", new XPathUtil.FuncHere()};
                installFunction.invoke(null, params);
                installed = true;
            }
        }
        catch (Throwable args2) {
            // empty catch block
        }
        if (!installed) {
            try {
                m_functionTable = new FunctionTable();
                args2 = new Class[]{String.class, Class.class};
                installFunction = FunctionTable.class.getMethod("installFunction", args2);
                Object[] params = new Object[]{"here", XPathUtil.FuncHere.class};
                installFunction.invoke((Object)m_functionTable, params);
                installed = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        XPathTransformer.fixupFunctionTable();
    }
}

