/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.EUC_KR;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.ISO2022;

public class ISO2022_KR
extends ISO2022
implements HistoricallyNamedCharset {
    private static Charset ksc5601_cs;

    public ISO2022_KR() {
        super("ISO-2022-KR", ExtendedCharsets.aliasesFor("ISO-2022-KR"));
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof EUC_KR || charset.name().equals("US-ASCII") || charset instanceof ISO2022_KR;
    }

    @Override
    public String historicalName() {
        return "ISO2022KR";
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends ISO2022.Decoder {
        public Decoder(Charset charset) {
            super(charset, "KR");
        }
    }

    private static class Encoder
    extends ISO2022.Encoder {
        public Encoder(Charset charset) {
            super(charset, "KR");
        }

        @Override
        public boolean canEncode(char c) {
            if ('\u20a9' == c) {
                return false;
            }
            return super.canEncode(c);
        }
    }
}

