/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.ext.DoubleByteDecoder;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.GB18030;

public class IBM1385
extends Charset {
    private static GB18030 Coder = new GB18030();

    public IBM1385() {
        super("x-IBM1385", ExtendedCharsets.aliasesFor("x-IBM1385"));
    }

    public String historicalName() {
        return "x-IBM1385";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof IBM1385;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        byte[] byArray = new byte[]{-95, -95};
        return new Encoder(this).replaceWith(byArray);
    }

    static /* synthetic */ GB18030 access$100() {
        return Coder;
    }

    public static class Decoder
    extends DoubleByteDecoder {
        private static final short[] index1 = IBM1385.access$100().getSubDecoderIndex1();
        private static final String[] index2 = IBM1385.access$100().getSubDecoderIndex2();
        private static final short[] sindex1 = IBM1385.access$100().getDecoderIndex1();
        private static final String[] sindex2 = IBM1385.access$100().getDecoderIndex2();

        public Decoder(Charset charset) {
            super(charset, index1, index2, 64, 254);
        }

        @Override
        protected char decodeSingle(int n) {
            return '\ufffd';
        }

        @Override
        public char decodeDouble(int n, int n2) {
            if (n < 0 || n > index1.length || n2 < this.start || n2 > this.end) {
                return '\ufffd';
            }
            int n3 = (index1[n] & 0xF) * (this.end - this.start + 1) + (n2 - this.start);
            if (n == 255 && n2 != 127) {
                return sindex2[index1[n] >> 4].charAt(n3);
            }
            return index2[index1[n] >> 4].charAt(n3);
        }
    }

    private static class Encoder
    extends GB18030.Encoder {
        private int ConvertType;
        private boolean islegal = true;

        private Encoder(Charset charset) {
            super(charset, 2.0f, 2.0f);
            ((GB18030.Encoder)this).ConvertType = 1;
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            if (this.islegal) {
                return true;
            }
            if (byArray.length == 1 && byArray[0] >= 0) {
                return true;
            }
            return super.isLegalReplacement(byArray);
        }
    }
}

