/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.PkCASetUp;
import com.ibm.security.certclient.util.PkNewCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.security.certclient.util.PkString;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import ibm.security.internal.interfaces.EdECPublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Vector;

public final class PkSsCertFactory
implements PkConstants {
    private PkSsCertFactory() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static PkSsCertificate newSsCert(String subjectDN) throws PkRejectionException {
        return new PkSsCertImpl(subjectDN, null);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(String subjectDN, Date notBefore) throws PkRejectionException {
        return new PkSsCertImpl(subjectDN, notBefore);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int keySize, String subjectDN, int numValidDays, boolean useRSA, boolean useShortSubjectKId, String provider) throws PkRejectionException {
        return new PkSsCertImpl(keySize, subjectDN, numValidDays, null, useRSA, useShortSubjectKId, provider);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int keySize, String subjectDN, int numValidDays, Date notBefore, boolean useRSA, boolean useShortSubjectKId, String provider) throws PkRejectionException {
        return new PkSsCertImpl(keySize, subjectDN, numValidDays, notBefore, useRSA, useShortSubjectKId, provider);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int keySize, String subjectDN, int numValidDays, boolean useRSA, boolean useShortSubjectKId, String provider, KeyPair keyPair) throws PkRejectionException {
        return new PkSsCertImpl(keySize, subjectDN, numValidDays, null, useRSA, useShortSubjectKId, provider, keyPair);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int keySize, String subjectDN, int numValidDays, Date notBefore, boolean useRSA, boolean useShortSubjectKId, String provider, KeyPair keyPair) throws PkRejectionException {
        return new PkSsCertImpl(keySize, subjectDN, numValidDays, notBefore, useRSA, useShortSubjectKId, provider, keyPair);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int keySize, String subjectDN, int numValidDays, boolean useRSA, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider) throws PkRejectionException {
        return new PkSsCertImpl(keySize, subjectDN, numValidDays, null, useRSA, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int keySize, String subjectDN, int numValidDays, Date notBefore, boolean useRSA, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider) throws PkRejectionException {
        return new PkSsCertImpl(keySize, subjectDN, numValidDays, notBefore, useRSA, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int keySize, String subjectDN, int numValidDays, boolean useRSA, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, KeyPair keyPair) throws PkRejectionException {
        return new PkSsCertImpl(keySize, subjectDN, numValidDays, null, useRSA, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider, keyPair, false);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int keySize, String subjectDN, int numValidDays, Date notBefore, boolean useRSA, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, KeyPair keyPair) throws PkRejectionException {
        return new PkSsCertImpl(keySize, subjectDN, numValidDays, notBefore, useRSA, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider, keyPair, false);
    }

    @Deprecated
    public static PkSsCertificate newSsCert(int keySize, String subjectDN, int numValidDays, Date notBefore, boolean useRSA, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, KeyPair keyPair, boolean CA) throws PkRejectionException {
        return new PkSsCertImpl(keySize, subjectDN, numValidDays, notBefore, useRSA, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider, keyPair, CA);
    }

    public static PkSsCertificate newSsCert(int keySize, String keyType, String signatureAlgorithm, String subjectDN, int numValidDays, Date notBefore, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, KeyPair keyPair, boolean CA) throws PkRejectionException {
        return new PkSsCertImpl(keySize, keyType, signatureAlgorithm, subjectDN, numValidDays, notBefore, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider, keyPair, CA);
    }

    public static SubjectAlternativeNameExtension createSubjectAltName(List<String> subjectAltNames, Debug debug, Object className) throws Exception {
        SubjectAlternativeNameExtension sub = null;
        if (subjectAltNames != null) {
            int i;
            String[] trimmedValues;
            GeneralNames gen = new GeneralNames();
            boolean altnameSpecified = false;
            int length = subjectAltNames.size();
            if (subjectAltNames.get(0) != null) {
                if (debug != null) {
                    debug.text(0L, className, "createSubjectAltName", "Processing {0}", (Object)subjectAltNames.get(0));
                }
                trimmedValues = PkNewCertFactory.getTrimmedSanValues(subjectAltNames.get(0));
                for (i = 0; i < trimmedValues.length; ++i) {
                    gen.addElement((Object)new RFC822Name(trimmedValues[i]));
                }
                altnameSpecified = true;
            }
            if (length > 1 && subjectAltNames.get(1) != null) {
                if (debug != null) {
                    debug.text(0L, className, "createSubjectAltName", "Processing {1}", (Object)subjectAltNames.get(1));
                }
                trimmedValues = PkNewCertFactory.getTrimmedSanValues(subjectAltNames.get(1));
                for (i = 0; i < trimmedValues.length; ++i) {
                    gen.addElement((Object)new DNSName(trimmedValues[i], true, true));
                }
                altnameSpecified = true;
            }
            if (length > 2 && subjectAltNames.get(2) != null) {
                if (debug != null) {
                    debug.text(0L, className, "createSubjectAltName", "Processing {2}", (Object)subjectAltNames.get(2));
                }
                trimmedValues = PkNewCertFactory.getTrimmedSanValues(subjectAltNames.get(2));
                for (i = 0; i < trimmedValues.length; ++i) {
                    gen.addElement((Object)new URIName(trimmedValues[i]));
                }
                altnameSpecified = true;
            }
            if (length > 3 && subjectAltNames.get(3) != null) {
                if (debug != null) {
                    debug.text(0L, className, "createSubjectAltName", "Processing {3}", (Object)subjectAltNames.get(3));
                }
                trimmedValues = PkNewCertFactory.getTrimmedSanValues(subjectAltNames.get(3));
                for (i = 0; i < trimmedValues.length; ++i) {
                    gen.addElement((Object)new IPAddressName(PkSsCertImpl.getIPAddress(trimmedValues[i])));
                }
                altnameSpecified = true;
            }
            if (altnameSpecified) {
                sub = new SubjectAlternativeNameExtension(gen);
            }
        } else if (debug != null) {
            debug.text(0L, className, "createSubjectAltName", "No subject Alt Names provided");
        }
        return sub;
    }

    private static final class PkSsCertImpl
    implements PkSsCertificate,
    PkConstants {
        private KeyPair ssKey;
        private X509Certificate ssCert;
        private Date notBefore;
        private byte[] ssKeyIdentifier = null;
        private static int OID_LIST_SIZE = 18;
        private static List<ObjectIdentifier> algList = new ArrayList<ObjectIdentifier>(OID_LIST_SIZE);
        private static Debug debug = Debug.getInstance((String)"keycertmanage");
        private static final Object className = "com.ibm.security.certclient.PkSsCertImpl";

        @Deprecated
        PkSsCertImpl(String subjectDN, Date nb) throws PkRejectionException {
            this(1024, subjectDN, 365, nb, true, false, null, null, null, "IBMJCE", null, false);
        }

        @Deprecated
        PkSsCertImpl(int keySize, String subjectDN, int numValidDays, Date nb, boolean useRSA, boolean useShortSubjectKId, String provider) throws PkRejectionException {
            this(keySize, subjectDN, numValidDays, nb, useRSA, useShortSubjectKId, null, null, null, provider, null, false);
        }

        @Deprecated
        PkSsCertImpl(int keySize, String subjectDN, int numValidDays, Date nb, boolean useRSA, boolean useShortSubjectKId, String provider, KeyPair keyPair) throws PkRejectionException {
            this(keySize, subjectDN, numValidDays, nb, useRSA, useShortSubjectKId, null, null, null, provider, keyPair, false);
        }

        @Deprecated
        PkSsCertImpl(int keySize, String subjectDN, int numValidDays, Date nb, boolean useRSA, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider) throws PkRejectionException {
            this(keySize, subjectDN, numValidDays, nb, useRSA, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider, null, false);
        }

        @Deprecated
        PkSsCertImpl(int keySize, String subjectDN, int numValidDays, Date nb, boolean useRSA, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, KeyPair keyPair, boolean CA) throws PkRejectionException {
            String keyType = "RSA";
            String signAlgorithm = "SHA1withRSA";
            if (keyPair == null) {
                if (!useRSA) {
                    keyType = "DSA";
                    signAlgorithm = "SHA1withDSA";
                }
            } else {
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("RSA")) {
                    signAlgorithm = "SHA1withRSA";
                }
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("DSA")) {
                    signAlgorithm = "SHA1withDSA";
                }
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("EC")) {
                    signAlgorithm = "SHA1withECDSA";
                }
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("EdDSA")) {
                    String curveName = ((EdECPublicKey)keyPair.getPublic()).getParams().getName();
                    if (curveName.equalsIgnoreCase("Ed25519")) {
                        signAlgorithm = "Ed25519";
                    } else if (curveName.equalsIgnoreCase("Ed448")) {
                        signAlgorithm = "Ed448";
                    }
                }
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("ML-DSA-44")) {
                    signAlgorithm = "ML-DSA-44";
                }
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("ML-DSA-65")) {
                    signAlgorithm = "ML-DSA-65";
                }
                if (keyPair.getPublic().getAlgorithm().equalsIgnoreCase("ML-DSA-87")) {
                    signAlgorithm = "ML-DSA-87";
                }
            }
            this.generateKeyPairNCert(keySize, keyType, signAlgorithm, subjectDN, numValidDays, nb, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider, keyPair, CA);
        }

        PkSsCertImpl(int keySize, String keyType, String signAlg, String subjectDN, int numValidDays, Date nb, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, KeyPair keyPair, boolean CA) throws PkRejectionException {
            this.generateKeyPairNCert(keySize, keyType, signAlg, subjectDN, numValidDays, nb, useShortSubjectKId, subjectAltNames, kUsage, extKUsage, provider, keyPair, CA);
        }

        void generateKeyPairNCert(int keySize, String keyType, String signatureAlg, String subjectDN, int numValidDays, Date nb, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extKUsage, String provider, KeyPair keyPair, boolean CA) throws PkRejectionException {
            X500Name subject = this.validSubject(subjectDN);
            this.notBefore = nb;
            this.ssKey = keyPair != null ? keyPair : this.generateLocalKey(keyType, keySize, "IBMSecureRandom", provider);
            this.ssCert = this.generateSsCertificate(2, signatureAlg, subject, this.ssKey.getPublic(), numValidDays, this.generateKID(useShortSubjectKId), subjectAltNames, kUsage, extKUsage, provider, CA);
            this.ssCertSign(signatureAlg, provider);
        }

        private byte[] generateKID(boolean shortFormKID) throws PkRejectionException {
            try {
                byte[] kIDTmp = PkCASetUp.computeKID(this.ssKey.getPublic(), shortFormKID);
                if (debug != null) {
                    debug.text(0L, className, "generateKID", "Subject Key Identifier is {0}", (Object)kIDTmp);
                }
                return kIDTmp;
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, nsae);
            }
        }

        private X500Name validSubject(String rawSubject) throws PkRejectionException {
            X500Name subject;
            try {
                subject = new X500Name(rawSubject);
                if (debug != null) {
                    debug.text(0L, className, "validSubject", "X500Name is {0}", (Object)subject);
                }
            }
            catch (IOException ex) {
                throw new PkRejectionException(PkNLSConstants.INVALID_SUBJECT_NAME, ex);
            }
            return subject;
        }

        private KeyPair generateLocalKey(String keyType, int keySz, String randomNoGenerator, String provider) throws PkRejectionException {
            KeyPair keyPair;
            int locKeySz;
            String locKeyType = keyType == null || keyType.length() == 0 ? "RSA" : keyType;
            int n = locKeySz = keySz == 0 ? 1024 : keySz;
            if (debug != null) {
                debug.text(0L, className, "generateLocalKey", "Keytype is {0}", (Object)locKeyType);
                debug.text(0L, className, "generateLocalKey", "Provider is {0}", (Object)provider);
                debug.text(0L, className, "generateLocalKey", "KeySize is {0}", (Object)new Integer(locKeySz));
            }
            if ("IBMJCEPlusFIPS".equalsIgnoreCase(provider) && "IBMSecureRandom".equalsIgnoreCase(randomNoGenerator)) {
                randomNoGenerator = "SHA2DRBG";
            }
            try {
                KeyPairGenerator keyPairGenerator = provider != null && provider.length() != 0 ? KeyPairGenerator.getInstance(locKeyType, provider) : KeyPairGenerator.getInstance(locKeyType);
                SecureRandom secureRandom = randomNoGenerator == null || randomNoGenerator.length() == 0 ? SecureRandom.getInstance("IBMJCE") : SecureRandom.getInstance(randomNoGenerator, "IBMJCE");
                if (debug != null) {
                    debug.text(0L, className, "generateLocalKey", "RNG is {0}", (Object)secureRandom);
                }
                keyPairGenerator.initialize(keySz, secureRandom);
                keyPair = keyPairGenerator.generateKeyPair();
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, nsae);
            }
            catch (NoSuchProviderException nspe) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PROVIDER, nspe);
            }
            catch (InvalidParameterException e) {
                throw new PkRejectionException(PkNLSConstants.INVALID_KEY_SIZE + keySz, e);
            }
            return keyPair;
        }

        private X509Certificate generateSsCertificate(int version, String signatureAlgorithm, X500Name subjectName, PublicKey key, int lifeSpan, byte[] kID, List<String> subjectAltNames, List<String> kUsage, List<String> extkUsage, String provider, boolean wantCA) throws PkRejectionException {
            X509CertImpl ssCert;
            BigInteger serial_no;
            AlgorithmId algId;
            String locProvider;
            X509CertInfo ssCertInfo = new X509CertInfo();
            if (debug != null) {
                debug.text(0L, className, "generateSsCertificate", "Version is {0}", (Object)new Integer(version));
            }
            if (version != 2) {
                throw new PkRejectionException(PkNLSConstants.X509_CERT_VERSION_INVALID);
            }
            if (debug != null) {
                debug.text(0L, className, "generateSsCertificate", "Validity Period is {0}", (Object)new Integer(lifeSpan));
            }
            if (lifeSpan <= 0) {
                throw new PkRejectionException(PkNLSConstants.VALIDITY_PERIOD_NOT_ALLOWED);
            }
            String string = locProvider = provider == null || provider.length() == 0 ? "IBMJCE" : provider;
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Signing algorithm is {0}", (Object)signatureAlgorithm);
                debug.text(0L, className, "createSubjectAltName", "Provider is {0}", (Object)locProvider);
            }
            try {
                algId = AlgorithmId.get((String)signatureAlgorithm, (String)locProvider);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, nsae);
            }
            ObjectIdentifier locOid = algId.getOID();
            if (!algList.contains(locOid)) {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_SIGNATURE_ALGORITHM);
            }
            Date date = new Date();
            Date date1 = new Date();
            if (this.notBefore != null) {
                Date currentDate = new Date();
                if (this.notBefore.getTime() < currentDate.getTime() - 259200000L) {
                    throw new PkRejectionException("notBefore Time cannot exceed more than 3 days prior to the UTC time");
                }
                date.setTime(this.notBefore.getTime());
                date1.setTime(this.notBefore.getTime());
            }
            date1.setTime(date1.getTime() + (long)(lifeSpan * 24 * 60 * 60) * 1000L);
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Start date {0}", (Object)date);
                debug.text(0L, className, "createSubjectAltName", "End date {0}", (Object)date1);
            }
            CertificateValidity certValidity = new CertificateValidity(date, date1);
            CertificateExtensions cexts = new CertificateExtensions();
            if (debug != null) {
                debug.text(0L, className, "createBasicConstraints", "Want CA {0}", Optional.of(wantCA));
            }
            try {
                ssCertInfo.set("version", (Object)new CertificateVersion(version));
                serial_no = BigInteger.valueOf(System.nanoTime());
                ssCertInfo.set("serialNumber", (Object)new CertificateSerialNumber(serial_no));
                ssCertInfo.set("algorithmID", (Object)new CertificateAlgorithmId(algId));
                ssCertInfo.set("subject", (Object)subjectName);
                ssCertInfo.set("issuer", (Object)subjectName);
                ssCertInfo.set("key", (Object)new CertificateX509Key(key));
                ssCertInfo.set("validity", (Object)certValidity);
                if (subjectAltNames != null && subjectAltNames.size() > 0) {
                    SubjectAlternativeNameExtension sane = PkSsCertFactory.createSubjectAltName(subjectAltNames, debug, className);
                    cexts.set("x509.info.extensions.SubjectAlternativeName", (Object)sane);
                }
                if (kID != null) {
                    this.ssKeyIdentifier = kID;
                    SubjectKeyIdentifierExtension skie = new SubjectKeyIdentifierExtension(kID);
                    cexts.set("x509.info.extensions.SubjectKeyIdentifier", (Object)skie);
                }
                if (kUsage != null && !kUsage.isEmpty()) {
                    KeyUsageExtension KUsage = this.setKeyUsageExt(kUsage);
                    cexts.set("x509.info.extensions.KeyUsage", (Object)KUsage);
                }
                if (wantCA) {
                    BasicConstraintsExtension basicConstraintsExt = new BasicConstraintsExtension(true, -1);
                    cexts.set("x509.info.extensions.BasicConstraints", (Object)basicConstraintsExt);
                }
                if (extkUsage != null && !extkUsage.isEmpty()) {
                    ExtKeyUsageExtension xKUsage = this.setextKeyUsageExt(extkUsage);
                    cexts.set("x509.info.extensions.ExtKeyUsage", (Object)xKUsage);
                }
                ssCertInfo.set("extensions", (Object)cexts);
            }
            catch (CertificateException ce) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, ce);
            }
            catch (IOException ioe) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, ioe);
            }
            catch (Exception ex) {
                throw new PkRejectionException(PkNLSConstants.INVALID_ATTRIBUTE, ex);
            }
            if (debug != null) {
                debug.text(0L, className, "createSubjectAltName", "Raw certificate request created with serial {0}", (Object)serial_no);
            }
            try {
                ssCert = new X509CertImpl(ssCertInfo, locProvider);
            }
            catch (CertificateParsingException cpe) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, cpe);
            }
            catch (CertificateEncodingException cee) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, cee);
            }
            return ssCert;
        }

        private KeyUsageExtension setKeyUsageExt(List<String> kUsage) throws IOException, PkRejectionException {
            KeyUsageExtension keyUsage = new KeyUsageExtension();
            for (String uKeyString : kUsage) {
                if (debug != null) {
                    debug.text(0L, className, "setKeyUsageExt", "Processing {0}", (Object)uKeyString);
                }
                if (uKeyString.equalsIgnoreCase("digital_signature")) {
                    keyUsage.set("digital_signature", (Object)Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("data_encipherment")) {
                    keyUsage.set("data_encipherment", (Object)Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("encipher_only")) {
                    keyUsage.set("encipher_only", (Object)Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("decipher_only")) {
                    keyUsage.set("decipher_only", (Object)Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("non_repudiation")) {
                    keyUsage.set("non_repudiation", (Object)Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("key_encipherment")) {
                    keyUsage.set("key_encipherment", (Object)Boolean.TRUE);
                    continue;
                }
                if (uKeyString.equalsIgnoreCase("key_agreement")) {
                    keyUsage.set("key_agreement", (Object)Boolean.TRUE);
                    continue;
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            return keyUsage;
        }

        private ExtKeyUsageExtension setextKeyUsageExt(List<String> extkUsage) throws IOException, PkRejectionException {
            ExtKeyUsageExtension extkeyUsage = null;
            Vector<ObjectIdentifier> v = new Vector<ObjectIdentifier>();
            for (String extUKeyString : extkUsage) {
                if (debug != null) {
                    debug.text(0L, className, "setextKeyUsageExt", "Processing {0}", (Object)extUKeyString);
                }
                if (extUKeyString.equalsIgnoreCase("ServerAuth_Id")) {
                    v.add(PKIXExtensions.ServerAuth_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("ClientAuth_Id")) {
                    v.add(PKIXExtensions.ClientAuth_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("CodeSigning_Id")) {
                    v.add(PKIXExtensions.CodeSigning_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("EmailProtection_Id")) {
                    v.add(PKIXExtensions.EmailProtection_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("IPSecEndSystem_Id")) {
                    v.add(PKIXExtensions.IPSecEndSystem_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("IPSecTunnel_Id")) {
                    v.add(PKIXExtensions.IPSecTunnel_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("IPSecUser_Id")) {
                    v.add(PKIXExtensions.IPSecUser_Id);
                    continue;
                }
                if (extUKeyString.equalsIgnoreCase("TimeStamping_Id")) {
                    v.add(PKIXExtensions.TimeStamping_Id);
                    continue;
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            if (v.size() > 0) {
                extkeyUsage = new ExtKeyUsageExtension(v);
            }
            return extkeyUsage;
        }

        static byte[] getIPAddress(String ipString) {
            String[] splitString = PkString.split(ipString, ".");
            byte[] ipAddress = new byte[]{new Integer(splitString[0]).byteValue(), new Integer(splitString[1]).byteValue(), new Integer(splitString[2]).byteValue(), new Integer(splitString[3]).byteValue()};
            return ipAddress;
        }

        private void ssCertSign(String signAlgorithm, String provider) throws PkRejectionException {
            if (debug != null) {
                debug.text(0L, className, "ssCertSign", "Signing with {0}", (Object)signAlgorithm);
            }
            try {
                ((X509CertImpl)this.ssCert).sign(this.ssKey.getPrivate(), signAlgorithm, provider);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, nsae);
            }
            catch (InvalidKeyException ike) {
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE, ike);
            }
            catch (NoSuchProviderException nspe) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PROVIDER, nspe);
            }
            catch (SignatureException se) {
                throw new PkRejectionException(PkNLSConstants.BAD_SS_CERT_SIGNATURE, se);
            }
            catch (CertificateException ce) {
                throw new PkRejectionException(PkNLSConstants.INVALID_CERTIFICATE, ce);
            }
            if (debug != null) {
                debug.text(0L, className, "ssCertSign", "Signed OK by provider {0}", (Object)provider);
            }
        }

        @Override
        public PrivateKey getKey() {
            return this.ssKey.getPrivate();
        }

        @Override
        public X509Certificate getCertificate() {
            return this.ssCert;
        }

        @Override
        public PublicKey getPublicKey() {
            return this.ssKey.getPublic();
        }

        @Override
        public String getSubjectName() {
            return this.ssCert.getSubjectDN().getName();
        }

        @Override
        public String getSigAlg() {
            return this.ssCert.getSigAlgName();
        }

        @Override
        public byte[] getSubjectKeyIdentifier() {
            return this.ssKeyIdentifier;
        }

        @Override
        public void setToKeyStore(String alias, String password, KeyStore ks) throws PkException {
            if (alias == null || alias.length() == 0) {
                throw new PkException(PkNLSConstants.HTTP_BAD_OR_MISSING_ALIAS);
            }
            if (ks == null) {
                throw new PkException(PkNLSConstants.MISSING_KEYSTORE);
            }
            if (password == null || password.length() == 0) {
                throw new PkException(PkNLSConstants.TUI_INVALIDPWD);
            }
            Certificate[] chain = new X509Certificate[]{this.ssCert};
            try {
                ks.setKeyEntry(alias, this.ssKey.getPrivate(), password.toCharArray(), chain);
            }
            catch (KeyStoreException ke) {
                throw new PkException(PkNLSConstants.EE_INVALID_CONFIG_KEYSTORE);
            }
        }

        static {
            algList.add(AlgorithmId.sha1WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha1WithRSAEncryption_OIW_oid);
            algList.add(AlgorithmId.sha1WithDSA_oid);
            algList.add(AlgorithmId.sha1WithDSA_OIW_oid);
            algList.add(AlgorithmId.shaWithDSA_OIW_oid);
            algList.add(AlgorithmId.md5WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha1WithECDSA_oid);
            algList.add(AlgorithmId.sha224WithECDSA_oid);
            algList.add(AlgorithmId.sha256WithECDSA_oid);
            algList.add(AlgorithmId.sha384WithECDSA_oid);
            algList.add(AlgorithmId.sha512WithECDSA_oid);
            algList.add(AlgorithmId.md2WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha256WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha384WithRSAEncryption_oid);
            algList.add(AlgorithmId.sha512WithRSAEncryption_oid);
            algList.add(AlgorithmId.Ed25519_oid);
            algList.add(AlgorithmId.Ed448_oid);
            algList.add(AlgorithmId.ml_DSA_44_oid);
            algList.add(AlgorithmId.ml_DSA_65_oid);
            algList.add(AlgorithmId.ml_DSA_87_oid);
        }
    }
}

