/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkEventFormatter;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class PkEeFactory {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "PkEeFactory";
    protected static String caDn = PkEeFactory.getThisLocalHost();
    protected static int caPort = 1077;
    protected static String keyStoreType = "jks";
    protected static char[] keystorePwd = null;
    protected static String keystoreFilename = "eeStore";
    protected static String provider = "IBMJCE";
    protected static String CA_DN = "";
    private static final String cmpFmt = "com.ibm.security.certclient.fmt.PkTcpV10CmpEventFormatter";
    protected static PkEventFormatter cmpEvntFmt = PkEeFactory.getFormatter("com.ibm.security.certclient.fmt.PkTcpV10CmpEventFormatter");

    public static String getCA_DN() {
        return CA_DN;
    }

    public static void setCA_DN(String ca_dn) {
        CA_DN = ca_dn;
    }

    public static String getCaDn() {
        return caDn;
    }

    public static void setCaDn(String caDn) {
        PkEeFactory.caDn = caDn;
    }

    public static int getCaPort() {
        return caPort;
    }

    public static void setCaPort(int caPort) {
        PkEeFactory.caPort = caPort;
    }

    public static String getKeystoreFilename() {
        return keystoreFilename;
    }

    public static void setKeystoreFilename(String keystoreFilename) {
        if (keystoreFilename != null && keystoreFilename.length() != 0) {
            PkEeFactory.keystoreFilename = keystoreFilename;
        }
    }

    public static void setKeystorePwd(char[] keystorePwd) {
        PkEeFactory.keystorePwd = keystorePwd;
    }

    public static String getKeyStoreType() {
        return keyStoreType;
    }

    public static void setKeyStoreType(String keyStoreType) {
        if (keyStoreType != null && keyStoreType.length() != 0) {
            PkEeFactory.keyStoreType = keyStoreType;
        }
    }

    public static String getProvider() {
        return provider;
    }

    public static void setProvider(String provider) {
        PkEeFactory.provider = provider;
    }

    public static PkEventFormatter getCmpFmt() {
        return cmpEvntFmt;
    }

    private static PkEventFormatter getFormatter(String name) {
        try {
            return (PkEventFormatter)Class.forName(name.trim()).newInstance();
        }
        catch (InstantiationException e) {
            debug.text(0L, className, "getFormatter", e.getMessage());
        }
        catch (ClassNotFoundException e) {
            debug.text(0L, className, "getFormatter", e.getMessage());
        }
        catch (IllegalAccessException e) {
            debug.text(0L, className, "getFormatter", e.getMessage());
        }
        return null;
    }

    private static String getThisLocalHost() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            return null;
        }
    }
}

