/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.ProgramOption;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

class MessageFile
extends ProgramOption {
    List messageFiles = new LinkedList();

    MessageFile() {
    }

    @Override
    String getDescription() {
        String eol = System.getProperty("line.separator", "\n");
        return "A comma separated list of files containing the trace format strings. By default the following files are used:" + eol + "  $JAVA_HOME/lib/J9TraceFormat.dat" + eol + "  $JAVA_HOME/lib/OMRTraceFormat.dat" + eol + "  $JAVA_HOME/lib/TraceFormat.dat";
    }

    @Override
    String getName() {
        return "datfile";
    }

    @Override
    String getUsage() {
        return "-datfile=file";
    }

    @Override
    Object getValue() {
        return this.messageFiles;
    }

    @Override
    void setValue(String value) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(value, ",");
        String token = "";
        try {
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                File datFile = new File(token);
                if (!datFile.exists()) {
                    throw new IllegalArgumentException("dat file \"" + token + "\" not found");
                }
                this.messageFiles.add(datFile);
            }
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("The application does not have permission to access the specified dat file, \"" + token + "\"");
        }
    }

    @Override
    void setDefault() {
        String dir = System.getProperty("java.home");
        dir = dir.concat(File.separator).concat("lib").concat(File.separator);
        this.setValue(dir + "J9TraceFormat.dat");
        this.setValue(dir + "OMRTraceFormat.dat");
        try {
            this.setValue(dir + "TraceFormat.dat");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Warning: " + e.getMessage());
        }
    }
}

