/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util.buffer;

import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.util.buffer.ByteBuffer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class SimpleByteBuffer
extends ByteBuffer {
    private final byte[] data;
    private int headCursor;
    private int tailCursor;
    private int availableData;
    private int availableSpace;

    public SimpleByteBuffer(int n) {
        this.data = this.allocByteArray(n);
        this.reset();
    }

    @Override
    public int getAvailableSpace() {
        return this.availableSpace;
    }

    @Override
    public int getSize() {
        return this.availableData;
    }

    @Override
    public ByteBuffer.Position getWritePosition() {
        ByteBuffer.Position position = this.getLastPosition();
        if (position != null && !position.equals(this, this.tailCursor)) {
            position = null;
        }
        if (position == null) {
            position = new ByteBuffer.Position(this, this.tailCursor);
        }
        return position;
    }

    @Override
    public int getWriteOffset() {
        return this.tailCursor;
    }

    @Override
    public void reset() {
        this.invalidateAllPositions();
        this.availableData = 0;
        this.tailCursor = 0;
        this.headCursor = 0;
        this.availableSpace = this.data.length;
    }

    private void incrementHead(int n) {
        this.headCursor += n;
        this.availableData -= n;
        this.invalidatePositions(this.headCursor);
    }

    private void incrementTail(int n) {
        this.tailCursor += n;
        this.availableData += n;
        this.availableSpace -= n;
    }

    @Override
    public int read() {
        int n = -1;
        if (this.availableData > 0) {
            n = this.data[this.headCursor];
            this.incrementHead(1);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        ByteBuffer.checkParams(byArray, n, n2);
        n2 = Math.min(n2, this.availableData);
        if (n2 > 0) {
            System.arraycopy(this.data, this.headCursor, byArray, n, n2);
            this.incrementHead(n2);
        }
        return n2;
    }

    @Override
    public void write(byte by) {
        if (this.availableSpace == 0) {
            throw new IndexOutOfBoundsException("The SimpleByteBuffer is full.");
        }
        this.data[this.tailCursor] = by;
        this.incrementTail(1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        ByteBuffer.checkParams(byArray, n, n2);
        if (this.availableSpace < n2) {
            String string = "Data to be copied (length " + n2 + ") exceeds space available (" + this.availableSpace + ")";
            throw new IndexOutOfBoundsException(string);
        }
        System.arraycopy(byArray, n, this.data, this.tailCursor, n2);
        this.incrementTail(n2);
    }

    @Override
    public void write(byte by, ByteBuffer.Position position, int n) {
        if (position == null) {
            this.write(by);
            return;
        }
        int n2 = position.getOffset() + n;
        ByteBuffer.checkUpdateByteParams(n2, this.tailCursor);
        this.data[n2] = by;
    }

    @Override
    public void write(byte[] byArray, int n, int n2, ByteBuffer.Position position, int n3) {
        if (position == null) {
            this.write(byArray, n, n2);
            return;
        }
        int n4 = position.getOffset() + n3;
        ByteBuffer.checkUpdateParams(byArray, n, n2, n4, this.tailCursor);
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.data, n4, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushTo(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                int n = 0;
                while (true) {
                    try {
                        outputStream.write(this.data, this.headCursor + n, this.availableData - n);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        n += interruptedIOException.bytesTransferred;
                        continue;
                    }
                    break;
                }
            }
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushTo(OutputStream outputStream, Connection connection) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            try {
                connection.stuckInWriteBlock = false;
                connection.inWriteBlock = true;
                this.flushTo(outputStream);
            }
            catch (IOException iOException) {
                if (connection.writeTimeoutOccured) {
                    IIOPOutputStream.SocketWriteTimeOutException socketWriteTimeOutException = new IIOPOutputStream.SocketWriteTimeOutException("Socket write timed out for connection to " + connection.getRemoteHost() + " at port " + connection.getRemotePort());
                    socketWriteTimeOutException.initCause(iOException);
                    throw socketWriteTimeOutException;
                }
                throw iOException;
            }
            finally {
                connection.inWriteBlock = false;
                connection.stuckInWriteBlock = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushTo(org.omg.CORBA.portable.OutputStream outputStream) {
        if (outputStream != null) {
            org.omg.CORBA.portable.OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                outputStream.write_long(this.availableData);
                outputStream.write_octet_array(this.data, this.headCursor, this.availableData);
            }
            this.reset();
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray;
        if (this.availableData == 0) {
            byArray = ByteBuffer.ZERO_BYTE_ARRAY;
        } else {
            byArray = this.allocByteArray(this.availableData);
            System.arraycopy(this.data, this.headCursor, byArray, 0, this.availableData);
        }
        return byArray;
    }

    @Override
    public byte[] toByteArrayFrom(ByteBuffer.Position position) {
        byte[] byArray;
        if (position == null || !position.isValid(this)) {
            byArray = ByteBuffer.ZERO_BYTE_ARRAY;
        } else {
            int n = position.getOffset();
            if (n == this.tailCursor) {
                byArray = ByteBuffer.ZERO_BYTE_ARRAY;
            } else {
                byArray = this.allocByteArray(this.tailCursor - n);
                System.arraycopy(this.data, n, byArray, 0, byArray.length);
            }
        }
        return byArray;
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter(this.availableData * 2);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = 0;
        int n2 = 0;
        int n3 = this.headCursor;
        for (int i = 0; i < this.availableData; i += n) {
            if (i + 16 > this.availableData) {
                n = Math.min(this.availableData - i, this.data.length - n3);
                if (n == this.availableData - i) {
                    n2 = 16 - n;
                }
            } else {
                n = 16;
            }
            ByteBuffer.writeHexString(printWriter, this.data, n3, n, n2);
            printWriter.println(new String(this.data, n3, n));
            n3 += n;
        }
        return stringWriter.toString();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }
}

