/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.rmi.io.ObjectSerializer;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.Serializer;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.omg.CORBA.NO_IMPLEMENT;

public class LinkedHashMapSerializer
extends ObjectSerializer {
    private static final LinkedHashMapSerializer instance = new LinkedHashMapSerializer();
    private static final ObjectStreamClass lhmOSC = ObjectStreamClass.lookup(LinkedHashMap.class);
    private static final long fieldOffset = lhmOSC.getField("accessOrder").getReflectField().getFieldOffset();

    private LinkedHashMapSerializer() {
        this.vTag = (byte)79;
    }

    public static final LinkedHashMapSerializer getInstance() {
        return instance;
    }

    @Override
    public final Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        boolean bl;
        LinkedHashMap linkedHashMap = (LinkedHashMap)object;
        if (Serializer.unsafe != null) {
            bl = unsafe.getBoolean(linkedHashMap, fieldOffset);
        } else {
            try {
                bl = (Boolean)lhmOSC.getField("accessOrder").getReflectField().get(linkedHashMap);
            }
            catch (IllegalAccessException illegalAccessException) {
                IOException iOException = new IOException(illegalAccessException.getMessage());
                iOException.initCause(illegalAccessException);
                throw iOException;
            }
        }
        encoderOutputStream.write_longInVarint(linkedHashMap.size());
        encoderOutputStream.write_boolean(bl);
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.writeToLoop(encoderOutputStream, k);
            this.writeToLoop(encoderOutputStream, v);
        }
        return null;
    }

    @Override
    public final Object read(EncoderInputStream encoderInputStream, Object linkedHashMap, ObjectStreamClass objectStreamClass) throws IOException {
        IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
        iIOPInputStream.incrementDepth();
        iIOPInputStream.incrementObjectReferences();
        iIOPInputStream.filterCheck(LinkedHashMap.class, -1);
        int n = encoderInputStream.read_longInVarint();
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap<Object, Object>();
            encoderInputStream.addToValueCache(linkedHashMap);
        }
        boolean bl = encoderInputStream.read_boolean();
        if (Serializer.unsafe != null) {
            unsafe.putBoolean(linkedHashMap, fieldOffset, bl);
        } else {
            try {
                bl = (Boolean)lhmOSC.getField("accessOrder").getReflectField().get(linkedHashMap);
            }
            catch (IllegalAccessException illegalAccessException) {
                IOException iOException = new IOException(illegalAccessException.getMessage());
                iOException.initCause(illegalAccessException);
                throw iOException;
            }
        }
        LinkedHashMap<Object, Object> linkedHashMap2 = linkedHashMap;
        for (int i = 0; i < n; ++i) {
            Object object = this.readFromLoop(encoderInputStream);
            Object object2 = this.readFromLoop(encoderInputStream);
            linkedHashMap2.put(object, object2);
        }
        iIOPInputStream.decrementDepth();
        return linkedHashMap2;
    }

    @Override
    public final Object writeFields(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public final Object readFields(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public final Object writeReferenceFields(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass, int n) {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public final Object readReferenceFields(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass, int n) {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public final Object writeFn(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }

    @Override
    public final Object readFn(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        throw new NO_IMPLEMENT("Not implemented for " + this.getClass().getName() + "Serializer");
    }
}

