/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.ArraySerializer;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.rmi.io.ObjectStreamClass;
import java.io.IOException;
import java.lang.reflect.Array;

public class JLCharacterArraySerializer
extends ArraySerializer {
    private static String CLASS = JLCharacterArraySerializer.class.getName();
    private static JLCharacterArraySerializer instance = new JLCharacterArraySerializer();

    private JLCharacterArraySerializer() {
        this.vTag = (byte)98;
    }

    public static JLCharacterArraySerializer getInstance() {
        return instance;
    }

    @Override
    public Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Character[] characterArray = (Character[])object;
        int n = characterArray.length;
        encoderOutputStream.write_longInVarint(n);
        for (Character c : characterArray) {
            this.writeCharacter(encoderOutputStream, c);
        }
        return null;
    }

    @Override
    public Object read(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Character[] characterArray = null;
        int n = encoderInputStream.read_longInVarint();
        IIOPInputStream iIOPInputStream = this.getIIOPInputStream(encoderInputStream);
        iIOPInputStream.incrementDepth();
        iIOPInputStream.incrementObjectReferences();
        iIOPInputStream.filterCheck(Character[].class, n);
        characterArray = (Character[])Array.newInstance(Character.class, n);
        encoderInputStream.addToValueCache(characterArray);
        for (int i = 0; i < n; ++i) {
            characterArray[i] = (Character)this.readCharacter(encoderInputStream);
        }
        iIOPInputStream.decrementDepth();
        return characterArray;
    }

    @Override
    public final boolean isludclPushrequired() {
        return false;
    }
}

