/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.giop.GIOPUtil;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.GIOPVersionException;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.util.Arrays;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import sun.misc.ObjectInputFilter;

class HeaderWalker
extends GIOPUtil {
    private static final String CLASS = HeaderWalker.class.getName();
    static final byte[] REQ_ORDER_1_0 = new byte[]{4, 0, 1, 6, 2, 3};
    static final byte[] REQ_ORDER_1_2 = new byte[]{0, 1, 7, 2, 4};
    static final byte[] REP_ORDER_1_0 = new byte[]{4, 0, 8};
    static final byte[] REP_ORDER_1_2 = new byte[]{0, 8, 4};
    static final byte[] LOC_REQ_ORDER_1_0 = new byte[]{0, 6};
    static final byte[] LOC_REQ_ORDER_1_2 = new byte[]{0, 7};
    static final byte[] LOC_REP_ORDER_1_0 = new byte[]{0, 5};
    static final byte[][] REQ_ORDER = new byte[][]{REQ_ORDER_1_0, REQ_ORDER_1_0, REQ_ORDER_1_2};
    static final byte[][] REP_ORDER = new byte[][]{REP_ORDER_1_0, REP_ORDER_1_0, REP_ORDER_1_2};
    static final byte[][] LOC_REQ_ORDER = new byte[][]{LOC_REQ_ORDER_1_0, LOC_REQ_ORDER_1_0, LOC_REQ_ORDER_1_2};
    static final byte[][] LOC_REP_ORDER = new byte[][]{LOC_REP_ORDER_1_0, LOC_REP_ORDER_1_0, LOC_REP_ORDER_1_0};
    static final short KEY_ADDR = 0;
    static final short PROFILE_ADDR = 1;
    static final short REFERENCE_ADDR = 2;
    static final Progress HEADER_WALK_COMPLETE = null;
    private int reqId = -1;
    private int msgSize;
    private boolean littleEndian;
    private boolean fragToFollow;
    private WsByteBuffer[] buffers;
    private int index = 0;
    private WsByteBuffer buffer;
    private int bytesRead = 0;
    private byte major;
    private byte minor;
    private byte msgType;
    private int repStat;
    private int furthestRead;
    short partnerExtended;
    byte readMode = 1;
    private Connection conn;
    ObjectInputFilter filter = ObjectInputFilter.Config.getSerialFilter();

    public HeaderWalker(Connection connection) {
        this.conn = connection;
    }

    protected void setGIOPHeaderData(HeaderWalker headerWalker) {
        this.buffer = headerWalker.buffer;
        this.buffers = headerWalker.buffers;
        this.bytesRead = headerWalker.bytesRead;
        this.conn = headerWalker.conn;
        this.fragToFollow = headerWalker.fragToFollow;
        this.furthestRead = headerWalker.furthestRead;
        this.index = headerWalker.index;
        this.littleEndian = headerWalker.littleEndian;
        this.major = headerWalker.major;
        this.minor = headerWalker.minor;
        if (this.conn != null) {
            this.partnerExtended = this.conn.getPartnerExtended();
        }
        this.msgSize = headerWalker.msgSize;
        this.msgType = headerWalker.msgType;
        this.repStat = headerWalker.repStat;
        this.reqId = headerWalker.reqId;
    }

    byte getMajor() {
        return this.major;
    }

    byte getMinor() {
        return this.minor;
    }

    boolean msgIsLittleEndian() {
        return this.littleEndian;
    }

    boolean msgHasFragmentToFollow() {
        return this.fragToFollow;
    }

    byte getMsgType() {
        return this.msgType;
    }

    String getMsgTypeName() {
        return GIOPUtil.messageTypeName(this.msgType);
    }

    int getRequestId() {
        return this.reqId;
    }

    int getMsgSize() {
        return this.msgSize;
    }

    int getReplyStatus() {
        assert (this.getMsgType() == 1);
        return this.repStat;
    }

    void setBuffers(WsByteBuffer[] wsByteBufferArray) {
        this.buffers = wsByteBufferArray;
        this.bytesRead = 0;
        this.furthestRead = 0;
        this.index = 0;
        this.buffer = this.buffers[this.index];
    }

    void rewindBuffers() {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "rewindBuffers:251");
            Trc.info(Trc.FINEST, "buffers=", Trc.array(this.buffers), CLASS, "rewindBuffers:253");
        }
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i] == null) continue;
            this.buffers[i].rewind();
        }
        this.furthestRead = Math.max(this.furthestRead, this.bytesRead);
        this.bytesRead = 0;
        this.index = 0;
        this.buffer = this.buffers[this.index];
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, "buffers=", Trc.array(this.buffers), CLASS, "rewindBuffers:265");
        }
    }

    WsByteBuffer[] getBuffers() {
        return this.buffers;
    }

    void forgetBuffers() {
        this.buffer = null;
        this.buffers = null;
    }

    void readGiopHeader() throws Exception {
        ObjectInputFilter.Status status;
        this.littleEndian = false;
        int n = this.getInt();
        if (n != 1195986768) {
            throw new GIOPVersionException("Bad GIOP magic:" + Integer.toHexString(n));
        }
        this.major = (byte)this.getByte();
        if (this.major <= 0 || this.major > 1) {
            throw new GIOPVersionException("Bad GIOP major:" + this.major);
        }
        this.minor = (byte)this.getByte();
        if (this.minor < 0 || this.minor > 2) {
            throw new GIOPVersionException("Bad GIOP minor:" + this.minor);
        }
        int n2 = this.getByte();
        this.littleEndian = (n2 & 1) == 1;
        boolean bl = this.fragToFollow = (n2 & 2) == 2;
        if (this.major == 1 && this.minor < 2 && this.fragToFollow) {
            throw new GIOPVersionException("GIOP " + this.major + "." + this.minor + " fragmentation not supported");
        }
        this.msgType = (byte)this.getByte();
        this.msgSize = this.getInt();
        if (this.filter != null && (status = this.filter.checkInput((ObjectInputFilter.FilterInfo)new IIOPInputStream.FilterValues(null, -1L, 0L, 0L, this.msgSize))) == ObjectInputFilter.Status.REJECTED) {
            throw new MARSHAL("filter status: REJECTED", 1229125809, CompletionStatus.COMPLETED_NO);
        }
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "msgType ", Trc.hex(this.msgType), " msgSize ", Trc.hex(this.msgSize), CLASS, "readGiopHeader:328");
        }
        switch (this.msgType) {
            case 7: {
                if (this.major < 2 && this.minor < 2) break;
            }
            case 2: {
                this.reqId = this.getInt();
            }
        }
    }

    protected boolean disableWalking() {
        return this.conn.partnerSendCompleteMsgHeader() || this.msgType != 7 && !this.fragToFollow;
    }

    Progress walkMessageHeader() throws Exception {
        if (this.disableWalking()) {
            if (this.fragToFollow && this.msgType != 7) {
                this.reqId = this.getInt();
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, "reqId ", Trc.str(this.reqId), " for first fragment disabled", CLASS, "walkMessageHeader:374");
                }
            }
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "disabled: msg has whole header=", Trc.str(this.conn.partnerSendCompleteMsgHeader()), ", msg type=", Trc.str(this.msgType), " fragToFollow=", Trc.str(this.fragToFollow), CLASS, "walkMessageHeader:382");
            }
            return HEADER_WALK_COMPLETE;
        }
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "walk msg header: fragToFollow=", Trc.str(this.fragToFollow), " partnerIsCFW=" + Trc.str(this.conn.partnerSendCompleteMsgHeader()), CLASS, "walkMessageHeader:389");
        }
        return this.resumableWalk(null);
    }

    void continueWalk(Progress progress) throws Exception {
        this.resumableWalk(progress);
    }

    private static byte[] findHeaderOrder(byte by, byte by2, byte by3) throws GIOPVersionException {
        byte[] byArray;
        switch (by3) {
            case 0: {
                byArray = REQ_ORDER[by2];
                break;
            }
            case 1: {
                byArray = REP_ORDER[by2];
                break;
            }
            case 3: {
                byArray = LOC_REQ_ORDER[by2];
                break;
            }
            case 4: {
                byArray = LOC_REP_ORDER[by2];
                break;
            }
            default: {
                throw new GIOPVersionException("Invalid GIOP Header: fragmentable " + HeaderWalker.messageTypeName(by3) + " message not allowed.");
            }
        }
        return byArray;
    }

    private static short swapBytes(short s) {
        return (short)((s & 0xFF00) >> 8 | (s & 0xFF) << 8);
    }

    private static int swapBytes(int n) {
        return (n & 0xFF000000) >>> 24 | (n & 0xFF0000) >> 8 | (n & 0xFF00) << 8 | (n & 0xFF) << 24;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Progress resumableWalk(Progress progress) throws Exception {
        byte[] byArray;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (progress == null) {
            n5 = 0;
            n4 = -1;
            n3 = -1;
            n2 = -1;
            n = -1;
            byArray = HeaderWalker.findHeaderOrder(this.major, this.minor, this.msgType);
        } else {
            progress.restore(false);
            n5 = progress.hSection;
            n = progress.hElements;
            n2 = progress.hBytesNeeded;
            n3 = progress.hDiscriminator;
            n4 = progress.hTag;
            byArray = HeaderWalker.findHeaderOrder(this.major, this.minor, progress.mType);
        }
        block13: while (n5 < byArray.length) {
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "expected.length=", Trc.str(byArray.length), " expected[", Trc.str(n5), "]=", Trc.str(byArray[n5]), CLASS, "resumableWalk:500");
            }
            block0 : switch (byArray[n5]) {
                case 0: {
                    if (this.cannotGetInt()) break block13;
                    this.reqId = this.getInt();
                    if (!Trc.enabled(2)) break;
                    Trc.info(Trc.FINEST, "reqId=", Trc.str(this.reqId), CLASS, "resumableWalk:508");
                    break;
                }
                case 5: 
                case 8: {
                    if (this.cannotGetInt()) break block13;
                    this.align(4);
                    this.repStat = this.getInt();
                    break;
                }
                case 1: {
                    if (n2 == -1) {
                        n2 = 4;
                    }
                    if ((n2 -= this.skipBytes(n2)) == 0) break;
                    break block13;
                }
                case 2: 
                case 3: 
                case 6: {
                    if (n2 == -1) {
                        if (this.cannotGetInt()) break block13;
                        n2 = this.getInt();
                    }
                    if ((n2 -= this.skipBytes(n2)) == 0) break;
                    break block13;
                }
                case 4: {
                    if (n == -1) {
                        if (this.cannotGetInt()) break block13;
                        n = this.getInt();
                    }
                    while (n > 0) {
                        if (n4 == -1) {
                            if (this.cannotGetInt()) break block13;
                            n4 = this.getInt();
                        }
                        if (n2 == -1) {
                            if (this.cannotGetInt()) break block13;
                            n2 = this.getInt();
                        }
                        if ((n2 -= this.skipBytes(n2)) != 0) break block13;
                        n4 = -1;
                        n2 = -1;
                        --n;
                    }
                    break;
                }
                case 7: {
                    if (n3 == -1) {
                        if (this.cannotGetShort()) break block13;
                        n3 = this.getShort();
                    }
                    switch (n3) {
                        case 0: {
                            if (n2 == -1) {
                                if (this.cannotGetInt()) break block13;
                                n2 = this.getInt();
                            }
                            if ((n2 -= this.skipBytes(n2)) == 0) break block0;
                            break block13;
                        }
                        case 1: {
                            if (n4 == -1) {
                                if (this.cannotGetInt()) break block13;
                                n4 = this.getInt();
                            }
                            if (n2 == -1) {
                                if (this.cannotGetInt()) break block13;
                                n2 = this.getInt();
                            }
                            if ((n2 -= this.skipBytes(n2)) == 0) break block0;
                            break block13;
                        }
                        case 2: {
                            if (n == -1) {
                                if (n4 == -1) {
                                    if (this.cannotGetInt()) break block13;
                                    n4 = this.getInt();
                                }
                                if (n2 == -1) {
                                    if (this.cannotGetInt()) break block13;
                                    n2 = this.getInt();
                                }
                                if ((n2 -= this.skipBytes(n2)) != 0 || this.cannotGetInt()) break block13;
                                n = this.getInt();
                                n4 = -1;
                                n2 = -1;
                            }
                            while (n > 0) {
                                if (n4 == -1) {
                                    if (this.cannotGetInt()) break block13;
                                    n4 = this.getInt();
                                }
                                if (n2 == -1) {
                                    if (this.cannotGetInt()) break block13;
                                    n2 = this.getInt();
                                }
                                if ((n2 -= this.skipBytes(n2)) != 0) break block13;
                                n4 = -1;
                                n2 = -1;
                                --n;
                            }
                            break block0;
                        }
                        default: {
                            throw new MARSHAL("Bad target discriminator in message header: addressing disposition = " + n3);
                        }
                    }
                }
            }
            n = -1;
            n2 = -1;
            n3 = -1;
            n4 = -1;
            ++n5;
        }
        boolean bl = n5 == byArray.length;
        this.checkProgress(progress, bl);
        if (bl) return progress;
        return this.updateProgress(progress, false, n5, n, n2, n3, n4);
    }

    static boolean isComplete(Progress progress) {
        return progress == null || progress.headerWalkComplete;
    }

    protected void checkProgress(Progress progress, boolean bl) throws Exception {
        if (bl) {
            if (progress != null) {
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, "Next fragment for ", HeaderWalker.messageTypeName(progress.mType), " message, request number ", Trc.str(this.reqId), " (header complete): ", Trc.hex(this.buffers), CLASS, "checkProgress:684");
                }
                progress.addCurrentBuffersAsNextFragment();
                progress.replaceCurrentBuffersWithFragmentSoFar();
                progress.headerWalkComplete = true;
            }
        } else {
            int n = this.msgSize + 12 - this.bytesRead;
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "remaining ", Trc.str(n), " fragToFollow ", Trc.str(this.fragToFollow), CLASS, "checkProgress:698");
            }
            assert (n == 0);
            assert (this.fragToFollow);
        }
    }

    protected Progress updateProgress(Progress progress, boolean bl, int n, int n2, int n3, int n4, int n5) throws Exception {
        if (progress == null) {
            progress = new Progress(bl);
            progress.update(n, n2, n3, n4, n5);
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "First fragment for ", HeaderWalker.messageTypeName(this.msgType), " message, request number ", Trc.str(this.reqId), " (header incomplete): ", Trc.hex(this.buffers), CLASS, "updateProgress:724");
            }
            progress.setCurrentBuffersAsFirstFragment();
        } else {
            progress.update(n, n2, n3, n4, n5);
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "Next fragment for ", HeaderWalker.messageTypeName(progress.mType), " message, request number ", Trc.str(this.reqId), " (header incomplete): ", Trc.hex(this.buffers), CLASS, "updateProgress:733");
            }
            progress.addCurrentBuffersAsNextFragment();
        }
        return progress;
    }

    private int getByte() {
        while (this.buffer.remaining() == 0) {
            this.advanceBufferOrThrow();
        }
        ++this.bytesRead;
        return 0xFF & this.buffer.get();
    }

    private byte peekByte() {
        while (this.buffer.remaining() == 0) {
            this.advanceBufferOrThrow();
        }
        return this.buffer.get(this.buffer.position());
    }

    private void put(byte by) {
        while (this.buffer.remaining() == 0) {
            this.advanceBufferOrThrow();
        }
        ++this.bytesRead;
        this.buffer.put(by);
    }

    private void advanceBufferOrThrow() {
        if (this.index < this.buffers.length - 1) {
            ++this.index;
        } else {
            Trc.ffdc("Cannot advance buffer: index=" + this.index + ", buffers=" + Trc.array(this.buffers) + ", current buffer=" + this.buffer, CLASS, "advanceBuffer2:780");
            Trc.ffdc("Call stack: " + Trc.stack(), CLASS, "advanceBuffer2:782");
            throw new IllegalStateException("Unexpected buffer deficit");
        }
        this.buffer = this.buffers[this.index];
    }

    private boolean advanceBuffer() {
        if (this.index < this.buffers.length - 1) {
            ++this.index;
            this.buffer = this.buffers[this.index];
            return true;
        }
        return false;
    }

    protected boolean cannotGetShort() {
        if (this.readMode == 1) {
            return !this.available(2, 2);
        }
        return !this.available(2, 1);
    }

    private short getShort() {
        short s;
        if (this.readMode == 1) {
            this.align(2);
        }
        if (this.buffer.remaining() >= 2) {
            s = this.buffer.getShort();
            this.bytesRead += 2;
        } else {
            s = (short)(this.getByte() << 8 | this.getByte());
        }
        return this.littleEndian ? HeaderWalker.swapBytes(s) : s;
    }

    protected boolean cannotGetInt() {
        if (this.readMode == 1) {
            return !this.available(4, 4);
        }
        return !this.available(1, 1);
    }

    protected int getInt() {
        int n;
        if (this.readMode == 0) {
            return this.getIntInVarint();
        }
        this.align(4);
        if (this.buffer.remaining() >= 4) {
            n = this.buffer.getInt();
            this.bytesRead += 4;
        } else {
            n = ((this.getByte() << 8 | this.getByte()) << 8 | this.getByte()) << 8 | this.getByte();
        }
        return this.littleEndian ? HeaderWalker.swapBytes(n) : n;
    }

    private int getIntInVarint() {
        int n = 0;
        int n2 = 0;
        while (true) {
            byte by = (byte)this.getByte();
            int n3 = by & 0x7F;
            n = (n3 <<= 7 * n2) + n;
            if ((by & 0x80) == 0) break;
            ++n2;
        }
        n = n >>> 1 ^ -(n & 1);
        return n;
    }

    private void put(int n) {
        this.align(4);
        if (this.littleEndian) {
            this.put((byte)n);
            this.put((byte)(n >> 8));
            this.put((byte)(n >> 16));
            this.put((byte)(n >> 24));
        } else {
            this.put((byte)(n >> 24));
            this.put((byte)(n >> 16));
            this.put((byte)(n >> 8));
            this.put((byte)n);
        }
    }

    protected int skipBytes(int n) {
        int n2;
        int n3 = 0;
        do {
            n2 = Math.min(n - n3, this.buffer.remaining());
            this.buffer.position(this.buffer.position() + n2);
        } while ((n3 += n2) != n && this.advanceBuffer());
        this.bytesRead += n3;
        return n3;
    }

    protected void skipToFurthestRead() {
        this.rewindBuffers();
        this.skipBytes(this.furthestRead);
    }

    protected boolean align(int n) {
        int n2 = this.padding(n);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "padding=", Trc.str(n2), "bytesRead=", Trc.str(this.bytesRead), CLASS, "align:940");
        }
        if (n2 == 0) {
            return true;
        }
        return n2 == this.skipBytes(n2);
    }

    private int padding(int n) {
        int n2 = n - 1;
        return n - (this.bytesRead & n2) & n2;
    }

    private boolean available(int n, int n2) {
        return this.msgSize + 12 >= this.bytesRead + this.padding(n2) + n;
    }

    final class Progress {
        final byte mType;
        final byte mMajor;
        final byte mMinor;
        private int mSize;
        protected int mRepStat;
        private WsByteBuffer[] mBuffers;
        private boolean mRepStatMode;
        private int mBytesRead;
        protected int hSection;
        protected int hElements;
        protected int hBytesNeeded;
        protected int hDiscriminator;
        protected int hTag;
        private boolean headerWalkComplete = false;

        private Progress(boolean bl) {
            this.mType = HeaderWalker.this.msgType;
            this.mMajor = HeaderWalker.this.major;
            this.mMinor = HeaderWalker.this.minor;
            this.mSize = HeaderWalker.this.msgSize;
            this.mRepStat = HeaderWalker.this.repStat;
            this.mRepStatMode = bl;
        }

        protected void restore(boolean bl) {
            HeaderWalker.this.major = this.mMajor;
            HeaderWalker.this.minor = this.mMinor;
            HeaderWalker.this.msgType = this.mType;
            HeaderWalker.this.repStat = this.mRepStat;
            this.mRepStatMode = bl;
        }

        private void update(int n, int n2, int n3, int n4, int n5) {
            this.hSection = n;
            this.hElements = n2;
            this.hBytesNeeded = n3;
            this.hDiscriminator = n4;
            this.hTag = n5;
        }

        protected void initData() {
            this.hSection = 0;
            this.hElements = -1;
            this.hBytesNeeded = -1;
            this.hDiscriminator = -1;
            this.hTag = -1;
        }

        private void setCurrentBuffersAsFirstFragment() {
            this.mBuffers = HeaderWalker.this.buffers;
            this.mBytesRead = HeaderWalker.this.bytesRead;
        }

        private void addCurrentBuffersAsNextFragment() throws Exception {
            Object[] objectArray;
            this.mSize += HeaderWalker.this.msgSize - 4;
            if (HeaderWalker.this.filter != null && (objectArray = HeaderWalker.this.filter.checkInput((ObjectInputFilter.FilterInfo)new IIOPInputStream.FilterValues(null, -1L, 0L, 0L, this.mSize))) == ObjectInputFilter.Status.REJECTED) {
                throw new MARSHAL("filter status: REJECTED", 1229125809, CompletionStatus.COMPLETED_NO);
            }
            this.mBytesRead += HeaderWalker.this.bytesRead;
            this.mBytesRead -= 16;
            HeaderWalker.this.rewindBuffers();
            HeaderWalker.this.skipBytes(16);
            objectArray = this.mBuffers;
            Object[] objectArray2 = HeaderWalker.this.buffers;
            int n = HeaderWalker.this.index;
            for (int i = 0; i < n; ++i) {
                objectArray2[i].release();
                objectArray2[i] = null;
            }
            WsByteBuffer[] wsByteBufferArray = objectArray2[n];
            objectArray2[n] = wsByteBufferArray.slice();
            wsByteBufferArray.release();
            int n2 = objectArray2.length - n;
            wsByteBufferArray = new WsByteBuffer[objectArray.length + n2];
            System.arraycopy(objectArray, 0, wsByteBufferArray, 0, objectArray.length);
            System.arraycopy(objectArray2, n, wsByteBufferArray, objectArray.length, n2);
            Arrays.fill(objectArray, null);
            Arrays.fill(objectArray2, null);
            this.mBuffers = wsByteBufferArray;
        }

        private void replaceCurrentBuffersWithFragmentSoFar() {
            boolean bl = !HeaderWalker.this.fragToFollow;
            HeaderWalker.this.setBuffers(this.mBuffers);
            HeaderWalker.this.rewindBuffers();
            if (bl) {
                HeaderWalker.this.skipBytes(6);
                byte by = HeaderWalker.this.peekByte();
                by = (byte)(by & 0xFFFFFFFD);
                HeaderWalker.this.put(by);
                HeaderWalker.this.skipBytes(1);
            } else {
                HeaderWalker.this.skipBytes(8);
            }
            HeaderWalker.this.msgSize = this.mSize;
            HeaderWalker.this.put(this.mSize);
            HeaderWalker.this.furthestRead = this.mBytesRead;
        }

        public boolean isReplyStatusMode() {
            return this.mRepStatMode;
        }

        int getCumulativeMessageSize() {
            return this.mSize;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("GIOP ").append(this.mMajor).append(".").append(this.mMinor).append(" ").append(GIOPUtil.messageTypeName(this.mType)).append(" header read progress {");
            stringBuffer.append("section=").append(this.hSection);
            if (this.hElements != -1) {
                stringBuffer.append(",elements=").append(this.hElements);
            }
            if (this.hBytesNeeded != -1) {
                stringBuffer.append(",bytesNeeded=").append(this.hBytesNeeded);
            }
            if (this.hDiscriminator != -1) {
                stringBuffer.append(",discriminator=").append(this.hDiscriminator);
            }
            if (this.hTag != -1) {
                stringBuffer.append(",tag=").append(this.hTag);
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }
}

