/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.ChannelTransportConnection;
import com.ibm.rmi.channel.giop.GIOPChannelConfig;
import com.ibm.rmi.channel.giop.GIOPConnection;
import com.ibm.rmi.channel.giop.GIOPConnectionTable;
import com.ibm.rmi.channel.giop.MessageReader;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.ORB;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.OutboundProtocolLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;

public class GIOPClientLink
extends OutboundProtocolLink {
    private static final String CLASS = GIOPClientLink.class.getName();
    private GIOPConnection giopConn = null;
    private GIOPChannelConfig giopConfig;
    private GIOPChannelPlugin giopPlugin;
    private Connection conn;
    private GIOPConnectionKey key;
    private GIOPConnectionTable connTable;

    public GIOPClientLink(VirtualConnection virtualConnection, GIOPChannelConfig gIOPChannelConfig) {
        this.init(virtualConnection);
        this.giopConfig = gIOPChannelConfig;
    }

    protected void postConnectProcessing(VirtualConnection virtualConnection) {
        TCPConnectionContext tCPConnectionContext = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, "local=", tCPConnectionContext.getLocalAddress().getHostName(), ":", Trc.str(tCPConnectionContext.getLocalPort()), " remote ", tCPConnectionContext.getRemoteAddress().getHostName(), ":", Trc.str(tCPConnectionContext.getRemotePort()), CLASS, "postConnectProcessing:125");
        }
        try {
            this.giopPlugin = this.giopConfig.getGIOPChannelPlugin();
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "postConnectProcessing:132");
        }
        ChannelTransportConnection channelTransportConnection = new ChannelTransportConnection(this.giopConfig.getOrb());
        this.giopConn = new GIOPConnection(virtualConnection, (ConnectionLink)this, this.conn, channelTransportConnection, this.giopConfig, this.giopPlugin, tCPConnectionContext);
        channelTransportConnection.setConnectionContext(this.giopConn);
        this.conn.setContext(channelTransportConnection, this.giopConn, this.key.getGIOPConnectionProfile());
        this.key.addConnection(this.giopConn);
        MessageReader messageReader = (MessageReader)this.giopConn.getReadInterface();
        try {
            messageReader.retrieveDataLater(12);
        }
        catch (IOException iOException) {
            Trc.ffdc(iOException, CLASS, "postConnectProcessing:153");
            this.giopConn.closeConnection(iOException);
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        this.giopConn.waitForPermissionToClose(exception);
        this.getDeviceLink().close(virtualConnection, exception);
    }

    public void destroy(Exception exception) {
    }

    public Object getChannelAccessor() {
        return this.giopConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object object) throws Exception {
        this.key = (GIOPConnectionKey)object;
        ORB oRB = this.giopConfig.getOrb();
        if (this.giopConfig.getOrb() == null) {
            this.giopConfig.setORBForChain(this.key);
            oRB = this.giopConfig.getOrb();
        }
        GIOPConnectionTable gIOPConnectionTable = this.connTable = this.giopConfig.getConnectionTable();
        synchronized (gIOPConnectionTable) {
            this.conn = this.connTable.getConnection(this.key);
            if (this.conn != null) {
                this.conn.checkEstablished();
                this.giopConn = (GIOPConnection)this.conn.getGiopConnCtx();
                this.getDeviceLink().close(this.vc, new Exception("cached GIOPConnection found"));
            } else {
                this.conn = new Connection(oRB, oRB.getServerGIOP(), false);
                this.connTable.addConnection(this.key, this.conn);
                try {
                    super.connect((Object)this.key);
                }
                catch (Exception exception) {
                    this.connTable.removeConnection(this.conn);
                    throw exception;
                }
            }
        }
    }
}

