/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.CodeSigner;
import java.security.Key;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sun.security.util.AnchorCertificates;
import sun.security.util.ConstraintsParameters;

public class JarConstraintsParameters
implements ConstraintsParameters {
    private boolean anchorIsJdkCA;
    private boolean anchorIsJdkCASet;
    private Date timestamp;
    private final Set<Key> keys = new HashSet<Key>();
    private final Set<X509Certificate> certsIssuedByAnchor = new HashSet<X509Certificate>();
    private String message;

    public JarConstraintsParameters(CodeSigner[] codeSignerArray) {
        Date date = null;
        boolean bl = false;
        for (CodeSigner codeSigner : codeSignerArray) {
            this.addToCertsAndKeys(codeSigner.getSignerCertPath());
            Timestamp timestamp = codeSigner.getTimestamp();
            if (timestamp == null) {
                date = null;
                bl = true;
                continue;
            }
            this.addToCertsAndKeys(timestamp.getSignerCertPath());
            if (bl) continue;
            Date date2 = timestamp.getTimestamp();
            if (date == null) {
                date = date2;
                continue;
            }
            if (!date.before(date2)) continue;
            date = date2;
        }
        this.timestamp = date;
    }

    public JarConstraintsParameters(List<X509Certificate> list, Timestamp timestamp) {
        this.addToCertsAndKeys(list);
        if (timestamp != null) {
            this.addToCertsAndKeys(timestamp.getSignerCertPath());
            this.timestamp = timestamp.getTimestamp();
        } else {
            this.timestamp = null;
        }
    }

    private void addToCertsAndKeys(CertPath certPath) {
        List<? extends Certificate> list = certPath.getCertificates();
        this.addToCertsAndKeys(list);
    }

    private void addToCertsAndKeys(List<X509Certificate> list) {
        if (!list.isEmpty()) {
            this.certsIssuedByAnchor.add(list.get(list.size() - 1));
            this.keys.add(list.get(0).getPublicKey());
        }
    }

    @Override
    public String getVariant() {
        return "generic";
    }

    @Override
    public boolean anchorIsJdkCA() {
        if (this.anchorIsJdkCASet) {
            return this.anchorIsJdkCA;
        }
        for (X509Certificate x509Certificate : this.certsIssuedByAnchor) {
            if (!AnchorCertificates.issuerOf(x509Certificate)) continue;
            this.anchorIsJdkCA = true;
            break;
        }
        this.anchorIsJdkCASet = true;
        return this.anchorIsJdkCA;
    }

    @Override
    public Date getDate() {
        return this.timestamp;
    }

    @Override
    public Set<Key> getKeys() {
        return this.keys;
    }

    public void setExtendedExceptionMsg(String string, String string2) {
        this.message = " used" + (string2 != null ? " with " + string2 : "") + " in " + string + " file.";
    }

    @Override
    public String extendedExceptionMsg() {
        return this.message;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[\n");
        stringBuilder.append("  Variant: ").append(this.getVariant());
        stringBuilder.append("\n  Certs Issued by Anchor:");
        for (X509Certificate serializable : this.certsIssuedByAnchor) {
            stringBuilder.append("\n    Cert Issuer: ").append(serializable.getIssuerX500Principal());
            stringBuilder.append("\n    Cert Subject: ").append(serializable.getSubjectX500Principal());
        }
        for (Key key : this.keys) {
            stringBuilder.append("\n  Key: ").append(key.getAlgorithm());
        }
        if (this.timestamp != null) {
            stringBuilder.append("\n  Timestamp: ").append(this.timestamp);
        }
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }
}

