/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http.spnego;

import com.ibm.security.jgss.ExtendedGSSContext;
import com.ibm.security.jgss.GSSCaller;
import com.ibm.security.jgss.GSSManagerImpl;
import com.ibm.security.jgss.GSSUtil;
import com.ibm.security.jgss.HttpCaller;
import com.ibm.security.krb5.internal.TlsChannelBindingImpl;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.Negotiator;
import sun.security.action.GetBooleanAction;
import sun.security.util.ChannelBindingException;
import sun.security.util.TlsChannelBinding;

public class NegotiatorImpl
extends Negotiator {
    private static final boolean DEBUG = AccessController.doPrivileged(new GetBooleanAction("sun.security.krb5.debug"));
    private GSSContext context;
    private byte[] oneToken;

    private void init(HttpCallerInfo httpCallerInfo) throws GSSException, ChannelBindingException {
        String string;
        Oid oid = httpCallerInfo.scheme.equalsIgnoreCase("Kerberos") ? GSSUtil.GSS_KRB5_MECH_OID : ((string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("http.auth.preference", "spnego");
            }
        })).equalsIgnoreCase("kerberos") ? GSSUtil.GSS_KRB5_MECH_OID : GSSUtil.GSS_SPNEGO_MECH_OID);
        string = new GSSManagerImpl((GSSCaller)new HttpCaller(httpCallerInfo));
        String string2 = "HTTP@" + httpCallerInfo.host.toLowerCase();
        GSSName gSSName = string.createName(string2, GSSName.NT_HOSTBASED_SERVICE);
        this.context = string.createContext(gSSName, oid, null, 0);
        if (this.context instanceof ExtendedGSSContext) {
            ((ExtendedGSSContext)this.context).requestDelegPolicy(true);
        }
        if (httpCallerInfo.serverCert != null) {
            if (DEBUG) {
                System.out.println("Negotiate: Setting CBT");
            }
            TlsChannelBinding tlsChannelBinding = TlsChannelBinding.create(httpCallerInfo.serverCert);
            this.context.setChannelBinding((ChannelBinding)new TlsChannelBindingImpl(tlsChannelBinding.getData()));
        }
        this.oneToken = this.context.initSecContext(new byte[0], 0, 0);
    }

    public NegotiatorImpl(HttpCallerInfo httpCallerInfo) throws IOException {
        try {
            this.init(httpCallerInfo);
        }
        catch (GSSException | ChannelBindingException exception) {
            if (DEBUG) {
                System.out.println("Negotiate support not initiated, will fallback to other scheme if allowed. Reason:");
                exception.printStackTrace();
            }
            try {
                this.disposeContext();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            IOException iOException = new IOException("Negotiate support not initiated");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    @Override
    public byte[] firstToken() {
        return this.oneToken;
    }

    @Override
    public byte[] nextToken(byte[] byArray) throws IOException {
        try {
            if (this.context == null) {
                throw new IOException("Negotiate support cannot continue. Context is invalidated");
            }
            return this.context.initSecContext(byArray, 0, byArray.length);
        }
        catch (GSSException gSSException) {
            if (DEBUG) {
                System.out.println("Negotiate support cannot continue. Reason:");
                gSSException.printStackTrace();
            }
            IOException iOException = new IOException("Negotiate support cannot continue");
            iOException.initCause(gSSException);
            throw iOException;
        }
    }

    @Override
    public void disposeContext() throws IOException {
        try {
            if (this.context != null) {
                this.context.dispose();
            }
        }
        catch (GSSException gSSException) {
            if (DEBUG) {
                System.out.println("Cannot release resources. Reason:");
                gSSException.printStackTrace();
            }
            throw new IOException("Cannot release resources", gSSException);
        }
        this.context = null;
    }
}

